/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.DepthParseException;

public final class DepthUnits
extends Enum<DepthUnits> {
    public static final /* enum */ DepthUnits M = new DepthUnits("metres", "m", 'M', new String[]{"m", "M"});
    public static final /* enum */ DepthUnits F = new DepthUnits("feet", "ft", 'F', new String[]{"'", "f", "F"});
    private final String abr;
    private final String fullName;
    private final char charType;
    private final String[] indicatorChars;
    public static final int DEFAULT_PRECISION = 2;
    private static final /* synthetic */ DepthUnits[] $VALUES;

    public static DepthUnits[] values() {
        return (DepthUnits[])$VALUES.clone();
    }

    public static DepthUnits valueOf(String name) {
        return Enum.valueOf(DepthUnits.class, name);
    }

    private DepthUnits(String fullName, String abr, char charType, String[] indicatorChars) {
        this.fullName = fullName;
        this.abr = abr;
        this.charType = charType;
        this.indicatorChars = indicatorChars;
    }

    public String toString() {
        return this.fullName;
    }

    public String getAbr() {
        return this.abr;
    }

    public char getChar() {
        return this.charType;
    }

    public String getIndicatorStr() {
        return this.indicatorChars[0];
    }

    public String getFullName() {
        return this.fullName;
    }

    public static DepthUnits getUnits(char units) {
        switch (units) {
            default: {
                return M;
            }
            case 'F': 
            case 'f': 
        }
        return F;
    }

    public static DepthUnits getAltUnits(DepthUnits units) {
        switch (units.ordinal()) {
            case 0: {
                return F;
            }
            default: {
                assert (false);
                break;
            }
            case 1: 
        }
        return M;
    }

    public static DepthUnits parseDepthUnitsFromString(String string) throws DepthParseException {
        DepthUnits.checkInchesInString(string);
        DepthUnits units = DepthUnits.getDepthUnitsFromString(string);
        if (units == null) {
            units = M;
        }
        return units;
    }

    public static boolean hasDepthUnitsInString(String string) throws DepthParseException {
        DepthUnits.checkInchesInString(string);
        return DepthUnits.getDepthUnitsFromString(string) != null;
    }

    private static void checkInchesInString(String string) throws DepthParseException {
        if (string.contains("\"")) {
            throw new DepthParseException("Attempt to parse feet & inches in string: " + string);
        }
    }

    private static DepthUnits getDepthUnitsFromString(String string) {
        for (DepthUnits units : DepthUnits.values()) {
            for (String unitIndicator : units.indicatorChars) {
                if (!string.contains(unitIndicator)) continue;
                return units;
            }
        }
        return null;
    }

    private static /* synthetic */ DepthUnits[] $values() {
        return new DepthUnits[]{M, F};
    }

    static {
        $VALUES = DepthUnits.$values();
    }
}

