/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.List;

public class FilePathUtils {
    public static String getFileExtension(String path) {
        int lastDirIndex;
        String ext = "";
        int lastDotIndex = path.lastIndexOf(46);
        if (lastDotIndex > (lastDirIndex = Math.max(path.lastIndexOf(47), path.lastIndexOf(92)))) {
            ext = path.substring(lastDotIndex + 1).toLowerCase();
        }
        return ext;
    }

    public static String appendExtensionIfNeccesary(String path, String extension) {
        if (!path.toLowerCase().endsWith("." + extension.toLowerCase())) {
            return path + "." + extension;
        }
        return path;
    }

    public static boolean isFileExtension(String path, String ... extensions) {
        String ext = FilePathUtils.getFileExtension(path);
        for (int i = 0; i < extensions.length; ++i) {
            if (!ext.equals(extensions[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileExtension(String path, List<String> extensions) {
        return FilePathUtils.isFileExtension(path, extensions.toArray(new String[extensions.size()]));
    }

    public static String extractFileNameWithoutExtension(String path) {
        int lastDirIndex = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        String fileName = path.substring(lastDirIndex + 1);
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return fileName.substring(0, lastDotIndex);
        }
        return fileName;
    }
}

