/*
 * Decompiled with CFR 0.152.
 */
package util;

public class FloatRange {
    private final float min;
    private final float max;

    public FloatRange(float min, float max) {
        if (min > max) {
            this.max = min;
            this.min = max;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    public boolean isInRange(float value) {
        return value >= this.min && value <= this.max;
    }

    public boolean overlapsThisRange(FloatRange other) {
        if (this.isInRange(other.getMin()) || this.isInRange(other.getMax())) {
            return true;
        }
        return other.getMin() <= this.min && other.getMax() >= this.max;
    }

    public FloatRange getOverlappingRange(FloatRange other) {
        if (!this.overlapsThisRange(other)) {
            return null;
        }
        return new FloatRange(Math.max(this.min, other.getMin()), Math.min(other.getMax(), this.max));
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getSize() {
        return this.max - this.min;
    }

    public float getMidpoint() {
        return this.min + this.getSize() * 0.5f;
    }

    public FloatRange shiftRange(float amount) {
        return new FloatRange(this.min + amount, this.max + amount);
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Float.floatToIntBits(this.min);
        hash = 41 * hash + Float.floatToIntBits(this.max);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatRange other = (FloatRange)obj;
        if (Float.floatToIntBits(this.min) != Float.floatToIntBits(other.min)) {
            return false;
        }
        return Float.floatToIntBits(this.max) == Float.floatToIntBits(other.max);
    }

    public String toString() {
        return this.min + "f -> " + this.max + "f";
    }
}

