/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.DataBufferInt;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import javax.swing.ImageIcon;

public class ImageUtils {
    public static BufferedImage convertImageToBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            switch (bi.getType()) {
                case 1: 
                case 5: {
                    return bi;
                }
            }
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
        Graphics2D bGr = bufferedImage.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bufferedImage;
    }

    public static BufferedImage convertIconToIntARGBBufferedImage(ImageIcon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = bufferedImage.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return bufferedImage;
    }

    public static RenderedImage readTifImageFromPath(String path) throws IOException {
        FileSeekableStream s = new FileSeekableStream(new File(path));
        ImageDecodeParam param = null;
        ImageDecoder dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)s, param);
        return dec.decodeAsRenderedImage(0);
    }

    public static ByteArrayOutputStream buildByteStreamFromImage(Image image) throws IOException {
        BufferedImage bufferedImage = ImageUtils.convertImageToBufferedImage(image);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", os);
        return os;
    }

    public static ImageIcon readImageIcon(String path) throws IOException {
        ImageIcon imageIcon;
        if (path.toLowerCase().contains(".tif")) {
            RenderedImage op = ImageUtils.readTifImageFromPath(path);
            imageIcon = new ImageIcon(PlanarImage.wrapRenderedImage((RenderedImage)op).getAsBufferedImage());
        } else {
            imageIcon = new ImageIcon(path);
        }
        return imageIcon;
    }

    public static Image readImage(String path) throws IOException {
        if (path.toLowerCase().contains(".tif")) {
            RenderedImage op = ImageUtils.readTifImageFromPath(path);
            return PlanarImage.wrapRenderedImage((RenderedImage)op).getAsBufferedImage();
        }
        return Toolkit.getDefaultToolkit().createImage(path);
    }

    public static Image cropImage(Image image, int x, int y, int width, int height) {
        Image i = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(x, y, width, height)));
        return i;
    }

    public static void replaceColourInImage(BufferedImage bi, Color from, Color to) {
        int[] pixels = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < bi.getHeight(); ++y) {
            for (int x = 0; x < bi.getWidth(); ++x) {
                int color = bi.getRGB(x, y);
                String s = Integer.toHexString(color);
                int blue = color & 0xFF;
                int green = (color & 0xFF00) >> 8;
                int red = (color & 0xFF0000) >> 16;
                int alpha = (color & 0xFF000000) >>> 24;
                if (blue != from.getBlue() || green != from.getGreen() || red != from.getRed() || alpha == 0) continue;
                bi.setRGB(x, y, to.getRGB());
            }
        }
    }

    public static boolean compareImages(Image image1, Image image2) throws IOException {
        if (image1 == null || image2 == null) {
            return false;
        }
        ByteArrayOutputStream bos1 = ImageUtils.buildByteStreamFromImage(image1);
        byte[] rhsByteStream = ImageUtils.buildByteStreamFromImage(image2).toByteArray();
        ImageIcon rhsImageIcon = new ImageIcon(rhsByteStream);
        ByteArrayOutputStream bos2 = ImageUtils.buildByteStreamFromImage(rhsImageIcon.getImage());
        if (bos1.size() != bos2.size()) {
            return false;
        }
        byte[] b1 = bos1.toByteArray();
        byte[] b2 = bos2.toByteArray();
        for (int i = 0; i < bos1.size(); ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

