/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import util.SBException;
import util.SortEntry;

public class MatchData<T extends SortEntry> {
    private final List<MatchPair> data = new ArrayList<MatchPair>();

    public int size() {
        return this.data.size();
    }

    public MatchPair get(int row) {
        return this.data.get(row);
    }

    public void init(List<T> ws, List<T> db) throws SBException, SQLException {
        this.data.clear();
        if (ws != null) {
            this.data.addAll(ws.stream().map(wsT -> new MatchPair<Object>(wsT, null)).toList());
        }
        if (db != null) {
            for (SortEntry dbT : db) {
                boolean added = false;
                for (MatchPair m : this.data) {
                    if (m.ws == null || !m.ws.isFuncEquivalent(dbT)) continue;
                    m.db = dbT;
                    added = true;
                    break;
                }
                if (added) continue;
                this.data.add(new MatchPair<SortEntry>(null, dbT));
            }
        }
        Collections.sort(this.data);
    }

    public static class MatchPair<T extends SortEntry>
    implements Comparable<MatchPair<T>> {
        T ws;
        T db;

        private MatchPair(T ws, T db) {
            this.ws = ws;
            this.db = db;
        }

        public String getSortEntry() {
            if (this.ws != null) {
                return this.ws.getSortEntry();
            }
            if (this.db != null) {
                return this.db.getSortEntry();
            }
            return null;
        }

        public T getWs() {
            return this.ws;
        }

        public T getDb() {
            return this.db;
        }

        @Override
        public int compareTo(MatchPair<T> o) {
            return this.getSortEntry().compareTo(o.getSortEntry());
        }
    }
}

