/*
 * Decompiled with CFR 0.152.
 */
package util.gridreader;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class CSVGridReader
extends GridReader {
    private final String fileName;
    private BufferedReader in;
    private String delim;
    private String lineBuff;
    private String[] cell;
    private int nCell;

    CSVGridReader(String fileName) throws GridReaderException {
        this.fileName = fileName;
        try {
            this.in = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException ex) {
            throw new GridReaderException("Text file not found", ex);
        }
    }

    @Override
    public boolean nextRow() throws GridReaderException {
        try {
            this.lineBuff = this.in.readLine();
            if (this.lineBuff == null) {
                return false;
            }
            if (this.lineBuff.length() > 0 && this.delim == null) {
                this.delim = this.parseDelim(this.lineBuff);
            }
            if (this.delim == null) {
                this.cell = null;
                return true;
            }
            this.cell = this.lineBuff.split(this.delim);
            this.nCell = 0;
            return true;
        }
        catch (IOException ioe) {
            throw new GridReaderException("Error reading file", ioe);
        }
    }

    private String parseDelim(String buff) {
        String delims = ",;\t";
        int[] nOccs = new int[delims.length()];
        for (int i = 0; i < buff.length(); ++i) {
            for (int j = 0; j < delims.length(); ++j) {
                if (buff.charAt(i) != delims.charAt(j)) continue;
                int n = j;
                nOccs[n] = nOccs[n] + 1;
            }
        }
        int pop = -1;
        int popSize = 0;
        for (int j = 0; j < delims.length(); ++j) {
            if (nOccs[j] <= popSize) continue;
            pop = j;
            popSize = nOccs[j];
        }
        if (pop >= 0) {
            return "" + delims.charAt(pop);
        }
        return null;
    }

    @Override
    public String getNextCell() throws GridReaderException {
        return this.getNextCell(false);
    }

    @Override
    public String getNextCell(boolean ignoreZeros) throws GridReaderException {
        Object strg;
        if (this.cell == null || this.nCell >= this.cell.length) {
            return null;
        }
        if (this.cell[this.nCell] == null) {
            return "";
        }
        if (((String)(strg = this.cell[this.nCell++])).length() > 0 && ((String)strg).charAt(0) == '\"' && !((String)strg).substring(1, ((String)strg).length() - 1).contains("\"")) {
            while (((String)strg).charAt(((String)strg).length() - 1) != '\"') {
                if (this.nCell >= this.cell.length) {
                    throw new GridReaderException("Cannot find closing quote on line: " + this.lineBuff + " at cell: " + (String)strg, null);
                }
                strg = (String)strg + this.cell[this.nCell++];
            }
            strg = ((String)strg).substring(1, ((String)strg).length() - 1);
        }
        return ((String)strg).trim();
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void rewind() throws GridReaderException {
        try {
            this.in.close();
            this.in = new BufferedReader(new FileReader(this.fileName));
        }
        catch (FileNotFoundException ex) {
            throw new GridReaderException("Error re-opening text file", ex);
        }
        catch (IOException ioe) {
            throw new GridReaderException("Error closing text file", ioe);
        }
    }
}

