/*
 * Decompiled with CFR 0.152.
 */
package util.gridreader;

import util.gridreader.CSVGridReader;
import util.gridreader.GridReaderException;
import util.gridreader.XLSGridReader;

public abstract class GridReader {
    public abstract boolean nextRow() throws GridReaderException;

    public abstract String getNextCell() throws GridReaderException;

    public abstract String getNextCell(boolean var1) throws GridReaderException;

    public abstract void close();

    public abstract String getFileName();

    public abstract void rewind() throws GridReaderException;

    public static GridReader getGridReader(String fileName, String workSheetName) throws GridReaderException {
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            XLSGridReader r = new XLSGridReader(fileName);
            r.setSheet(workSheetName);
            return r;
        }
        return new CSVGridReader(fileName);
    }
}

