/*
 * Decompiled with CFR 0.152.
 */
package util.gridwriter;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.CellDataFormat;
import util.gridwriter.GridCell;

public class CSVWriter {
    private char delimiter;
    private final String newline = "\r\n";
    private NumberFormat nf;
    private SimpleDateFormat dateFormat = new SimpleDateFormat(CellDataFormat.DefaultDateTimeFormat().getFormatString());
    private NumberFormat integerNumberFormat;

    public CSVWriter() {
        this.setIntegerNumberFormat();
        this.setOptions(new CSVExportOptions(',', '.', 2, 6));
    }

    public CSVWriter(CSVExportOptions options) {
        this.setIntegerNumberFormat();
        this.setOptions(options);
    }

    public void setOptions(CSVExportOptions options) {
        this.delimiter = options.getColumnDelimiter();
        this.nf = options.buildNumberFormat();
    }

    private void setIntegerNumberFormat() {
        this.integerNumberFormat = NumberFormat.getInstance();
        this.integerNumberFormat.setGroupingUsed(false);
    }

    public void writeCSVData(Writer writer, Object[][] data) throws IOException {
        for (Object[] row : data) {
            this.writeCSVRow(writer, row);
        }
    }

    public void writeCSVRow(Writer writer, Object[] row) throws IOException {
        ArrayList<Object> modifiedRow = new ArrayList<Object>();
        for (Object obj : row) {
            String cell = this.getStringFromObject(obj);
            if (cell.contains("\"") || cell.contains(Character.toString(this.delimiter))) {
                modifiedRow.add("\"" + cell.replaceAll("\"", "\"\"") + "\"");
                continue;
            }
            modifiedRow.add(cell);
        }
        writer.write(StringUtils.join((Object[])modifiedRow.toArray(new String[modifiedRow.size()]), (char)this.delimiter) + "\r\n");
    }

    private String getStringFromObject(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Short || o instanceof Integer || o instanceof Long) {
            return this.integerNumberFormat.format(o);
        }
        if (o instanceof Number) {
            return this.nf.format(o);
        }
        if (o instanceof Date) {
            return this.dateFormat.format((Date)o);
        }
        if (o instanceof Calendar) {
            return this.dateFormat.format(((Calendar)o).getTime());
        }
        if (o instanceof GridCell) {
            GridCell cell = (GridCell)o;
            if (cell.getFormat() != null && cell.getFormat().getDataFormat() != null) {
                CellDataFormat dataFormat = cell.getFormat().getDataFormat();
                boolean isDateFormat = Arrays.asList(CellDataFormat.DATE_FORMATS).contains((Object)dataFormat);
                if (isDateFormat && (cell.getValue() instanceof Date || cell.getValue() instanceof Calendar)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(cell.getFormat().getDataFormat().getFormatString());
                    if (cell.getValue() instanceof Calendar) {
                        return dateFormat.format(((Calendar)cell.getValue()).getTime());
                    }
                    return dateFormat.format((Date)cell.getValue());
                }
                if (cell.getValue() instanceof Number && this.nf instanceof DecimalFormat && (dataFormat == CellDataFormat.Fixed2DP || dataFormat == CellDataFormat.Fixed3DP)) {
                    DecimalFormatSymbols dfs = ((DecimalFormat)this.nf).getDecimalFormatSymbols();
                    DecimalFormat decimalFormat = new DecimalFormat(dataFormat.getFormatString(), dfs);
                    return decimalFormat.format(cell.getValue());
                }
            }
            return this.getStringFromObject(cell.getValue());
        }
        return o.toString();
    }
}

