/*
 * Decompiled with CFR 0.152.
 */
package util.gridwriter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import util.gridwriter.CellFormat;
import util.gridwriter.GridBuilder;
import util.gridwriter.GridCell;
import util.gridwriter.GridRow;
import util.gridwriter.IGridBuilder;

public class GridSheet
implements IGridBuilder {
    private final List<GridRow> rows = new ArrayList<GridRow>();
    private CellFormat format = null;

    public void setFormat(CellFormat format) {
        this.format = format;
    }

    public void clearFormat() {
        this.format = null;
    }

    @Override
    public void addRow(Object ... items) {
        if (items != null && items.length > 1 && items[0] instanceof CellFormat) {
            this.addRowFormatted((CellFormat)items[0], Arrays.copyOfRange(items, 1, items.length));
        } else {
            this.addRowFormatted(this.format, items);
        }
    }

    public void addRowFormatted(short heightFactor, CellFormat format, Object ... items) {
        this.addRowFormatted(format, items);
        this.rows.get(this.rows.size() - 1).setHeightFactor(heightFactor);
    }

    public void addRowFormatted(CellFormat format, Object ... items) {
        this.addRow();
        this.appendFormatted(format, items);
    }

    @Override
    public void addRow() {
        this.rows.add(new GridRow());
    }

    public List<GridRow> getRows() {
        return new ArrayList<GridRow>(this.rows);
    }

    @Override
    public void append(Object ... objects) {
        if (objects == null) {
            this.append();
        }
        if (objects[0] instanceof CellFormat && objects.length > 1) {
            this.appendFormatted((CellFormat)objects[0], Arrays.copyOfRange(objects, 1, objects.length));
        } else {
            this.appendFormatted(this.format, objects);
        }
    }

    @Override
    public void append() {
        this.appendFormatted(this.format, new Object[]{null});
    }

    @Override
    public void appendEmpty(int numCells) {
        for (int i = 0; i < numCells; ++i) {
            this.append();
        }
    }

    @Override
    public void appendFormatted(CellFormat format, Object ... objects) {
        if (this.rows.isEmpty()) {
            this.addRow();
        }
        if (objects == null) {
            this.rows.get(this.rows.size() - 1).add(new GridCell(null, format));
            return;
        }
        if (objects.length == 1 && objects[0] instanceof Collection) {
            objects = ((Collection)objects[0]).toArray();
        }
        for (Object o : objects) {
            GridCell cell = o instanceof GridCell ? (GridCell)o : new GridCell(o, format);
            this.rows.get(this.rows.size() - 1).add(cell);
        }
    }

    public void appendString(String cellText, Object ... args) {
        this.append(String.format(cellText, args));
    }

    public void appendString(CellFormat format, String cellText, Object ... args) {
        this.append(format, String.format(cellText, args));
    }

    public Object[][] getObjectArray() {
        Object[][] dataArray = new Object[this.rows.size()][];
        for (int i = 0; i < this.rows.size(); ++i) {
            List<GridCell> row = this.rows.get((int)i).cells;
            dataArray[i] = row.toArray(new Object[row.size()]);
        }
        return dataArray;
    }

    public Object[][] getDataArray() {
        return GridSheet.clearFormatting(this.getObjectArray());
    }

    public int countColumns() {
        int numColumns = 0;
        for (GridRow row : this.rows) {
            if (row.cells.size() <= numColumns) continue;
            numColumns = row.cells.size();
        }
        return numColumns;
    }

    public static Object[][] clearFormatting(Object[][] inputArray) {
        GridBuilder gb = new GridBuilder();
        for (Object[] row : inputArray) {
            gb.addRow();
            for (Object cell : row) {
                if (cell instanceof GridCell) {
                    gb.append(((GridCell)cell).getValue());
                    continue;
                }
                gb.append(cell);
            }
        }
        return gb.getDataArray();
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public void setValueOfCell(int row, int col, Object value) {
        while (row > this.rows.size() - 1) {
            this.addRow();
        }
        while (col > this.rows.get((int)row).cells.size() - 1) {
            this.append();
        }
        this.rows.get((int)row).cells.set(col, new GridCell(value, this.format));
    }

    public Object getValueOfCell(int row, int col) {
        if (row > this.rows.size() - 1) {
            throw new IllegalArgumentException("row number " + row + " doesn't exist in current grid.");
        }
        if (col > this.rows.get((int)row).cells.size() - 1) {
            throw new IllegalArgumentException("column number " + col + " doesn't exists for row " + row + " in current grid.");
        }
        GridCell cell = this.rows.get(row).get(col);
        return cell.getValue();
    }
}

