/*
 * Decompiled with CFR 0.152.
 */
package util.gridwriter;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import util.gridwriter.CellDataFormat;
import util.gridwriter.CellFormat;
import util.gridwriter.CellFormula;
import util.gridwriter.GridBook;
import util.gridwriter.GridCell;
import util.gridwriter.GridRow;
import util.gridwriter.GridSheet;
import util.gridwriter.XLSExportOptions;

public class XLSGridWriter {
    private Map<CellFormat, CellStyle> styleCache = null;
    private short hssfPaletteIndexPosition = (short)16;
    private CreationHelper creationHelper = null;
    private XLSExportOptions options = new XLSExportOptions();

    public void setOptions(XLSExportOptions options) {
        this.options = options;
    }

    public XLSExportOptions getOptions() {
        return this.options;
    }

    public void write(File file, GridBook book) throws IOException {
        this.write(file, book, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, GridBook book, boolean sortWorkbookSheets) throws IOException {
        this.styleCache = null;
        this.hssfPaletteIndexPosition = (short)16;
        try (FileInputStream readStream = null;){
            Object wb;
            if (file.exists() && this.options.getAppendSheetToWorkbook()) {
                try {
                    readStream = new FileInputStream(file.getPath());
                    wb = WorkbookFactory.create((InputStream)readStream);
                }
                catch (Exception ex) {
                    Logger.getLogger(XLSGridWriter.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex);
                }
            } else {
                if (file.exists()) {
                    file.delete();
                }
                wb = file.getPath().toLowerCase().endsWith(".xls") ? new HSSFWorkbook() : (this.options.getEnableBufferedOutput() ? new SXSSFWorkbook(100) : new XSSFWorkbook());
            }
            List<String> existingworksheets = this.getSheets((Workbook)wb);
            this.creationHelper = wb.getCreationHelper();
            ArrayList<String> sheets = new ArrayList<String>(book.getSheetNames());
            if (sortWorkbookSheets) {
                Collections.sort(sheets);
            }
            for (String sheetName : sheets) {
                int overwritePosition = -1;
                String outputSheetName = sheetName;
                if (this.options.getOverwirteSheet()) {
                    if (existingworksheets.contains(sheetName)) {
                        overwritePosition = existingworksheets.indexOf(sheetName);
                        wb.removeSheetAt(overwritePosition);
                    }
                } else {
                    outputSheetName = this.getUniqueSheetName((Workbook)wb, sheetName);
                }
                this.addWorksheetToWorkbook((Workbook)wb, outputSheetName, book.getSheet(sheetName), this.options.getAutosizeColumns());
                if (overwritePosition < 0) continue;
                wb.setSheetOrder(sheetName, overwritePosition);
            }
            if (wb instanceof XSSFWorkbook) {
                this.setAuthorInfo((XSSFWorkbook)wb);
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                wb.write((OutputStream)out);
            }
            this.creationHelper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Object[][] data) throws IOException {
        this.styleCache = null;
        this.hssfPaletteIndexPosition = (short)16;
        try (FileInputStream readStream = null;){
            Object wb;
            if (file.exists() && this.options.getAppendSheetToWorkbook()) {
                readStream = new FileInputStream(file.getPath());
                wb = WorkbookFactory.create((InputStream)readStream);
            } else if (file.getPath().toLowerCase().endsWith(".xls")) {
                wb = new HSSFWorkbook();
            } else {
                int rowAccessWindowSize = 100;
                wb = this.options.getEnableBufferedOutput() ? new SXSSFWorkbook(rowAccessWindowSize) : new XSSFWorkbook();
            }
            String sheetName = this.options.getSheetName();
            int overwritePosition = -1;
            if (this.options.getOverwirteSheet()) {
                List<String> sheets = this.getSheets((Workbook)wb);
                if (sheets.contains(sheetName)) {
                    overwritePosition = sheets.indexOf(sheetName);
                    wb.removeSheetAt(overwritePosition);
                }
            } else {
                sheetName = this.getUniqueSheetName((Workbook)wb, sheetName);
            }
            this.creationHelper = wb.getCreationHelper();
            this.addWorksheetToWorkbook((Workbook)wb, sheetName, data, this.options.getAutosizeColumns());
            if (overwritePosition >= 0) {
                wb.setSheetOrder(sheetName, overwritePosition);
            }
            if (wb instanceof XSSFWorkbook) {
                this.setAuthorInfo((XSSFWorkbook)wb);
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                wb.write((OutputStream)out);
            }
            this.creationHelper = null;
        }
    }

    private String getUniqueSheetName(Workbook wb, String name) {
        Object uniqueName;
        List<String> sheets = this.getSheets(wb);
        if (sheets.contains(uniqueName = name)) {
            for (int i = 1; i < 1000 && sheets.contains(uniqueName = name + "_" + i); ++i) {
            }
        }
        return uniqueName;
    }

    private List<String> getSheets(Workbook wb) {
        ArrayList<String> sheets = new ArrayList<String>();
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            sheets.add(wb.getSheetName(i));
        }
        return sheets;
    }

    private void addWorksheetToWorkbook(Workbook wb, String name, GridSheet data, boolean autosize) {
        Sheet sheet = wb.createSheet(name);
        CellStyle dateFormat = wb.createCellStyle();
        dateFormat.setDataFormat(wb.createDataFormat().getFormat(CellDataFormat.DefaultDateTimeFormat().getFormatString()));
        int numColumns = 0;
        List<GridRow> gridRows = data.getRows();
        for (int rowNum = 0; rowNum < gridRows.size(); ++rowNum) {
            GridRow rowData = gridRows.get(rowNum);
            Row row = sheet.createRow(rowNum);
            if (rowData.getHeightFactor() != 1) {
                row.setHeight((short)(row.getHeight() * rowData.getHeightFactor()));
            }
            if (rowData.size() > numColumns) {
                numColumns = rowData.size();
            }
            for (int colNum = 0; colNum < rowData.size(); ++colNum) {
                Cell cell = row.createCell(colNum);
                GridCell celldata = rowData.get(colNum);
                this.setCellValue(cell, celldata);
                this.setCellFormat(wb, sheet, cell, celldata);
            }
        }
        if (autosize) {
            if (sheet instanceof SXSSFSheet) {
                ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
            }
            for (int i = 0; i < numColumns; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    private void setCellFormat(Workbook wb, Sheet sheet, Cell cell, GridCell cellData) {
        CellFormat format = cellData.getFormat();
        Object value = cellData.getValue();
        if (this.isDateValue(value) && format == null) {
            format = new CellFormat();
        }
        if (this.isDateValue(value) && format.getDataFormat() == null) {
            format.setDataFormat(CellDataFormat.DefaultDateTimeFormat());
        }
        if (format != null) {
            CellStyle style = this.getStyle(wb, format);
            cell.setCellStyle(style);
        }
        if (StringUtils.isNotBlank((CharSequence)cellData.getComment())) {
            this.addCellComment(sheet, cell, cellData.getComment());
        }
    }

    private void addWorksheetToWorkbook(Workbook wb, String name, Object[][] data, boolean autosize) {
        Sheet sheet = wb.createSheet(name);
        CellStyle dateFormat = wb.createCellStyle();
        dateFormat.setDataFormat(wb.createDataFormat().getFormat(CellDataFormat.DefaultDateTimeFormat().getFormatString()));
        int numColumns = 0;
        for (int rowNum = 0; rowNum < data.length; ++rowNum) {
            Object[] rowData = data[rowNum];
            Row row = sheet.createRow(rowNum);
            if (rowData.length > numColumns) {
                numColumns = rowData.length;
            }
            for (int colNum = 0; colNum < rowData.length; ++colNum) {
                Cell cell = row.createCell(colNum);
                Object cellValue = rowData[colNum];
                this.setCellValue(cell, cellValue);
                if (cellValue instanceof GridCell) {
                    GridCell gridCellValue = (GridCell)cellValue;
                    this.setCellFormat(wb, sheet, cell, gridCellValue);
                    continue;
                }
                if (!this.isDateValue(cellValue)) continue;
                cell.setCellStyle(dateFormat);
            }
        }
        if (autosize) {
            if (sheet instanceof SXSSFSheet) {
                ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
            }
            for (int i = 0; i < numColumns; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    private CellStyle getStyle(Workbook wb, CellFormat format) {
        if (this.styleCache == null) {
            this.styleCache = new HashMap<CellFormat, CellStyle>();
        }
        if (!this.styleCache.containsKey(format)) {
            this.styleCache.put(format, this.buildStyle(wb, format));
        }
        return this.styleCache.get(format);
    }

    private CellStyle buildStyle(Workbook wb, CellFormat cellFormat) {
        CellStyle style;
        if (wb instanceof XSSFWorkbook) {
            XSSFWorkbook xwb = (XSSFWorkbook)wb;
            XSSFCellStyle xssfstyle = xwb.createCellStyle();
            if (cellFormat.getFillColour() != null) {
                xssfstyle.setFillForegroundColor(new XSSFColor(cellFormat.getFillColour()));
                xssfstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            style = xssfstyle;
        } else if (wb instanceof HSSFWorkbook) {
            HSSFWorkbook hwb = (HSSFWorkbook)wb;
            HSSFCellStyle hssfStyle = hwb.createCellStyle();
            if (cellFormat.getFillColour() != null) {
                Color c;
                HSSFPalette palette = hwb.getCustomPalette();
                HSSFColor hssfCol = palette.findColor((byte)(c = cellFormat.getFillColour()).getRed(), (byte)c.getGreen(), (byte)c.getBlue());
                if (hssfCol == null) {
                    palette.setColorAtIndex(this.hssfPaletteIndexPosition, (byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue());
                    hssfCol = palette.getColor(this.hssfPaletteIndexPosition);
                    this.hssfPaletteIndexPosition = (short)(this.hssfPaletteIndexPosition + 1);
                }
                hssfStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                hssfStyle.setFillForegroundColor(hssfCol.getIndex());
            }
            style = hssfStyle;
        } else {
            style = wb.createCellStyle();
        }
        short textRotation = cellFormat.getTextRotation();
        if (wb instanceof XSSFWorkbook && textRotation < 0) {
            textRotation = (short)(Math.abs(textRotation) + 90);
        }
        style.setRotation(textRotation);
        if (cellFormat.getDataFormat() != null) {
            style.setDataFormat(wb.createDataFormat().getFormat(cellFormat.getDataFormat().getFormatString()));
        }
        if (cellFormat.getBold()) {
            Font font = wb.createFont();
            font.setBold(true);
            style.setFont(font);
        }
        style.setAlignment(cellFormat.getAlignment());
        style.setVerticalAlignment(cellFormat.getVerticalAlignment());
        style.setWrapText(cellFormat.getWrap());
        if (cellFormat.getBorder() != 0) {
            int border = cellFormat.getBorder();
            if ((border & 1) != 0) {
                style.setBorderTop(BorderStyle.THIN);
            }
            if ((border & 4) != 0) {
                style.setBorderLeft(BorderStyle.THIN);
            }
            if ((border & 8) != 0) {
                style.setBorderRight(BorderStyle.THIN);
            }
            if ((border & 2) != 0) {
                style.setBorderBottom(BorderStyle.THIN);
            }
        }
        return style;
    }

    private void setCellValue(Cell cell, Object value) {
        if (value != null) {
            if (value instanceof GridCell) {
                this.setCellValue(cell, ((GridCell)value).getValue());
            } else if (value instanceof Number) {
                cell.setCellValue(((Number)value).doubleValue());
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
            } else if (value instanceof Calendar) {
                cell.setCellValue((Calendar)value);
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value instanceof CellFormula) {
                cell.setCellFormula(((CellFormula)value).getFormula());
            } else {
                cell.setCellValue(value.toString());
            }
        }
    }

    private boolean isDateValue(Object value) {
        return value instanceof Date || value instanceof Calendar;
    }

    private void setAuthorInfo(XSSFWorkbook xssfWorkbook) {
        POIXMLProperties xmlProps = xssfWorkbook.getProperties();
        if (xmlProps != null) {
            POIXMLProperties.CoreProperties coreProps = xmlProps.getCoreProperties();
            coreProps.setCreator(this.options.getAuthorName());
        }
    }

    private void addCellComment(Sheet sheet, Cell cell, String commentText) {
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = this.creationHelper.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex() + 1);
        anchor.setCol2(cell.getColumnIndex() + 4);
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
        int r1 = cell.getRow().getRowNum() - 1;
        int r2 = cell.getRow().getRowNum() + 1;
        if (r1 < 0) {
            r1 = 0;
            r2 = 2;
        }
        anchor.setRow1(r1);
        anchor.setRow2(r2);
        Comment comment = drawing.createCellComment(anchor);
        RichTextString str = this.creationHelper.createRichTextString(commentText);
        comment.setString(str);
        comment.setAuthor(this.options.getAuthorName());
        cell.setCellComment(comment);
    }
}

