/*
 * Decompiled with CFR 0.152.
 */
package util.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

public class TextAreaRenderer
extends JTextArea
implements TableCellRenderer {
    private final boolean changeTableRowHeight;

    public TextAreaRenderer(boolean changeRowHeight) {
        this.changeTableRowHeight = changeRowHeight;
        this.init();
    }

    private void init() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        if (value != null) {
            this.setText(value.toString());
            if (this.changeTableRowHeight) {
                this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
                if (table.getRowHeight(row) != this.getPreferredSize().height) {
                    table.setRowHeight(row, this.getPreferredSize().height);
                }
            }
        } else {
            this.setText(null);
        }
        return this;
    }
}

