/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconvert;

import com.stratadata.util.preferences.ProxySettings;
import com.stratadata.util.preferences.RegistryPreferencesHelper;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class DialogDownloadDB
extends JDialog {
    final String DEMO_DB_NAME = "sbugs3-0_demo.mv.db";
    String selectedFilePath = null;
    private JButton jButtonClose;
    private JButton jButtonDownload;
    private JButton jButtonSelect;
    private JLabel jLabel1;
    private JProgressBar jProgressBarDownload;
    private JTextField jTextFieldDest;

    public DialogDownloadDB(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("StrataBugs: Download Demo");
        try {
            this.jTextFieldDest.setText(new File(".").getCanonicalPath() + File.separator + "Data");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldDest = new JTextField();
        this.jButtonSelect = new JButton();
        this.jProgressBarDownload = new JProgressBar();
        this.jButtonDownload = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("<html>Select destination folder for the StrataBugs demo database. <br/>You need permission to write into this folder.</html>");
        this.jTextFieldDest.setEditable(false);
        this.jButtonSelect.setText("...");
        this.jButtonSelect.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogDownloadDB this$0;
            {
                DialogDownloadDB dialogDownloadDB = this$0;
                Objects.requireNonNull(dialogDownloadDB);
                this.this$0 = dialogDownloadDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectActionPerformed(evt);
            }
        });
        this.jButtonDownload.setText("Download");
        this.jButtonDownload.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogDownloadDB this$0;
            {
                DialogDownloadDB dialogDownloadDB = this$0;
                Objects.requireNonNull(dialogDownloadDB);
                this.this$0 = dialogDownloadDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDownloadActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogDownloadDB this$0;
            {
                DialogDownloadDB dialogDownloadDB = this$0;
                Objects.requireNonNull(dialogDownloadDB);
                this.this$0 = dialogDownloadDB;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBarDownload, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.jTextFieldDest)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelect).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonDownload).addGap(1, 1, 1).addComponent(this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDest, -2, -1, -2).addComponent(this.jButtonSelect)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jProgressBarDownload, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDownload).addComponent(this.jButtonClose)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonDownloadActionPerformed(ActionEvent evt) {
        final String destPath = this.jTextFieldDest.getText();
        if (destPath.isBlank()) {
            JOptionPane.showMessageDialog(this, "Destination folder blank", "StrataBugs", 2);
            return;
        }
        if (!this.checkFolder(new File(destPath))) {
            return;
        }
        Thread t = new Thread(new Runnable(){
            final /* synthetic */ DialogDownloadDB this$0;
            {
                DialogDownloadDB dialogDownloadDB = this$0;
                Objects.requireNonNull(dialogDownloadDB);
                this.this$0 = dialogDownloadDB;
            }

            @Override
            public void run() {
                this.this$0.downloadUpdate(destPath);
            }
        });
        t.start();
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadUpdate(String destPath) {
        try {
            JProgressBar pm = this.jProgressBarDownload;
            URL url = new URL("https://www.stratadata.co.uk/StrataBugs/v3.0/install/sbugs3-0_demo.mv.db.zip");
            System.out.println("Downloading from : " + String.valueOf(url));
            URLConnection conn = this.getConnection(url);
            File outFile = File.createTempFile("Sbugs-", ".tmp", null);
            FileOutputStream fos = new FileOutputStream(outFile);
            int size = 0;
            try {
                size = conn.getContentLength();
                pm.setMinimum(0);
                pm.setMaximum(size);
                InputStream ios = conn.getInputStream();
                byte[] b = new byte[4097];
                int total = 0;
                try {
                    int nBytes;
                    while ((nBytes = ios.read(b, 0, b.length)) > 0) {
                        fos.write(b, 0, nBytes);
                        int runTotal = total += nBytes;
                        this.doUpdate(() -> pm.setValue(runTotal));
                    }
                }
                catch (SocketTimeoutException e) {
                    JOptionPane.showMessageDialog(this, "Download timed out.\nPlease check your network connection and try again, or contact StrataData for assistance");
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
            catch (FileNotFoundException f) {
                JOptionPane.showMessageDialog(this, "Exception getting file: " + f.toString());
                f.printStackTrace();
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            fos.close();
            File fileInsideZip = new File("sbugs3-0_demo.mv.db");
            ZipFile zipFile = new ZipFile(outFile);
            ZipEntry entry = zipFile.getEntry(fileInsideZip.getName());
            if (entry == null) {
                JOptionPane.showMessageDialog(this, "Can't find database in zip file.");
                return;
            }
            String destFilePath = destPath + File.separator + "sbugs3-0_demo.mv.db";
            fos = new FileOutputStream(destFilePath);
            InputStream fis = zipFile.getInputStream(entry);
            this.extractFile(fis, fos);
            System.out.println("File extracted from zip: " + destFilePath);
            fis.close();
            fos.close();
            new File(destFilePath).setLastModified(conn.getLastModified());
            this.selectedFilePath = destFilePath.replaceAll(".mv.db", "");
            this.dispose();
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, "URL Error: " + e.getMessage(), "StrataBugs", 0);
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    URLConnection getConnection(URL url) {
        try {
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            ProxySettings proxySettings = RegistryPreferencesHelper.getProxySettings();
            if (proxySettings != null) {
                String s = proxySettings.getProxyUser() + ":" + proxySettings.getProxyPassword();
                String se = Base64.getEncoder().encodeToString(s.getBytes());
                uc.setRequestProperty("Proxy-Authorization", "Basic " + se);
                uc.connect();
            }
            return uc;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "I/O Error opening remote connection to URL: " + String.valueOf(url));
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    void extractFile(InputStream zipIn, OutputStream fos) throws IOException {
        int nBytes;
        byte[] b = new byte[4097];
        int total = 0;
        while ((nBytes = zipIn.read(b, 0, b.length)) > 0) {
            fos.write(b, 0, nBytes);
            int n = total += nBytes;
        }
    }

    void doUpdate(Runnable r) {
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException | InvocationTargetException e1) {
            System.err.println(e1);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.showOpenDialog(this);
            if (jFileChooser.getSelectedFile() != null) {
                File file = jFileChooser.getSelectedFile();
                System.out.println("file: " + file.getAbsolutePath());
                if (!this.checkFolder(file)) {
                    return;
                }
                this.jTextFieldDest.setText(file.getPath());
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean checkFolder(File file) {
        if (!file.exists()) {
            int opt = JOptionPane.showConfirmDialog(this, "Folder doesn't exist, create it?", "StrataBugs", 0, 3);
            if (opt == 1 || opt == 2) {
                return false;
            }
            if (!file.mkdir()) {
                JOptionPane.showMessageDialog(this, "Error creating folder - check permissions", "StrataBugs", 0);
                return false;
            }
        }
        if (!file.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Selected file is not a folder", "StrataBugs", 0);
            return false;
        }
        File demoDBfile = new File(file.getPath() + File.separator + "sbugs3-0_demo.mv.db");
        if (demoDBfile.exists()) {
            JOptionPane.showMessageDialog(this, "A demo database file already exists in this folder (" + demoDBfile.getPath() + ")", "StrataBugs", 0);
            return false;
        }
        return true;
    }
}

