/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconvert;

import com.stratadata.model3.db.ModelVersion;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.sbconnect.DialogConnect;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JPanelConnection
extends JPanel {
    private static final String DEFAULT_CONNECTION_STRING = "Choose connection";
    private final Frame parent;
    private ModelVersion version;
    private ConnectionSelectionListener listener;
    private ConnectionParameters params;
    private JButton jButtonChooseConnection;
    private JLabel jLabelStatus;
    private JTextField jTextFieldConnection;
    private JTextField jTextFieldInfo;

    @Deprecated
    public JPanelConnection() {
        this(null, null);
    }

    public JPanelConnection(Frame parent, ModelVersion version) {
        this.parent = parent;
        this.version = version;
        this.initComponents();
    }

    public JPanelConnection(ConnectionParameters params) {
        this.params = params;
        this.version = params.getModelVersion();
        this.parent = null;
        this.initComponents();
        this.jButtonChooseConnection.setVisible(false);
        this.jLabelStatus.setVisible(false);
    }

    public void setConnectionSelectionListener(ConnectionSelectionListener listener) {
        this.listener = listener;
    }

    public void setVersion(ModelVersion version) {
        Objects.requireNonNull(version);
        this.version = version;
    }

    public ModelVersion getVersion() {
        return this.version;
    }

    private void initComponents() {
        this.jTextFieldConnection = new JTextField();
        this.jTextFieldInfo = new JTextField();
        this.jButtonChooseConnection = new JButton();
        this.jLabelStatus = new JLabel();
        this.jTextFieldConnection.setEditable(false);
        this.jTextFieldConnection.setFont(new Font("Segoe UI", 1, 12));
        this.jTextFieldConnection.setText(DEFAULT_CONNECTION_STRING);
        this.jTextFieldInfo.setEditable(false);
        this.jTextFieldInfo.setHorizontalAlignment(4);
        this.jButtonChooseConnection.setText("...");
        this.jButtonChooseConnection.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelConnection this$0;
            {
                JPanelConnection jPanelConnection = this$0;
                Objects.requireNonNull(jPanelConnection);
                this.this$0 = jPanelConnection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChooseConnectionActionPerformed(evt);
            }
        });
        this.jLabelStatus.setForeground(new Color(102, 102, 102));
        this.jLabelStatus.setText("Waiting for connection...");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelStatus, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldConnection, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldInfo, -1, 100, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonChooseConnection, -2, 44, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldInfo, -2, -1, -2).addComponent(this.jButtonChooseConnection)).addComponent(this.jTextFieldConnection, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelStatus).addContainerGap()));
        layout.linkSize(1, this.jButtonChooseConnection, this.jTextFieldConnection, this.jTextFieldInfo);
    }

    private void jButtonChooseConnectionActionPerformed(ActionEvent evt) {
        DialogConnect dialog = new DialogConnect(this.parent, this.version);
        dialog.setLocationRelativeTo((Component)this);
        dialog.setVisible(true);
        if (dialog.getParms() == null) {
            return;
        }
        this.params = dialog.getParms();
        if (this.listener != null) {
            this.listener.connectionSelected();
        }
    }

    public ConnectionParameters getParams() {
        return this.params;
    }

    public void updateFields(String schemaName, String platformName, String status) {
        if (this.params == null) {
            this.jTextFieldConnection.setText(DEFAULT_CONNECTION_STRING);
            this.jTextFieldInfo.setText("");
        } else {
            this.jTextFieldConnection.setText(this.params.getName());
            this.jTextFieldInfo.setText(JPanelConnection.getInfoText(schemaName, platformName));
        }
        this.jLabelStatus.setText(status);
    }

    public void updateStatusText(String status) {
        this.jLabelStatus.setText(status);
    }

    private static String getInfoText(String schemaName, String platformName) {
        Object s = platformName;
        if (schemaName != null && !schemaName.isBlank()) {
            s = schemaName + " (" + platformName + ")";
        }
        return s;
    }

    public static interface ConnectionSelectionListener {
        public void connectionSelected();
    }
}

