/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.format.UnitFormat;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.AbstractQuantityFormat;
import tech.units.indriya.format.CommonFormatter;
import tech.units.indriya.format.CommonFormatterOld;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.LocalUnitFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.quantity.CompoundQuantity;
import tech.units.indriya.quantity.MixedQuantity;
import tech.units.indriya.quantity.Quantities;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NumberDelimiterQuantityFormat
extends AbstractQuantityFormat {
    private static final NumberDelimiterQuantityFormat SIMPLE_INSTANCE = new Builder().setNumberFormat(NumberFormat.getInstance(Locale.ROOT)).setUnitFormat(SimpleUnitFormat.getInstance()).build();
    private static final NumberDelimiterQuantityFormat LOCAL_INSTANCE = new Builder().setNumberFormat(NumberFormat.getInstance()).setUnitFormat(LocalUnitFormat.getInstance()).setLocaleSensitive(true).build();
    private static final long serialVersionUID = 3546952599885869402L;
    private transient NumberFormat numberFormat;
    private transient UnitFormat unitFormat;
    private transient Unit primaryUnit;
    private String delimiter;
    private String mixDelimiter;
    private boolean localeSensitive;

    private NumberDelimiterQuantityFormat() {
    }

    public static NumberDelimiterQuantityFormat getInstance(FormatBehavior behavior) {
        switch (behavior) {
            case LOCALE_SENSITIVE: {
                return LOCAL_INSTANCE;
            }
        }
        return SIMPLE_INSTANCE;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static NumberDelimiterQuantityFormat getInstance() {
        return NumberDelimiterQuantityFormat.getInstance(FormatBehavior.LOCALE_NEUTRAL);
    }

    public static NumberDelimiterQuantityFormat getInstance(NumberFormat numberFormat, UnitFormat unitFormat) {
        return new Builder().setNumberFormat(numberFormat).setUnitFormat(unitFormat).build();
    }

    @Override
    public Appendable format(Quantity<?> quantity, Appendable dest) throws IOException {
        int fract = 0;
        if (quantity != null && quantity.getValue() != null) {
            fract = NumberDelimiterQuantityFormat.getFractionDigitsCount(quantity.getValue().doubleValue());
        }
        if (fract > 1) {
            this.numberFormat.setMaximumFractionDigits(fract + 1);
        }
        dest.append(this.numberFormat.format(quantity.getValue()));
        if (quantity.getUnit().equals(AbstractUnit.ONE)) {
            return dest;
        }
        dest.append(this.delimiter);
        return this.unitFormat.format(quantity.getUnit(), dest);
    }

    @Override
    public Quantity<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, MeasurementParseException {
        String str = csq.toString();
        int index = cursor.getIndex();
        if (this.mixDelimiter != null && !this.mixDelimiter.equals(this.delimiter)) {
            if (this.primaryUnit != null) {
                return CommonFormatter.parseMixedAsPrimary(str, this.numberFormat, this.unitFormat, this.primaryUnit, this.delimiter, this.mixDelimiter, index);
            }
            return CommonFormatter.parseMixedAsLeading(str, this.numberFormat, this.unitFormat, this.delimiter, this.mixDelimiter, index);
        }
        if (this.mixDelimiter != null && this.mixDelimiter.equals(this.delimiter)) {
            if (this.primaryUnit != null) {
                return CommonFormatter.parseMixedAsPrimary(str, this.numberFormat, this.unitFormat, this.primaryUnit, this.delimiter, index);
            }
            return CommonFormatter.parseMixedAsLeading(str, this.numberFormat, this.unitFormat, this.delimiter, index);
        }
        Number number = this.numberFormat.parse(str, cursor);
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be parsed");
        }
        String[] parts = str.substring(index).split(this.delimiter);
        if (parts.length < 2) {
            throw new IllegalArgumentException("No Unit found");
        }
        Unit unit = this.unitFormat.parse((CharSequence)parts[1]);
        return Quantities.getQuantity(number, unit);
    }

    @Override
    protected Quantity<?> parse(CharSequence csq, int index) throws IllegalArgumentException, MeasurementParseException {
        return this.parse(csq, new ParsePosition(index));
    }

    @Override
    public Quantity<?> parse(CharSequence csq) throws IllegalArgumentException, MeasurementParseException {
        return this.parse(csq, 0);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean isLocaleSensitive() {
        return this.localeSensitive;
    }

    @Override
    protected StringBuffer formatMixed(MixedQuantity<?> comp, StringBuffer dest) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (Quantity<?> q : comp.getQuantities()) {
            sb.append(this.format(q));
            if (i < comp.getQuantities().size() - 1) {
                sb.append(this.mixDelimiter != null ? this.mixDelimiter : " ");
            }
            ++i;
        }
        return sb;
    }

    public MixedQuantity<?> parseMixed(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, MeasurementParseException {
        String str = csq.toString();
        int index = cursor.getIndex();
        if (this.mixDelimiter != null && !this.mixDelimiter.equals(this.delimiter)) {
            return CommonFormatter.parseMixed(str, this.numberFormat, this.unitFormat, this.delimiter, this.mixDelimiter, index);
        }
        if (this.mixDelimiter != null && this.mixDelimiter.equals(this.delimiter)) {
            return CommonFormatter.parseMixed(str, this.numberFormat, this.unitFormat, this.delimiter, index);
        }
        Number number = this.numberFormat.parse(str, cursor);
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be parsed");
        }
        String[] parts = str.substring(index).split(this.delimiter);
        if (parts.length < 2) {
            throw new IllegalArgumentException("No Unit found");
        }
        Unit unit = this.unitFormat.parse((CharSequence)parts[1]);
        return MixedQuantity.of(Quantities.getQuantity(number, unit));
    }

    protected MixedQuantity<?> parseMixed(CharSequence csq, int index) throws IllegalArgumentException, MeasurementParseException {
        return this.parseMixed(csq, new ParsePosition(index));
    }

    public MixedQuantity<?> parseMixed(CharSequence csq) throws IllegalArgumentException, MeasurementParseException {
        return this.parseMixed(csq, 0);
    }

    @Override
    @Deprecated
    protected StringBuffer formatCompound(CompoundQuantity<?> comp, StringBuffer dest) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (Quantity<?> q : comp.getQuantities()) {
            sb.append(this.format(q));
            if (i < comp.getQuantities().size() - 1) {
                sb.append(this.mixDelimiter != null ? this.mixDelimiter : " ");
            }
            ++i;
        }
        return sb;
    }

    @Deprecated
    public CompoundQuantity<?> parseCompound(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, MeasurementParseException {
        String str = csq.toString();
        int index = cursor.getIndex();
        if (this.mixDelimiter != null && !this.mixDelimiter.equals(this.delimiter)) {
            return CommonFormatterOld.parseCompound(str, this.numberFormat, this.unitFormat, this.delimiter, this.mixDelimiter, index);
        }
        if (this.mixDelimiter != null && this.mixDelimiter.equals(this.delimiter)) {
            return CommonFormatterOld.parseCompound(str, this.numberFormat, this.unitFormat, this.delimiter, index);
        }
        Number number = this.numberFormat.parse(str, cursor);
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be parsed");
        }
        String[] parts = str.substring(index).split(this.delimiter);
        if (parts.length < 2) {
            throw new IllegalArgumentException("No Unit found");
        }
        Unit unit = this.unitFormat.parse((CharSequence)parts[1]);
        return CompoundQuantity.of(Quantities.getQuantity(number, unit));
    }

    @Deprecated
    protected CompoundQuantity<?> parseCompound(CharSequence csq, int index) throws IllegalArgumentException, MeasurementParseException {
        return this.parseCompound(csq, new ParsePosition(index));
    }

    @Deprecated
    public CompoundQuantity<?> parseCompound(CharSequence csq) throws IllegalArgumentException, MeasurementParseException {
        return this.parseCompound(csq, 0);
    }

    private static int getFractionDigitsCount(double d) {
        if (d >= 1.0) {
            d -= (double)((long)d);
        }
        if (d == 0.0) {
            return 0;
        }
        d *= 10.0;
        int count = 1;
        while (d - (double)((long)d) != 0.0) {
            d *= 10.0;
            ++count;
        }
        return count;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder {
        private transient NumberFormat numberFormat;
        private transient UnitFormat unitFormat;
        private transient Unit primaryUnit;
        private transient String delimiter = " ";
        private transient String mixedRadixDelimiter;
        private boolean localeSensitive;

        public Builder setNumberFormat(NumberFormat numberFormat) {
            Objects.requireNonNull(numberFormat);
            this.numberFormat = numberFormat;
            return this;
        }

        public Builder setUnitFormat(UnitFormat unitFormat) {
            Objects.requireNonNull(unitFormat);
            this.unitFormat = unitFormat;
            this.localeSensitive = unitFormat.isLocaleSensitive();
            return this;
        }

        public Builder setPrimaryUnit(Unit primary) {
            Objects.requireNonNull(primary);
            this.primaryUnit = primary;
            return this;
        }

        public Builder setDelimiter(String delimiter) {
            Objects.requireNonNull(delimiter);
            this.delimiter = delimiter;
            return this;
        }

        public Builder setRadixPartsDelimiter(String radixPartsDelimiter) {
            Objects.requireNonNull(radixPartsDelimiter);
            this.mixedRadixDelimiter = radixPartsDelimiter;
            return this;
        }

        public Builder setLocaleSensitive(boolean localeSensitive) {
            this.localeSensitive = localeSensitive;
            return this;
        }

        public NumberDelimiterQuantityFormat build() {
            NumberDelimiterQuantityFormat quantityFormat = new NumberDelimiterQuantityFormat();
            quantityFormat.numberFormat = this.numberFormat;
            quantityFormat.unitFormat = this.unitFormat;
            quantityFormat.primaryUnit = this.primaryUnit;
            quantityFormat.delimiter = this.delimiter;
            quantityFormat.mixDelimiter = this.mixedRadixDelimiter;
            quantityFormat.localeSensitive = this.localeSensitive;
            return quantityFormat;
        }
    }
}

