/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandcombine;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class BandCombineOpImage
extends PointOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private final boolean hasNoData;
    private Range noData;
    private boolean[] lut;
    private final boolean hasROI;
    private ROI roi;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private final Rectangle roiBounds;
    private PlanarImage roiImage;
    private double[][] matrix;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;

    public BandCombineOpImage(RenderedImage source, Map config, ImageLayout layout, double[][] matrix, ROI roi, Range noData, double destinationNoData) {
        super(source, layout, config, true);
        this.matrix = matrix;
        int numBands = matrix.length;
        if (this.getSampleModel().getNumBands() != numBands) {
            this.sampleModel = RasterFactory.createComponentSampleModel((SampleModel)this.sampleModel, (int)this.sampleModel.getDataType(), (int)this.tileWidth, (int)this.tileHeight, (int)numBands);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)this.sampleModel, (ColorModel)this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel((SampleModel)this.sampleModel, (Map)config);
            }
        }
        if (roi != null) {
            this.hasROI = true;
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        } else {
            this.hasROI = false;
            this.roi = null;
            this.roiBounds = null;
        }
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
        } else {
            this.hasNoData = false;
        }
        int dataType = source.getSampleModel().getDataType();
        this.destNoDataDouble = destinationNoData;
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte((double)destinationNoData);
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort((double)destinationNoData);
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort((double)destinationNoData);
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt((double)destinationNoData);
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat((double)destinationNoData);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        boolean bl = this.caseC = this.hasNoData && !this.hasROI;
        if (this.hasNoData && dataType == 0) {
            this.initBooleanNoDataTable();
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor d = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            switch (d.getDataType()) {
                case 0: {
                    this.computeRectByte(s, d, roiIter, roiContainsTile);
                    break;
                }
                case 1: {
                    this.computeRectUShort(s, d, roiIter, roiContainsTile);
                    break;
                }
                case 2: {
                    this.computeRectShort(s, d, roiIter, roiContainsTile);
                    break;
                }
                case 3: {
                    this.computeRectInt(s, d, roiIter, roiContainsTile);
                    break;
                }
                case 4: {
                    this.computeRectFloat(s, d, roiIter, roiContainsTile);
                    break;
                }
                case 5: {
                    this.computeRectDouble(s, d, roiIter, roiContainsTile);
                }
            }
            if (d.isDataCopy()) {
                d.clampDataArrays();
                d.copyDataToRaster();
            }
        } else {
            double[] backgroundValues = new double[s.getNumBands()];
            Arrays.fill(backgroundValues, this.destNoDataDouble);
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])backgroundValues);
        }
    }

    private void computeRectByte(RasterAccessor s, RasterAccessor d, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s.getScanlineStride();
        int srcPixelStride = s.getPixelStride();
        int srcBands = s.getNumBands();
        int[] srcBandOffsets = s.getBandOffsets();
        byte[][] srcData = s.getByteDataArrays();
        int dstWidth = d.getWidth();
        int dstHeight = d.getHeight();
        int dstBands = d.getNumBands();
        int dstLineStride = d.getScanlineStride();
        int dstPixelStride = d.getPixelStride();
        int[] dstBandOffsets = d.getBandOffsets();
        byte[][] dstData = d.getByteDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s.getX();
        int srcY = s.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFF);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = ImageUtil.clampRoundByte((float)(sum += (float)mat[srcBands]));
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataByte;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFF);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = ImageUtil.clampRoundByte((float)(sum += (float)mat[srcBands]));
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            byte sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (!this.lut[sample & 0xFF]) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)(sample & 0xFF);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? ImageUtil.clampRoundByte((float)(sum += (float)mat[srcBands])) : this.destNoDataByte;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataByte;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            byte sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (!this.lut[sample & 0xFF]) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)(sample & 0xFF);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? ImageUtil.clampRoundByte((float)(sum += (float)mat[srcBands])) : this.destNoDataByte;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectUShort(RasterAccessor s, RasterAccessor d, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s.getScanlineStride();
        int srcPixelStride = s.getPixelStride();
        int srcBands = s.getNumBands();
        int[] srcBandOffsets = s.getBandOffsets();
        short[][] srcData = s.getShortDataArrays();
        int dstWidth = d.getWidth();
        int dstHeight = d.getHeight();
        int dstBands = d.getNumBands();
        int dstLineStride = d.getScanlineStride();
        int dstPixelStride = d.getPixelStride();
        int[] dstBandOffsets = d.getBandOffsets();
        short[][] dstData = d.getShortDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s.getX();
        int srcY = s.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFFFF);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = ImageUtil.clampRoundUShort((float)(sum += (float)mat[srcBands]));
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)(srcData[k][srcPixelOffset + srcBandOffsets[k]] & 0xFFFF);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = ImageUtil.clampRoundUShort((float)(sum += (float)mat[srcBands]));
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            short sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)(sample & 0xFFFF);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? ImageUtil.clampRoundUShort((float)(sum += (float)mat[srcBands])) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            short sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)(sample & 0xFFFF);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? ImageUtil.clampRoundUShort((float)(sum += (float)mat[srcBands])) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectShort(RasterAccessor s, RasterAccessor d, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s.getScanlineStride();
        int srcPixelStride = s.getPixelStride();
        int srcBands = s.getNumBands();
        int[] srcBandOffsets = s.getBandOffsets();
        short[][] srcData = s.getShortDataArrays();
        int dstWidth = d.getWidth();
        int dstHeight = d.getHeight();
        int dstBands = d.getNumBands();
        int dstLineStride = d.getScanlineStride();
        int dstPixelStride = d.getPixelStride();
        int[] dstBandOffsets = d.getBandOffsets();
        short[][] dstData = d.getShortDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s.getX();
        int srcY = s.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = ImageUtil.clampRoundShort((float)(sum += (float)mat[srcBands]));
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = ImageUtil.clampRoundShort((float)(sum += (float)mat[srcBands]));
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            short sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)sample;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? ImageUtil.clampRoundShort((float)(sum += (float)mat[srcBands])) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            short sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)sample;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? ImageUtil.clampRoundShort((float)(sum += (float)mat[srcBands])) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectInt(RasterAccessor s, RasterAccessor d, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s.getScanlineStride();
        int srcPixelStride = s.getPixelStride();
        int srcBands = s.getNumBands();
        int[] srcBandOffsets = s.getBandOffsets();
        int[][] srcData = s.getIntDataArrays();
        int dstWidth = d.getWidth();
        int dstHeight = d.getHeight();
        int dstBands = d.getNumBands();
        int dstLineStride = d.getScanlineStride();
        int dstPixelStride = d.getPixelStride();
        int[] dstBandOffsets = d.getBandOffsets();
        int[][] dstData = d.getIntDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s.getX();
        int srcY = s.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = ImageUtil.clampRoundInt((float)(sum += (float)mat[srcBands]));
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataInt;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * (float)srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = ImageUtil.clampRoundInt((float)(sum += (float)mat[srcBands]));
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            int sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)sample;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? ImageUtil.clampRoundInt((float)(sum += (float)mat[srcBands])) : this.destNoDataInt;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataInt;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            int sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * (float)sample;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? ImageUtil.clampRoundInt((float)(sum += (float)mat[srcBands])) : this.destNoDataInt;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectFloat(RasterAccessor s, RasterAccessor d, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s.getScanlineStride();
        int srcPixelStride = s.getPixelStride();
        int srcBands = s.getNumBands();
        int[] srcBandOffsets = s.getBandOffsets();
        float[][] srcData = s.getFloatDataArrays();
        int dstWidth = d.getWidth();
        int dstHeight = d.getHeight();
        int dstBands = d.getNumBands();
        int dstLineStride = d.getScanlineStride();
        int dstPixelStride = d.getPixelStride();
        int[] dstBandOffsets = d.getBandOffsets();
        float[][] dstData = d.getFloatDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s.getX();
        int srcY = s.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sum += (float)mat[srcBands];
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataFloat;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += (float)mat[k] * srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sum += (float)mat[srcBands];
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            float sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * sample;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? (sum += (float)mat[srcBands]) : this.destNoDataFloat;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataFloat;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        float sum = 0.0f;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            float sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (float)mat[k] * sample;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? (sum += (float)mat[srcBands]) : this.destNoDataFloat;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void computeRectDouble(RasterAccessor s, RasterAccessor d, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = s.getScanlineStride();
        int srcPixelStride = s.getPixelStride();
        int srcBands = s.getNumBands();
        int[] srcBandOffsets = s.getBandOffsets();
        double[][] srcData = s.getDoubleDataArrays();
        int dstWidth = d.getWidth();
        int dstHeight = d.getHeight();
        int dstBands = d.getNumBands();
        int dstLineStride = d.getScanlineStride();
        int dstPixelStride = d.getPixelStride();
        int[] dstBandOffsets = d.getBandOffsets();
        double[][] dstData = d.getDoubleDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = s.getX();
        int srcY = s.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double sum = 0.0;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += mat[k] * srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sum += mat[srcBands];
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataDouble;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        double sum = 0.0;
                        double[] mat = this.matrix[b];
                        for (int k = 0; k < srcBands; ++k) {
                            sum += mat[k] * srcData[k][srcPixelOffset + srcBandOffsets[k]];
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sum += (double)((float)mat[srcBands]);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double sum = 0.0;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            double sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += mat[k] * sample;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? (sum += mat[srcBands]) : this.destNoDataDouble;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataDouble;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                        continue;
                    }
                    for (b = 0; b < dstBands; ++b) {
                        double sum = 0.0;
                        double[] mat = this.matrix[b];
                        boolean valid = false;
                        for (int k = 0; k < srcBands; ++k) {
                            double sample = srcData[k][srcPixelOffset + srcBandOffsets[k]];
                            if (this.noData.contains(sample)) continue;
                            valid = true;
                            sum += (double)((float)mat[k] * (float)sample);
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = valid ? (sum += mat[srcBands]) : this.destNoDataDouble;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void initBooleanNoDataTable() {
        this.lut = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            boolean result = true;
            if (this.noData.contains((byte)i)) {
                result = false;
            }
            this.lut[i] = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            BandCombineOpImage bandCombineOpImage = this;
            synchronized (bandCombineOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

