/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jsbchart.core.TemplateType;

public enum BlockType implements TemplateType
{
    WELL("Well Block", "well", "blockWell.png", "blockWellFolder.png", "blockWell_w.png"),
    SCHEME("Scheme Block", "scheme", "blockScheme.png", "blockSchemeFolder.png", "blockScheme_w.png"),
    PROJECT("Project Block", "project", "blockProject.png", "blockProjectFolder.png", "blockProject_w.png"),
    MAP("Map Block", "map", "blockMap.png", "blockMapFolder.png", "blockMap_w.png");

    private final String descr;
    private final String shortDescr;
    private final ImageIcon icon;
    private final ImageIcon iconFolder;
    private final ImageIcon iconSelected;
    private static final String ICON_PATH = "/icon/block/";

    private BlockType(String descr, String shortDescr, String iconString, String iconFolderString, String iconSelectedString) {
        this.descr = descr;
        this.shortDescr = shortDescr;
        this.icon = BlockType.getIcon(iconString);
        this.iconFolder = BlockType.getIcon(iconFolderString);
        this.iconSelected = BlockType.getIcon(iconSelectedString);
    }

    private static ImageIcon getIcon(String pathSuffix) {
        String path = ICON_PATH + pathSuffix;
        try {
            return new ImageIcon(BlockType.class.getResource(path));
        }
        catch (Exception e) {
            Logger.getLogger(BlockType.class.getName()).log(Level.WARNING, "Failed to load icon from path: " + path, e);
            return null;
        }
    }

    public String toString() {
        return this.descr;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getIconSelected() {
        return this.iconSelected;
    }

    public Icon getIconFolder() {
        return this.iconFolder;
    }

    public String getShortDescr() {
        return this.shortDescr;
    }

    public static boolean inheritsWell(BlockType type) {
        switch (type.ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getNoun() {
        return this.descr;
    }

    public String memberTypeString() {
        switch (this.ordinal()) {
            case 3: {
                return "Layer";
            }
        }
        return "Panel";
    }
}

