/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jsbchart.core.AbstractLegend;
import jsbchart.core.ChartProperties;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelType;

public class MapLegend
extends AbstractLegend {
    private float width = 50.0f;
    private float height = 50.0f;
    private final List<DataLayerRecord> dataLayerHeaders = new LinkedList<DataLayerRecord>();
    private final Map<Integer, List<AbstractLegend.TextItem>> layerData = new HashMap<Integer, List<AbstractLegend.TextItem>>();
    private final List<AbstractLegend.TextItem> shapeLayerItems = new LinkedList<AbstractLegend.TextItem>();

    void addMapLayerItem(int layerID, PanelType type, String name) {
        if (type == PanelType.PIN) {
            return;
        }
        this.dataLayerHeaders.add(new DataLayerRecord(layerID, type, name));
        this.layerData.put(layerID, new LinkedList());
    }

    void addDataLayerItem(int layerID, Object item, String description) {
        this.layerData.get(layerID).add(AbstractLegend.TextItem.newValueItem(item, description));
    }

    void clearLayerData(int layerID) {
        if (this.layerData.get(layerID) != null) {
            this.layerData.get(layerID).clear();
        }
    }

    void addMapShapeItem(Color line, Color fill, String layerName) {
        this.shapeLayerItems.add(AbstractLegend.TextItem.newValueItem(new AbstractLegend.ColorPair(line, fill), layerName));
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getWidth() {
        return this.width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getHeight() {
        return this.height;
    }

    private List<AbstractLegend.TextItem> getLegendItems() {
        LinkedList<AbstractLegend.TextItem> list = new LinkedList<AbstractLegend.TextItem>();
        this.dataLayerHeaders.forEach(h -> {
            list.add(AbstractLegend.TextItem.newTitleItem(h.name));
            list.addAll((Collection)this.layerData.get(h.layerID));
        });
        if (!this.shapeLayerItems.isEmpty()) {
            list.add(AbstractLegend.TextItem.newTitleItem("Shape layers"));
            list.addAll(this.shapeLayerItems);
        }
        return list;
    }

    public void calcPreferredHeight(ChartProperties cp) {
        this.height = this.calcIdealHeight(this.getLegendItems(), cp);
    }

    public void calcPreferredWidth(SBGraphics g, ChartProperties cp) {
        this.width = this.calcIdealWidth(this.getLegendItems(), g, cp);
    }

    void draw(SBGraphics g, float x, float y, ChartProperties cp, boolean fillBackground) {
        if (fillBackground) {
            g.fillRect(x, y, this.width, this.height, cp.background);
        }
        super.draw(g, x, y, this.width, this.height, cp, this.getLegendItems(), true);
    }

    public boolean isEmpty() {
        return this.dataLayerHeaders.isEmpty() && this.shapeLayerItems.isEmpty();
    }

    private record DataLayerRecord(int layerID, PanelType type, String name) {
    }
}

