/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.sql.SQLException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.SBPanel;
import model3.SBdb;
import model3.Well;
import model3.project.WellList;
import util.DepthUnits;
import util.SBException;

public class ProjectBlock
extends WellBlock {
    public ProjectBlock(WellList wellList, SBdb sbdb, BlockProperties bp) throws SQLException, SBException {
        super(null, sbdb);
        if (bp != null) {
            this.prop = bp;
        }
        this.setWellList(wellList);
    }

    public ProjectBlock(BlockTemplate template, WellList wellList, SBdb sbdb, BlockProperties bp) throws SBException, SQLException {
        super(sbdb, template);
        this.setWellList(wellList);
        if (wellList != null) {
            this.setWells(sbdb.getWellIterator(wellList.getID()));
        }
        if (bp != null) {
            this.prop = bp;
        } else {
            this.prop = new BlockProperties(BlockProperties.ScaleType.TVD);
            if (wellList != null) {
                Set usedDepthUnits;
                Double minDepth = null;
                Double maxDepth = null;
                for (Well well : this.getWells()) {
                    boolean hasTVD;
                    boolean bl = hasTVD = well.getTVDlist(false) != null && !well.getTVDlist(false).getList().isEmpty();
                    minDepth = minDepth == null ? Double.valueOf(hasTVD ? well.getTVDlist(false).getTopTVD() : well.getTopSampleDepth()) : Double.valueOf(Math.min(hasTVD ? well.getTVDlist(false).getTopTVD() : well.getTopSampleDepth(), minDepth));
                    if (maxDepth == null) {
                        maxDepth = hasTVD ? well.getTVDlist(false).getBaseTVD() : well.getBaseSampleDepth();
                        continue;
                    }
                    maxDepth = Math.max(hasTVD ? well.getTVDlist(false).getBaseTVD() : well.getBaseSampleDepth(), maxDepth);
                }
                if (minDepth != null && maxDepth != null) {
                    this.setTopDepth((float)ProjectBlock.getDefaultDepthBound(true, minDepth, maxDepth, this.getWell().getWellUnits()));
                    this.setBaseDepth((float)ProjectBlock.getDefaultDepthBound(false, minDepth, maxDepth, this.getWell().getWellUnits()));
                    this.setScale((float)ProjectBlock.getDefaultScale(minDepth, maxDepth, this.getWell().getWellUnits()));
                }
                this.prop.units = (usedDepthUnits = this.getWells().stream().map(w -> DepthUnits.getUnits((char)w.getWellUnits())).collect(Collectors.toSet())).size() == 1 ? ((DepthUnits)usedDepthUnits.iterator().next()).getChar() : DepthUnits.M.getChar();
            } else {
                this.prop.setMin(0.0f);
                this.prop.setMax(100.0f);
                this.prop.setScale(1000.0f);
            }
        }
        this.prop.calcHeight();
    }

    @Override
    synchronized float draw(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines, Chart.Mode vMode) {
        return this.drawPanels(g, x, y, p, mode, cLines, vMode);
    }

    @Override
    public void addPanel(SBPanel panel) {
        if (!panel.getPanelType().canPlot(BlockType.PROJECT)) {
            throw new IllegalArgumentException("Attempt to add invalid panel type to ProjectBlock.");
        }
        super.addPanel(panel);
    }

    @Override
    public float getTopDepth() {
        return this.prop.getMin();
    }

    @Override
    public float getBaseDepth() {
        return this.prop.getMax();
    }

    float drawHorz(SBGraphics g, float x, float y, ChartProperties p) {
        this.getHeight();
        Iterator it = this.panels.iterator();
        float yPos = y;
        while (it.hasNext()) {
            SBPanel panel = (SBPanel)it.next();
            yPos += panel.drawHorz(g, x, yPos, p, this.prop);
        }
        return x;
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.PROJECT;
    }

    @Override
    public String getDefaultCaption(ChartProperties p) {
        if (this.getWellList() != null) {
            return this.getWellList().getName();
        }
        return CaptionTemplate.WELLNAME.toDisplayString();
    }
}

