/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum CaptionTemplate {
    WELLNAME("Well name", "wname"),
    WELLCODE("Well code", "wcode"),
    VERSION("Version", "interp"),
    TEMPLNAME("Template name", "templname"),
    SCHEME("Scheme name", "sch"),
    UNITS("Depth units", "unit");

    private final String displayString;
    private final String dbString;
    private static final String nullString = "^NONE^";

    private CaptionTemplate(String displayString, String dbString) {
        this.displayString = displayString;
        this.dbString = dbString;
    }

    public String toDbString() {
        return "^" + this.dbString + "^";
    }

    public String toDisplayString() {
        return "<" + this.displayString + ">";
    }

    public String toPatternString() {
        return "\\<" + this.displayString + "\\>";
    }

    public String toString() {
        return this.toDisplayString();
    }

    public static String getDbString(String caption) {
        if (caption == null) {
            return null;
        }
        if (caption.trim().isEmpty()) {
            return nullString;
        }
        Pattern pattern = Pattern.compile("\\<(.*?)\\>");
        Matcher m = pattern.matcher(caption);
        ArrayList<String> replacements = new ArrayList<String>();
        block0: while (m.find()) {
            int start = m.start();
            int end = m.end();
            String display = caption.substring(start, end);
            for (CaptionTemplate el : CaptionTemplate.values()) {
                if (!el.toDisplayString().equals(display)) continue;
                replacements.add(el.toDbString());
                continue block0;
            }
        }
        for (String replacement : replacements) {
            caption = pattern.matcher(caption).replaceFirst(replacement);
        }
        return caption;
    }

    public static String getDisplayString(String caption) {
        if (caption == null || caption.isEmpty()) {
            return null;
        }
        if (caption.equals(nullString)) {
            return "";
        }
        Pattern pattern = Pattern.compile("\\^(.*?)\\^");
        Matcher m = pattern.matcher(caption);
        ArrayList<String> replacements = new ArrayList<String>();
        block0: while (m.find()) {
            int start = m.start();
            int end = m.end();
            String db = caption.substring(start, end);
            for (CaptionTemplate el : CaptionTemplate.values()) {
                if (!el.toDbString().equals(db)) continue;
                replacements.add(el.toDisplayString());
                continue block0;
            }
        }
        for (String replacement : replacements) {
            caption = pattern.matcher(caption).replaceFirst(replacement);
        }
        return caption;
    }
}

