/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.util.Objects;
import java.util.logging.Logger;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import model3.InterpHdr;
import util.SB;

public class ChartPanelSnapshot {
    private final PanelOcc panelOcc;
    private final PanelOcc panelOccTemp;
    private final PanelTemplate panelTemplate;

    public ChartPanelSnapshot(PanelOcc panelOcc, PanelOcc panelOccTemp, PanelTemplate panelTemplate) {
        Objects.requireNonNull(panelOcc);
        if (panelOcc.getPanelNo() == null && panelOccTemp != null) {
            throw new IllegalStateException("Expected panelOccTemp to be null in ChartPanelSnapshot");
        }
        if (panelTemplate != null && panelTemplate.getID() != panelOcc.panelID) {
            throw new IllegalStateException("ID mismatch in PanelTemplate vs panelOcc");
        }
        this.panelOcc = panelOcc;
        this.panelOccTemp = panelOccTemp;
        this.panelTemplate = panelTemplate;
        if (panelOccTemp != null && panelOccTemp.panelID != panelOcc.panelID) {
            Logger.getLogger(ChartPanelSnapshot.class.getName()).warning("Panel snapshot being used to update panel template ID");
        }
    }

    public PanelOcc getActivePanelOcc() {
        if (this.panelOccTemp != null) {
            return this.panelOccTemp;
        }
        return this.panelOcc;
    }

    public PanelOcc getRealPanelOcc() {
        return this.panelOcc;
    }

    public void updateRealPanelOcc() {
        if (this.panelOccTemp == null || this.panelOccTemp == this.panelOcc) {
            return;
        }
        Object arg = !SB.equal((Object)this.panelOccTemp.getInterpID(), (Object)this.panelOcc.getInterpID()) ? (this.panelOcc.getInterpID() != null ? this.panelOcc.getInterpID() : InterpHdr.class) : null;
        this.panelOcc.copyFields(this.panelOccTemp);
        this.panelOcc.notifyObservers(arg);
    }

    public PanelTemplate getPanelTemplate() {
        return this.panelTemplate;
    }
}

