/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.sql.SQLException;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelWellHeader;
import model3.Lastval;
import model3.SBdb;

public class ChartPropertiesFactory {
    public static final String PREF_STRING = "CHTPROP";
    public static final String PREF_STRING_SCH = "CHTPROPSCH";
    public static final String PREF_STRING_HDR = "CHTPROPHDR";
    public static final String PREF_STRING_KEY = "CHTPROPKEY";

    private ChartPropertiesFactory() {
    }

    public static ChartProperties newInstance(SBdb sbdb) {
        return ChartPropertiesFactory.newInstance(sbdb, new ChartProperties());
    }

    public static ChartProperties newDecodedInstance(SBdb sbdb) {
        return ChartPropertiesFactory.newInstance(sbdb, null);
    }

    private static ChartProperties newInstance(SBdb sbdb, ChartProperties defaultObject) {
        String keyEncoded;
        String hdrEncoded;
        String schEncoded;
        String encoded;
        if (sbdb == null) {
            return defaultObject;
        }
        try {
            encoded = Lastval.getString((SBdb)sbdb, (String)PREF_STRING);
            schEncoded = Lastval.getString((SBdb)sbdb, (String)PREF_STRING_SCH);
            hdrEncoded = Lastval.getString((SBdb)sbdb, (String)PREF_STRING_HDR);
            keyEncoded = Lastval.getString((SBdb)sbdb, (String)PREF_STRING_KEY);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return defaultObject;
        }
        int schID = 0;
        if (schEncoded != null) {
            try {
                schID = Integer.parseInt(schEncoded);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ChartProperties cp = new ChartProperties(encoded, schID);
        if (hdrEncoded != null && !hdrEncoded.trim().isEmpty()) {
            cp.header = new PanelWellHeader(hdrEncoded);
        }
        if (keyEncoded != null && !keyEncoded.trim().isEmpty()) {
            cp.key = new PanelKey(keyEncoded);
        }
        cp.clearNonPrefFields();
        return cp;
    }
}

