/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplateBase;
import jsbchart.correlation.CorrStdOcc;
import jsbchart.correlation.CorrTemplateOcc;
import jsbchart.correlation.CorrelationScope;
import jsbchart.correlation.CorrelationType;
import jsbchart.tag.ChartTag;
import jsbchart.tag.ChartTagManager;
import jsbchart.tag.ChartTagTemplate;
import model3.Audit;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.Well;
import org.jdom2.Element;
import util.DepthUnits;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class ChartTemplate
extends ChartTemplateBase {
    private static String TABLE_NAME = "CHART";
    private static String TABLE_NAME_MBR = "CHTMBR";
    private static String TABLE_ID_FIELD = "chart_id";
    private String props;
    private String headerProps;
    private String keyProps;
    private int schID;
    private int wellListID;
    private LinkedList<BlockOcc> blocks;
    private Set<CorrTemplateOcc> corrTemplates;
    private Set<CorrStdOcc> corrStds;
    private Set<ChartTagTemplate> tags;
    private WeakHashMap<Chart, Object> charts = new WeakHashMap();
    private static final Object obj = new Object();
    private ChartTemplate link;

    public ChartTemplate(ChartManager manager, int ID, String descr, String comments, int projID, int wellListID, String props, int schID, String header, String key, Audit audit, int acm) {
        super(manager, ID, descr, comments, projID, audit, TABLE_NAME, TABLE_ID_FIELD, acm);
        if (ID == 0) {
            this.blocks = new LinkedList();
            this.corrTemplates = new HashSet<CorrTemplateOcc>();
            this.corrStds = new HashSet<CorrStdOcc>();
            this.tags = new HashSet<ChartTagTemplate>();
        }
        this.props = props;
        this.schID = schID;
        this.wellListID = wellListID;
        this.headerProps = header;
        this.keyProps = key;
    }

    @Override
    String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getTypeDescr() {
        return "chart";
    }

    @Override
    String getTableNameMbr() {
        return TABLE_NAME_MBR;
    }

    @Override
    String getTableIDField() {
        return TABLE_ID_FIELD;
    }

    @Override
    public Enum getType() {
        return null;
    }

    @Override
    public boolean hasWellList() {
        return true;
    }

    @Override
    public int getWellListID() {
        return this.wellListID;
    }

    void setWellListID(int ID) {
        this.wellListID = ID;
    }

    @Override
    String getInsertFields(SBdb sbdb, int ID) {
        return "INSERT INTO " + sbdb.DBTableName(this.getTableName()) + " (chart_id,descr,comments,props,header,cht_key,proj_id,wellist_id";
    }

    @Override
    String getInsertValues(SBdb sbdb, int ID) {
        return ID + ",?,?," + SB.DBString((String)this.props) + "," + SB.DBString((String)this.headerProps) + "," + SB.DBString((String)this.keyProps) + "," + ChartManager.getIDString(this.getProjID()) + "," + ChartManager.getIDString(this.getWellListID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(SBdb sbdb, List<BlockOcc> newbOccs, Set<CorrTemplateOcc> newcTempOccs, Set<CorrStdOcc> newcsTempOccs, Set<ChartTagTemplate> newTags, String properties, String header, String key, int bgSchID) throws SQLException, SBException, IOException, SBPermissionException {
        try (Statement stmt = null;){
            Object sql;
            if (!(this.props != null && this.props.equals(properties) && this.schID == bgSchID && SB.equal((Object)header, (Object)this.headerProps) && SB.equal((Object)key, (Object)this.keyProps))) {
                String sql2 = "UPDATE " + sbdb.DBTableName("CHART") + " set props=" + SB.DBString((String)properties) + ",wellist_id=" + String.valueOf(this.wellListID > 0 ? Integer.valueOf(this.wellListID) : "NULL") + ",sch_id=" + String.valueOf(bgSchID > 0 ? Integer.valueOf(bgSchID) : "NULL") + ",header=" + (header != null ? SB.DBString((String)header) : "NULL") + ",cht_key=" + (key != null ? SB.DBString((String)key) : "NULL") + " WHERE chart_id=" + this.getID();
                if (stmt == null) {
                    stmt = sbdb.getDatabase().createStatement();
                }
                if (!this.canWrite(sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(sbdb, "update", "chart template", true));
                }
                stmt.executeUpdate(sbdb.modQuery(sql2));
            }
            ChartTagManager tagManager = new ChartTagManager(sbdb);
            boolean updatedCHTMBR = false;
            if (!newbOccs.equals(this.blocks)) {
                updatedCHTMBR = true;
                if (stmt == null) {
                    stmt = sbdb.getDatabase().createStatement();
                }
                if (!this.canWrite(sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(sbdb, "update", "chart template", true));
                }
                tagManager.deleteTagsForChart(this.getID());
                sql = "DELETE FROM " + sbdb.DBTableName("CHTMBR") + " WHERE chart_id=" + this.getID();
                stmt.executeUpdate(sbdb.modQuery((String)sql));
                int blockNo = 0;
                for (BlockOcc occ : newbOccs) {
                    sql = "INSERT INTO " + sbdb.DBTableName("CHTMBR") + " (chart_id,block_id,block_no,well_id,wellist_id,interp_id,props,caption) VALUES (" + this.getID() + "," + occ.getBlockID() + "," + blockNo + ",";
                    sql = (String)sql + String.valueOf(occ.getWellID() > 0 ? Integer.valueOf(occ.getWellID()) : "NULL") + ",";
                    sql = (String)sql + String.valueOf(occ.getWellListID() > 0 ? Integer.valueOf(occ.getWellListID()) : "NULL") + ",";
                    sql = (String)sql + String.valueOf(occ.getInterpID() > 0 ? Integer.valueOf(occ.getInterpID()) : "NULL") + ",";
                    sql = (String)sql + SB.DBString((String)occ.getProps()) + ",";
                    sql = (String)sql + SB.DBString((String)CaptionTemplate.getDbString(occ.getCaption())) + ")";
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    ++blockNo;
                }
                this.blocks = new LinkedList<BlockOcc>(newbOccs);
            }
            if (!newcTempOccs.equals(this.corrTemplates)) {
                if (stmt == null) {
                    stmt = sbdb.getDatabase().createStatement();
                }
                if (!this.canWrite(sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(sbdb, "update", "chart template", true));
                }
                sql = "DELETE FROM " + sbdb.DBTableName("CHTCORROCC") + " where chart_id=" + this.getID();
                stmt.executeUpdate(sbdb.modQuery((String)sql));
                for (CorrTemplateOcc corrTemplateOcc : newcTempOccs) {
                    sql = corrTemplateOcc.getDbInsertString(sbdb, this.getID());
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                }
                this.corrTemplates = newcTempOccs;
            }
            if (!newcsTempOccs.equals(this.corrStds)) {
                if (stmt == null) {
                    stmt = sbdb.getDatabase().createStatement();
                }
                if (!this.canWrite(sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(sbdb, "update", "chart template", true));
                }
                sql = "DELETE FROM " + sbdb.DBTableName("CHTCORROCC_STD") + " where chart_id=" + this.getID();
                stmt.executeUpdate(sbdb.modQuery((String)sql));
                sql = "DELETE FROM " + sbdb.DBTableName("CHTCORROCC_STD_UNIT") + " where chart_id=" + this.getID();
                stmt.executeUpdate(sbdb.modQuery((String)sql));
                for (CorrStdOcc corrStdOcc : newcsTempOccs) {
                    sql = corrStdOcc.getDbInsertString(sbdb, this.getID());
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                }
                this.corrStds = newcsTempOccs;
            }
            if (updatedCHTMBR || !newTags.equals(this.tags)) {
                if (stmt == null) {
                    stmt = sbdb.getDatabase().createStatement();
                }
                if (!this.canWrite(sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(sbdb, "update", "chart template", true));
                }
                if (!updatedCHTMBR) {
                    tagManager.deleteTagsForChart(this.getID());
                }
                for (ChartTagTemplate tag : newTags) {
                    tagManager.insertChartTag(this.getID(), tag);
                }
                this.tags = newTags;
            }
            if (stmt != null) {
                this.updateAudit(sbdb, stmt);
            }
        }
        this.props = properties;
        this.headerProps = header;
        this.keyProps = key;
        this.schID = bgSchID;
        if (stmt != null) {
            this.fireTemplateUpdated(sbdb);
        }
    }

    synchronized int[] deleteWell(SBdb sbdb, int wellID, Statement stmt) throws SQLException {
        boolean deletedBlocks = false;
        boolean updatedSchemeBlocks = true;
        int deleteChart = 2;
        int[] results = new int[3];
        if (sbdb.isConnected()) {
            String sql = "SELECT count(block_id) as n FROM " + sbdb.DBTableName("CHTMBR") + " WHERE chart_id=" + this.getID() + " AND well_id=" + wellID;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            int nMbrs = 0;
            if (rs.next()) {
                nMbrs = rs.getInt("n");
            }
            if (nMbrs < 1) {
                return results;
            }
            sql = "DELETE FROM " + sbdb.DBTableName("CHTMBR") + " WHERE chart_id=" + this.getID() + " AND well_id=" + wellID + " AND block_id IN(SELECT block_id FROM " + sbdb.DBTableName("CHTBLOCK") + " WHERE type=" + SB.DBString((String)BlockType.WELL.name()) + ")";
            results[0] = stmt.executeUpdate(sbdb.modQuery(sql));
            if (results[0] < nMbrs) {
                sql = "UPDATE " + sbdb.DBTableName("CHTMBR") + " set well_id=NULL, interp_id=NULL WHERE chart_id=" + this.getID() + " AND well_id=" + wellID + " AND block_id IN(SELECT block_id FROM " + sbdb.DBTableName("CHTBLOCK") + " WHERE type=" + SB.DBString((String)BlockType.SCHEME.name()) + ")";
                results[1] = stmt.executeUpdate(sql);
            }
            assert (results[0] + results[1] == nMbrs);
        }
        if (this.blocks == null && sbdb.isConnected()) {
            int n;
            ResultSet rs2 = stmt.executeQuery(sbdb.modQuery("SELECT count(block_id) as n FROM " + sbdb.DBTableName("CHTMBR") + " WHERE chart_id=" + this.getID()));
            if (rs2.next() && (n = rs2.getInt("n")) < 1) {
                results[2] = 1;
            }
        } else {
            boolean changed = false;
            ListIterator<BlockOcc> it = this.blocks.listIterator();
            while (it.hasNext()) {
                BlockOcc occ = (BlockOcc)it.next();
                if (occ.getWellID() != wellID) continue;
                switch (this.getBlockTemplate(occ.getBlockID()).getType()) {
                    case WELL: {
                        it.remove();
                        changed = true;
                        break;
                    }
                    case SCHEME: {
                        it.remove();
                        it.add(new BlockOcc(occ.getBlockID(), 0, occ.getWellListID(), 0, occ.getProps(), occ.caption));
                        changed = true;
                    }
                }
            }
            if (this.blocks.isEmpty()) {
                results[2] = 1;
            }
            if (changed) {
                this.fireWellDeleted(wellID);
            }
        }
        return results;
    }

    synchronized void loadMbrs(SBdb sbdb, Statement stmt) throws SQLException {
        String dataTypes;
        if (this.blocks != null && this.corrTemplates != null && this.corrStds != null) {
            return;
        }
        String sql = "SELECT block_id,block_no,well_id,wellist_id,interp_id,props,caption FROM " + sbdb.DBTableName("CHTMBR") + " WHERE chart_id=" + this.getID() + " ORDER BY block_no";
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        this.blocks = new LinkedList();
        while (rs.next()) {
            BlockOcc bo = new BlockOcc(rs.getInt("block_id"));
            bo.wellID = rs.getInt("well_id");
            bo.wellListID = rs.getInt("wellist_id");
            bo.interpID = rs.getInt("interp_id");
            bo.props = rs.getString("props");
            bo.caption = CaptionTemplate.getDisplayString(rs.getString("caption"));
            this.blocks.add(bo);
        }
        rs.close();
        this.corrTemplates = new HashSet<CorrTemplateOcc>();
        sql = "SELECT corrsch_id,interp_id,prop,style,datum from " + sbdb.DBTableName("CHTCORROCC") + " WHERE chart_id=" + this.getID();
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            int cSchID = rs.getInt("corrsch_id");
            int interpID = rs.getInt("interp_id");
            CorrelationPropParser prop = new CorrelationPropParser(rs.getString("prop"));
            String style = rs.getString("style");
            String datum = rs.getString("datum");
            this.corrTemplates.add(new CorrTemplateOcc(cSchID, interpID, prop.visible, style, datum, prop.maxUnconfidence, prop.correlateRangedIntervals, prop.useBlockInterp));
        }
        rs.close();
        this.corrStds = new HashSet<CorrStdOcc>();
        sql = "SELECT type,scope,data_types,interp_id,prop,style from " + sbdb.DBTableName("CHTCORROCC_STD") + " WHERE chart_id=" + this.getID();
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            CorrelationType type = CorrelationType.valueOf(rs.getString("type"));
            CorrelationScope scope = CorrelationScope.valueOf(rs.getString("scope"));
            dataTypes = rs.getString("data_types");
            int interpID = rs.getInt("interp_id");
            CorrelationPropParser prop = new CorrelationPropParser(rs.getString("prop"));
            String style = rs.getString("style");
            this.corrStds.add(new CorrStdOcc(type, scope, CorrelationType.getDataTypes(type, dataTypes), prop.visible, style, interpID, prop.maxUnconfidence, prop.correlateRangedIntervals, prop.useBlockInterp));
        }
        rs.close();
        sql = "SELECT type,scope,data_types,interp_id,sch_id,hier,prop,style from " + sbdb.DBTableName("CHTCORROCC_STD_UNIT") + " WHERE chart_id=" + this.getID();
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            CorrelationType type = CorrelationType.valueOf(rs.getString("type"));
            CorrelationScope scope = CorrelationScope.valueOf(rs.getString("scope"));
            dataTypes = rs.getString("data_types");
            int interpID = rs.getInt("interp_id");
            int schemeID = rs.getInt("sch_id");
            int hier = rs.getInt("hier");
            CorrelationPropParser prop = new CorrelationPropParser(rs.getString("prop"));
            String style = rs.getString("style");
            this.corrStds.add(new CorrStdOcc(type, scope, CorrelationType.getDataTypes(type, dataTypes), prop.visible, style, interpID, schemeID, hier, prop.maxUnconfidence, prop.correlateRangedIntervals, prop.useBlockInterp));
        }
        rs.close();
        ChartTagManager tm = new ChartTagManager(sbdb);
        this.tags = new HashSet<ChartTagTemplate>(tm.getTagsForChart(this, this.blocks));
    }

    @Override
    void storeMembers(SBdb sbdb) throws SQLException, SBPermissionException, SBException {
        LinkedList<BlockOcc> blocks2 = new LinkedList<BlockOcc>(this.blocks);
        this.blocks.clear();
        HashSet<CorrTemplateOcc> corrTemplates2 = new HashSet<CorrTemplateOcc>(this.corrTemplates);
        this.corrTemplates.clear();
        HashSet<CorrStdOcc> corrStds2 = new HashSet<CorrStdOcc>(this.corrStds);
        this.corrStds.clear();
        HashSet<ChartTagTemplate> tags2 = new HashSet<ChartTagTemplate>(this.tags);
        this.tags.clear();
        String props2 = this.props;
        this.props = null;
        String headerProps2 = this.headerProps;
        this.headerProps = null;
        String keyProps2 = this.keyProps;
        this.keyProps = null;
        int schID2 = this.schID;
        this.schID = 0;
        try {
            this.update(sbdb, blocks2, corrTemplates2, corrStds2, tags2, props2, headerProps2, keyProps2, schID2);
        }
        catch (IOException io) {
            throw new SBException(io.getMessage(), (Throwable)io);
        }
    }

    @Override
    public synchronized int getnMbrs() {
        return this.blocks.size();
    }

    @Override
    public String getTypeString() {
        return "Chart";
    }

    private synchronized BlockOcc getOcc(int blockTemplID) {
        for (BlockOcc occ : this.blocks) {
            if (occ.getBlockID() != blockTemplID) continue;
            return occ;
        }
        return null;
    }

    public synchronized List<BlockOcc> getBlocks() {
        return new LinkedList<BlockOcc>(this.blocks);
    }

    public synchronized Set<CorrTemplateOcc> getCorrOccs() {
        return new HashSet<CorrTemplateOcc>(this.corrTemplates);
    }

    public synchronized Set<CorrStdOcc> getCorrStdOccs() {
        return new HashSet<CorrStdOcc>(this.corrStds);
    }

    public Set<ChartTagTemplate> getTagTemplates() {
        HashSet<ChartTagTemplate> copy = new HashSet<ChartTagTemplate>();
        this.tags.forEach(t -> copy.add(t.getCopy()));
        return copy;
    }

    public synchronized Set<ChartTag> getTags(Chart c) {
        HashSet<ChartTag> copy = new HashSet<ChartTag>();
        this.tags.forEach(t -> copy.add(t.buildTag(c)));
        return copy;
    }

    public int getWellID(int blockTempID) {
        return this.getOcc(blockTempID).getWellID();
    }

    public int getInterpID(int blockID) {
        return this.getOcc(blockID).getInterpID();
    }

    public String getProps(int blockID) {
        return this.getOcc(blockID).getProps();
    }

    public synchronized String getProperties() {
        return this.props;
    }

    public String getHeaderProperties() {
        return this.headerProps;
    }

    public String getKeyProperties() {
        return this.keyProps;
    }

    public int getSchID() {
        return this.schID;
    }

    @Override
    void checkProjectChange(SBdb sbdb, Statement stmt, int newProjID, boolean forCopy) throws SQLException, InvalidFieldException {
        int n;
        int max;
        String sql = "SELECT max(b.proj_id) as max from " + sbdb.DBTableName("CHTBLOCK") + " b, " + sbdb.DBTableName("CHTMBR") + " m WHERE m.chart_id=" + this.getID() + " AND b.block_id=m.block_id";
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        if (rs.next() && (max = rs.getInt("max")) > 0) {
            throw new InvalidFieldException("Cannot update project: this chart uses non-global block templates");
        }
        if (newProjID > 0 && (rs = stmt.executeQuery(sbdb.modQuery(sql = "SELECT count(well_id) as n FROM " + sbdb.DBTableName("CHTMBR") + " WHERE chart_id=" + this.getID() + " AND well_id IS NOT NULL AND well_ID NOT IN (SELECT well_id FROM " + sbdb.DBTableName("WELLIST_MBR") + " m, " + sbdb.DBTableName("PROJECT") + " p, " + sbdb.DBTableName("WELLIST") + " w WHERE m.WELLIST_ID=w.WELLIST_ID AND w.PROJ_ID=p.PROJ_ID AND p.PROJ_ID= " + newProjID + ")"))).next() && (n = rs.getInt("n")) > 0) {
            throw new InvalidFieldException("Cannot update project: chart contains wells not in new project");
        }
    }

    @Override
    void preDelete(SBdb sbdb, Statement stmt) throws SQLException {
        String[] sql = new String[]{"DELETE FROM " + sbdb.DBTableName("CHTCORROCC") + " WHERE chart_id=" + this.getID(), "DELETE FROM " + sbdb.DBTableName("CHTCORROCC_STD") + " WHERE chart_id=" + this.getID(), "DELETE FROM " + sbdb.DBTableName("CHTCORROCC_STD_UNIT") + " WHERE chart_id=" + this.getID(), "DELETE FROM " + sbdb.DBTableName("CHTPREF_CHT") + " WHERE chart_id=" + this.getID()};
        for (String q : sql) {
            stmt.executeUpdate(sbdb.modQuery(q));
        }
    }

    void registerChartListener(Chart chart) {
        this.charts.put(chart, obj);
    }

    void removeChartListener(Chart chart) {
        this.charts.remove(chart);
    }

    private void fireWellDeleted(int wellID) {
        for (Chart chart : this.charts.keySet()) {
            chart.wellDeleted(wellID);
        }
    }

    private void fireTemplateUpdated(SBdb sbdb) throws SQLException, SBException, IOException {
        for (Chart chart : this.charts.keySet()) {
            chart.updateFromTemplate(sbdb);
        }
    }

    synchronized void refresh(ChartTemplate updated, SBdb sbdb) throws SQLException, SBException, IOException {
        if (updated.getID() != this.getID()) {
            throw new IllegalArgumentException("Attempt to update chart template " + String.valueOf(this) + " from different template");
        }
        super.refreshDescr(updated);
        this.props = updated.props;
        this.headerProps = updated.headerProps;
        this.keyProps = updated.keyProps;
        this.schID = updated.schID;
        this.blocks = updated.blocks;
        this.corrTemplates = updated.corrTemplates;
        this.corrStds = updated.corrStds;
        this.fireTemplateUpdated(sbdb);
    }

    @Override
    ChartTemplateBase copy(ChartManager chartManager, String descr, String comments, int projID) {
        ChartTemplate copy = new ChartTemplate(chartManager, 0, descr, comments, projID, this.getProjID() == projID ? this.wellListID : 0, this.props, this.schID, this.headerProps, this.keyProps, new Audit(), 0);
        return copy;
    }

    void addOcc(Object occ) {
        if (this.getID() > 0 && this.isConnected()) {
            throw new IllegalStateException("Attempt to add ?Occ to stored ChartTemplate");
        }
        if (occ instanceof BlockOcc) {
            if (this.blocks == null) {
                this.blocks = new LinkedList();
            }
            this.blocks.add((BlockOcc)occ);
            return;
        }
        if (occ instanceof CorrTemplateOcc) {
            if (this.corrTemplates == null) {
                this.corrTemplates = new HashSet<CorrTemplateOcc>();
            }
            this.corrTemplates.add((CorrTemplateOcc)occ);
            return;
        }
        if (occ instanceof CorrStdOcc) {
            if (this.corrStds == null) {
                this.corrStds = new HashSet<CorrStdOcc>();
            }
            this.corrStds.add((CorrStdOcc)occ);
            return;
        }
        throw new IllegalArgumentException("Illegal element to add to chart template: " + String.valueOf(occ.getClass()));
    }

    void writeXML(BufferedWriter out, int indent, SBdb ws, int singleUserID) throws IOException, SQLException, SBException {
        String ind = SB.getXMLIndent((int)indent);
        out.write(ind + "<Description>" + SB.getXMLstring((String)this.getName()) + "</Description>\n");
        if (this.getComments() != null && !this.getComments().trim().isEmpty()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.getComments().trim()) + "</Comments>\n");
        }
        out.write(ind + "<Properties>" + this.props + "</Properties>\n");
        if (this.headerProps != null) {
            out.write(ind + "<HeaderProperties>" + SB.getXMLstring((String)this.headerProps) + "</HeaderProperties>\n");
        }
        if (this.keyProps != null) {
            out.write(ind + "<KeyProperties>" + this.keyProps + "</KeyProperties>\n");
        }
        if (this.schID > 0) {
            out.write(ind + "<StratigraphicSchemeID>" + this.schID + "</StratigraphicSchemeID>\n");
        }
        this.writeAuditXML(out, indent, singleUserID);
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        for (BlockOcc blockOcc : this.blocks) {
            BlockTemplate blockTemplate = this.getBlockTemplate(blockOcc.getBlockID());
            out.write(ind + "<Block BlockTemplateID=\"" + blockOcc.blockID + "\">\n");
            ArrayList<Well> wells = new ArrayList<Well>();
            if (blockOcc.wellID > 0) {
                wells.add(ws.getWell(blockOcc.getWellID()));
            } else if (blockOcc.wellListID > 0) {
                Iterator it = ws.getWellIterator(blockOcc.wellListID);
                while (it.hasNext()) {
                    wells.add((Well)it.next());
                }
            }
            for (Well well : wells) {
                out.write(ind2 + "<WellCode>" + well.getWellCode() + "</WellCode>\n");
            }
            if (!wells.isEmpty()) {
                try {
                    if (ws.getInterp(blockOcc.interpID) != null) {
                        out.write(ind2 + "<WellInterpretationID ID=\"" + blockOcc.interpID + "\" Description=\"" + ws.getInterp(blockOcc.interpID).getDescription() + "\"/>\n");
                    } else {
                        System.out.println("Interp null in blockOcc");
                    }
                }
                catch (SQLException sql) {
                    throw new RuntimeException("Unexpected SQL error", sql);
                }
            }
            if (blockOcc.caption != null) {
                out.write(ind2 + "<Caption>" + SB.getXMLstring((String)blockOcc.caption) + "</Caption>\n");
            }
            out.write(ind2 + "<Properties>" + (switch (blockTemplate.getType()) {
                default -> {
                    BlockProperties bp = new BlockProperties(blockOcc.props);
                    yield bp;
                }
                case BlockType.MAP -> {
                    MapBlockProperties mbp = new MapBlockProperties(blockOcc.props);
                    yield mbp;
                }
            }).getProperties() + "</Properties>\n");
            out.write(ind + "</Block>\n");
        }
        if (this.corrStds != null) {
            for (CorrStdOcc corrStdOcc : this.corrStds) {
                corrStdOcc.writeXML(out, ws, indent);
            }
        }
        if (this.corrTemplates != null) {
            for (CorrTemplateOcc corrTemplateOcc : this.corrTemplates) {
                corrTemplateOcc.writeXML(out, ws, indent, this.getCorrelationTemplate(corrTemplateOcc.getCorrschID()).getType());
            }
        }
    }

    static ChartTemplate parseXML(ChartManager wsCM, SBdb ws, Element xml, int projID) throws SQLException, ParseException, SBException {
        ChartTemplate templ = new ChartTemplate(wsCM, Integer.parseInt(xml.getAttributeValue("ChartID")), xml.getChildText("Description"), xml.getChildText("Comments"), projID, 0, xml.getChildText("Properties"), xml.getChildText("StratigraphicSchemeID") != null ? Integer.parseInt(xml.getChildText("StratigraphicSchemeID")) : 0, xml.getChildText("HeaderProperties"), xml.getChildText("KeyProperties"), new Audit(ws, xml.getChild("Audit")), 0);
        templ.blocks = new LinkedList();
        for (Element blockChild : xml.getChildren("Block")) {
            int wellID = 0;
            int blockOccProjID = 0;
            Iterator wells = new ArrayList<Well>();
            for (Element wellEl : blockChild.getChildren("WellCode")) {
                String wellCode = wellEl.getText();
                Well well = ws.getWell(wellCode);
                if (well == null) continue;
                wells.add(well);
            }
            if (wells.size() == 1) {
                wellID = ((Well)wells.get(0)).getWellID();
            } else {
                Iterator iterator = wells.iterator();
                while (iterator.hasNext()) {
                    Well well = (Well)iterator.next();
                    try {
                        ws.addWellToProject(well, 1);
                    }
                    catch (SBPermissionException pe) {
                        throw new SBException("Unexpected Permission Exception in workspace", (Throwable)pe);
                    }
                }
                blockOccProjID = 1;
            }
            int interpID = 0;
            Element el = blockChild.getChild("WellInterpretationID");
            if (el != null) {
                interpID = ChartManager.parseInterpIDelement(ws, el);
            } else assert (wells.isEmpty());
            if (blockChild.getChildText("Properties") != null) {
                templ.blocks.add(new BlockOcc(Integer.parseInt(blockChild.getAttributeValue("BlockTemplateID")), wellID, blockOccProjID, interpID, blockChild.getChildText("Properties"), blockChild.getChildText("Caption")));
                continue;
            }
            BlockProperties bp = new BlockProperties();
            bp.setUnits(DepthUnits.getUnits((char)blockChild.getChildText("Units").charAt(0)).getChar());
            bp.setScaleType(BlockProperties.ScaleType.valueOf(blockChild.getChildText("ScaleType")));
            if (blockChild.getChildText("ScaleMinimum") != null) {
                bp.setMin(Float.parseFloat(blockChild.getChildText("ScaleMinimum")));
                bp.setMax(Float.parseFloat(blockChild.getChildText("ScaleMaximum")));
                bp.setScale(Float.parseFloat(blockChild.getChildText("Scale")));
            } else {
                for (Element scaleEl : blockChild.getChildren("ScaleSection")) {
                    float min = Float.parseFloat(scaleEl.getChildText("ScaleMinimum"));
                    float max = Float.parseFloat(scaleEl.getChildText("ScaleMaximum"));
                    float scale = Float.parseFloat(scaleEl.getChildText("Scale"));
                    bp.addScaleSection(min, max, scale);
                }
            }
            templ.blocks.add(new BlockOcc(Integer.parseInt(blockChild.getAttributeValue("BlockTemplateID")), wellID, blockOccProjID, interpID, bp.getProperties(), blockChild.getChildText("Caption")));
        }
        templ.corrStds = new HashSet<CorrStdOcc>();
        for (Element corrEl : xml.getChildren("StandardCorrelation")) {
            CorrelationType corrType = CorrelationType.valueOf(corrEl.getChildText("CorrelationType"));
            EnumSet<EventType> dataTypes = null;
            switch (corrType) {
                case EVENT: {
                    for (Element e : corrEl.getChildren("EventType")) {
                        EventType type = EventType.valueOf((String)e.getText());
                        if (dataTypes == null) {
                            dataTypes = EnumSet.of(type);
                            continue;
                        }
                        dataTypes.add(type);
                    }
                    break;
                }
                case CHRONO: 
                case LITHO: 
                case BIOZONE: {
                    for (Element e : corrEl.getChildren("BoundaryType")) {
                        IGDIntervalZone.BoundaryType type = IGDIntervalZone.BoundaryType.valueOf((String)e.getText());
                        if (dataTypes == null) {
                            dataTypes = EnumSet.of(type);
                            continue;
                        }
                        dataTypes.add((EventType)type);
                    }
                    break;
                }
            }
            int schID = 0;
            int hier = 0;
            Element el = corrEl.getChild("StratigraphicSchemeID");
            if (el != null) {
                schID = Integer.parseInt(el.getText());
            }
            if ((el = corrEl.getChild("HierarchyLevel")) != null) {
                hier = IGDIntervalZone.getHierNumber((int)DataType.getIGDType((DataType)corrType.getDataType()), (String)el.getText(), (boolean)true);
            }
            int maxUnconfidence = 0;
            el = corrEl.getChild("MinimumConfidence");
            if (el != null) {
                maxUnconfidence = Confidence.valueOf((String)el.getText()).getDBint();
            }
            boolean correlateRangedIntervals = true;
            el = corrEl.getChild("CorrelateRangedIntervals");
            if (el != null) {
                correlateRangedIntervals = Boolean.valueOf(el.getText());
            }
            boolean useBlockInterp = false;
            templ.corrStds.add(new CorrStdOcc(corrType, CorrelationScope.valueOf(corrEl.getChildText("CorrelationScope")), dataTypes, Boolean.valueOf(corrEl.getChildText("VisibleOnly")), corrEl.getChildText("Properties"), ChartManager.parseInterpIDelement(ws, corrEl.getChild("WellInterpretationID")), schID, hier, maxUnconfidence, correlateRangedIntervals, useBlockInterp));
        }
        templ.corrTemplates = new HashSet<CorrTemplateOcc>();
        for (Element corrEl : xml.getChildren("Correlation")) {
            int maxUnconfidence = 0;
            Element el = corrEl.getChild("MinimumConfidence");
            if (el != null) {
                maxUnconfidence = Confidence.valueOf((String)el.getText()).getDBint();
            }
            boolean correlateRangedIntervals = true;
            el = corrEl.getChild("CorrelateRangedIntervals");
            if (el != null) {
                correlateRangedIntervals = Boolean.valueOf(el.getText());
            }
            boolean useBlockInterp = false;
            templ.corrTemplates.add(new CorrTemplateOcc(Integer.parseInt(corrEl.getAttributeValue("CorrelationID")), ChartManager.parseInterpIDelement(ws, corrEl.getChild("WellInterpretationID")), Boolean.valueOf(corrEl.getChildText("VisibleOnly")), corrEl.getChildText("Properties"), corrEl.getChildText("Datum"), maxUnconfidence, correlateRangedIntervals, useBlockInterp));
        }
        templ.tags = new HashSet<ChartTagTemplate>();
        return templ;
    }

    ChartTemplate getLink() {
        return this.link;
    }

    void setLink(ChartTemplate link) {
        this.link = link;
    }

    public static class BlockOcc {
        private final int blockID;
        private int wellID;
        private int wellListID;
        private int interpID;
        private String props;
        private String caption;

        public BlockOcc(int blockID) {
            this.blockID = blockID;
        }

        public BlockOcc(int blockID, int wellID, int wellListID, int interpID, String props, String caption) {
            this.blockID = blockID;
            this.wellID = wellID;
            this.wellListID = wellListID;
            this.interpID = interpID;
            this.props = props;
            this.caption = caption;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockOcc) {
                BlockOcc rhs = (BlockOcc)obj;
                if (rhs.getBlockID() != this.getBlockID()) {
                    return false;
                }
                if (rhs.getWellID() != this.getWellID()) {
                    return false;
                }
                if (rhs.getWellListID() != this.getWellListID()) {
                    return false;
                }
                if (rhs.getInterpID() != this.getInterpID()) {
                    return false;
                }
                if (!Objects.equals(rhs.getProps(), this.getProps())) {
                    return false;
                }
                if (rhs.caption == null ^ this.caption == null) {
                    return false;
                }
                return this.caption == null || rhs.caption == null || this.caption.equals(rhs.caption);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + this.getBlockID();
            hash = 47 * hash + this.getWellID();
            hash = 47 * hash + this.getWellListID();
            hash = 47 * hash + this.getInterpID();
            hash = 47 * hash + (this.getProps() != null ? this.getProps().hashCode() : 0);
            hash = 47 * hash + (this.caption != null ? this.caption.hashCode() : 0);
            return hash;
        }

        public int getBlockID() {
            return this.blockID;
        }

        public int getWellID() {
            return this.wellID;
        }

        public int getWellListID() {
            return this.wellListID;
        }

        public int getInterpID() {
            return this.interpID;
        }

        public String getProps() {
            return this.props;
        }

        public String getCaption() {
            return this.caption;
        }
    }

    private static class CorrelationPropParser {
        final boolean visible;
        final boolean useBlockInterp;
        final int maxUnconfidence;
        final boolean correlateRangedIntervals;

        CorrelationPropParser(String prop) {
            boolean vis = false;
            boolean ubi = false;
            int maxUnconf = 100;
            boolean correlateRangedInts = true;
            if (prop != null) {
                String[] s = prop.split("\\|");
                block6: for (int i = 0; i < s.length; ++i) {
                    switch (i) {
                        case 0: {
                            vis = s[i].charAt(0) == 'Y';
                            continue block6;
                        }
                        case 1: {
                            maxUnconf = Integer.parseInt(s[i]);
                            continue block6;
                        }
                        case 2: {
                            correlateRangedInts = s[i].charAt(0) == 'Y';
                            continue block6;
                        }
                        case 3: {
                            ubi = s[i].charAt(0) == 'Y';
                        }
                    }
                }
            }
            this.visible = vis;
            this.maxUnconfidence = maxUnconf;
            this.correlateRangedIntervals = correlateRangedInts;
            this.useBlockInterp = ubi;
        }
    }
}

