/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.core.BlockColumn;
import jsbchart.core.ChartLayout;
import jsbchart.core.ChartProperties;
import jsbchart.panel.SBPanel;
import model3.Well;

class MapColumn
extends BlockColumn {
    final List<MapBlock> mapBlocks = new LinkedList<MapBlock>();
    private float[] shiftedYpos;

    MapColumn(MapBlock b) {
        this.mapBlocks.add(b);
    }

    void add(MapBlock b) {
        this.mapBlocks.add(b);
    }

    @Override
    float getWidth(ChartProperties cp) {
        return (float)this.mapBlocks.stream().mapToDouble(b -> b.getProp().getWidth()).max().orElse(0.0);
    }

    @Override
    float getTotalHeight(ChartProperties cp) {
        return (float)this.mapBlocks.stream().mapToDouble(b -> b.getProp().getHeight()).summaryStatistics().getSum() + (cp.plotBlockCaptions ? cp.blockCapHeight * (float)this.mapBlocks.size() : 0.0f) + cp.blankPanel * (float)(this.mapBlocks.size() - 1);
    }

    @Override
    List<ChartLayout.Position> getBlockPositions(ChartProperties cp) {
        LinkedList<ChartLayout.Position> positions = new LinkedList<ChartLayout.Position>();
        if (this.shiftedYpos != null) {
            for (int i = 0; i < this.shiftedYpos.length; ++i) {
                positions.add(new ChartLayout.Position(this.xpos, this.shiftedYpos[i] + (cp.plotBlockCaptions && cp.blockCapTop ? cp.blockCapHeight : 0.0f)));
            }
            return positions;
        }
        float y = this.ypos;
        for (MapBlock mb : this.mapBlocks) {
            if (cp.plotBlockCaptions && cp.blockCapTop) {
                y += cp.blockCapHeight;
            }
            positions.add(new ChartLayout.Position(this.xpos, y));
            y += mb.getProp().getHeight() + cp.blankPanel;
            if (!cp.plotBlockCaptions || cp.blockCapTop) continue;
            y += cp.blockCapHeight;
        }
        return positions;
    }

    void setBlockPositions(Float[] preferredYPositions, float maxBlockPos, ChartProperties cp) {
        int n = this.mapBlocks.size();
        this.shiftedYpos = new float[n];
        float[] symbolSizes = new float[n];
        for (int i = 0; i < n; ++i) {
            Float prefPos = preferredYPositions[i];
            if (prefPos == null) {
                prefPos = Float.valueOf(i == 0 ? this.ypos : this.shiftedYpos[i - 1] + symbolSizes[i - 1]);
            }
            float blockHeight = this.mapBlocks.get(i).getHeight();
            symbolSizes[i] = blockHeight + (cp.plotBlockCaptions ? cp.blockCapHeight : 5.0f);
            this.shiftedYpos[i] = prefPos.floatValue() - blockHeight / 2.0f;
        }
        this.repositionBlocksToAvoidOverlap(maxBlockPos, cp, symbolSizes, n);
    }

    private void repositionBlocksToAvoidOverlap(float maxBlockPos, ChartProperties cp, float[] symbolSizes, int n) {
        int i;
        float hPosition = this.ypos + (cp.plotBlockCaptions && cp.blockCapTop ? cp.blockCapHeight : 0.0f);
        float lPosition = maxBlockPos - symbolSizes[n - 1];
        record BlockInfo(int index, float yPos, float size) {
        }
        ArrayList<BlockInfo> blockInfos = new ArrayList<BlockInfo>();
        for (int i2 = 0; i2 < n; ++i2) {
            blockInfos.add(new BlockInfo(i2, this.shiftedYpos[i2], symbolSizes[i2]));
        }
        blockInfos.sort((o1, o2) -> Float.compare(o1.yPos, o2.yPos));
        float[] sortedYpos = new float[n];
        float[] sortedSizes = new float[n];
        for (i = 0; i < n; ++i) {
            sortedYpos[i] = ((BlockInfo)blockInfos.get((int)i)).yPos;
            sortedSizes[i] = ((BlockInfo)blockInfos.get((int)i)).size;
            if (i <= 0 || !((double)Math.abs(sortedYpos[i - 1] - sortedYpos[i]) < 1.0E-5)) continue;
            int n2 = i;
            sortedYpos[n2] = sortedYpos[n2] + 0.01f;
        }
        SBPanel.moveSamplePositions(n, sortedYpos, sortedSizes, hPosition, lPosition);
        for (i = 0; i < n; ++i) {
            this.shiftedYpos[((BlockInfo)blockInfos.get((int)i)).index] = sortedYpos[i];
        }
    }

    @Override
    Well getSingleWell() {
        return null;
    }

    @Override
    List<ChartBlockBase> getBlocks() {
        return new ArrayList<ChartBlockBase>(this.mapBlocks);
    }

    @Override
    boolean plotPinchouts() {
        return false;
    }
}

