/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.core.BlockTemplateChild;
import jsbchart.core.ChartProperties;
import jsbchart.core.TemplateDescr;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.util.LogoCache;
import model3.Well;
import org.apache.commons.lang3.StringUtils;
import util.RectUtils;
import util.SB;

public class PanelWellHeader {
    private static final Logger LOGGER = Logger.getLogger(PanelWellHeader.class.getName());
    private static final String WELL_INFO_SEPARATOR = ": ";
    private static final float WELL_INFO_VALUE_SEPARATION = 2.0f;
    private static final float HEADER_MARGIN = 2.0f;
    private static final float PADDING = 4.0f;
    public static final float HEADING_PADDING = 4.0f;
    private static final float WELL_INFO_LEFT_PADDING = 7.5f;
    private static final float TEMPLATE_NAME_BOTTOM_PADDING = 2.0f;
    public float height = 40.0f;
    public boolean wellCode = true;
    public boolean operator = true;
    public boolean location = true;
    public boolean decimalLocation = false;
    public boolean spud = true;
    public boolean border = true;
    public boolean logo = true;
    public boolean comments = false;
    public boolean depthInterval = true;
    public boolean td = false;
    public boolean scale = true;
    public boolean centreName = false;
    public boolean templName = false;
    public boolean templDescr = false;
    public boolean templDate = false;
    public boolean clientName = false;
    public boolean wellListName = false;
    public WellNameDisplay wellNameDisplay = WellNameDisplay.NORMAL;
    public String title = "";
    public String author = "";
    public String enclosure = "";
    public Orientation orientation = Orientation.TOP;
    public HeaderStyle style = HeaderStyle.WELL;
    private static final DateFormat chartDateFormat = SimpleDateFormat.getDateInstance(2);

    public PanelWellHeader() {
    }

    public PanelWellHeader(String prop) {
        if (prop == null || prop.isEmpty()) {
            return;
        }
        String[] s = prop.split("\\|");
        for (int i = 0; i < s.length; ++i) {
            try {
                this.setPropertyByIndexAndString(i, s[i]);
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception \"{0}\" while setting property {1} with value \"{2}\".", new Object[]{e.getMessage(), i, s[i]});
            }
        }
    }

    private void setPropertyByIndexAndString(int i, String s) {
        switch (i) {
            case 0: {
                this.height = Float.parseFloat(s);
                break;
            }
            case 1: {
                this.wellCode = Integer.parseInt(s) == 1;
                break;
            }
            case 2: {
                this.operator = Integer.parseInt(s) == 1;
                break;
            }
            case 3: {
                this.location = Integer.parseInt(s) == 1;
                break;
            }
            case 4: {
                this.decimalLocation = Integer.parseInt(s) == 1;
                break;
            }
            case 5: {
                this.spud = Integer.parseInt(s) == 1;
                break;
            }
            case 6: {
                this.border = Integer.parseInt(s) == 1;
                break;
            }
            case 7: {
                this.logo = Integer.parseInt(s) == 1;
                break;
            }
            case 8: {
                this.comments = Integer.parseInt(s) == 1;
                break;
            }
            case 9: {
                this.scale = Integer.parseInt(s) == 1;
                break;
            }
            case 10: {
                this.centreName = Integer.parseInt(s) == 1;
                break;
            }
            case 11: {
                this.orientation = Orientation.valueOf(s);
                break;
            }
            case 12: {
                this.title = s;
                break;
            }
            case 13: {
                this.author = s;
                break;
            }
            case 14: {
                this.enclosure = s;
                break;
            }
            case 15: {
                this.templName = Integer.parseInt(s) == 1;
                break;
            }
            case 16: {
                this.templDescr = Integer.parseInt(s) == 1;
                break;
            }
            case 17: {
                this.style = HeaderStyle.valueOf(s);
                break;
            }
            case 18: {
                this.templDate = Integer.parseInt(s) == 1;
                break;
            }
            case 19: {
                this.depthInterval = Integer.parseInt(s) == 1;
                break;
            }
            case 20: {
                this.clientName = Integer.parseInt(s) == 1;
                break;
            }
            case 21: {
                this.wellNameDisplay = WellNameDisplay.valueOf(s);
                break;
            }
            case 22: {
                this.td = Integer.parseInt(s) == 1;
                break;
            }
            case 23: {
                this.wellListName = Integer.parseInt(s) == 1;
            }
        }
    }

    float draw(SBGraphics g, float x, float y, float width, ChartProperties cp, Well well, String scaleString, TemplateDescr templ, String depthIntervalRange, String tdStr, String wellListName) {
        float wellInfoLineHeight;
        float templateLineHeight;
        float requiredHeight;
        Object titleText;
        if (width < 1.0f) {
            return y + this.height;
        }
        float titleSize = cp.getFontSizeHeader() * 3.0f;
        g.setColor(cp.foreground);
        float imgwidth = this.drawLogo(titleSize, width, g, x, y);
        if (this.style == HeaderStyle.WELL && well != null) {
            titleText = this.wellNameDisplay == WellNameDisplay.ALTERNATIVE && StringUtils.isNotBlank((CharSequence)well.getHeader().getWellAltName()) ? well.getHeader().getWellAltName() : well.getWellName();
            if (this.wellNameDisplay == WellNameDisplay.CONCAT && StringUtils.isNotBlank((CharSequence)well.getHeader().getWellAltName())) {
                titleText = (String)titleText + "  " + well.getHeader().getWellAltName();
            }
        } else {
            titleText = this.title;
        }
        g.setFont(cp.font, 1, titleSize);
        if (this.centreName && (double)width / 2.0 - (double)imgwidth - 8.0 > 0.0) {
            while ((double)g.stringWidth((String)titleText) / 2.0 > (double)width / 2.0 - (double)imgwidth - 8.0) {
                titleSize = (float)((double)titleSize * 0.75);
                g.setFont(cp.font, 1, titleSize);
            }
        }
        Rectangle2D.Float headerBounds = new Rectangle2D.Float(x + 2.0f, y + 2.0f, width - 4.0f, this.height - 4.0f);
        Rectangle2D.Float titleDrawnArea = this.drawTitle(cp, titleSize, g, (String)titleText, headerBounds);
        Rectangle2D.Float templateNameAvailableArea = RectUtils.copyRect((Rectangle2D.Float)headerBounds);
        if (!this.centreName) {
            RectUtils.shrinkRectFromTop((Rectangle2D.Float)templateNameAvailableArea, (float)(titleDrawnArea.height + 4.0f));
        }
        if (templateNameAvailableArea.height <= (requiredHeight = (templateLineHeight = g.calculateLineHeight(new SBFont(cp.font, 1, cp.getFontSizeHeader()))) + 2.0f + (wellInfoLineHeight = g.calculateLineHeight(new SBFont(cp.font, 0, cp.getFontSizePanel()))))) {
            templateNameAvailableArea = RectUtils.copyRect((Rectangle2D.Float)headerBounds);
            RectUtils.shrinkRectFromLeft((Rectangle2D.Float)templateNameAvailableArea, (float)(titleDrawnArea.width + 4.0f));
            RectUtils.shrinkRectFromTop((Rectangle2D.Float)templateNameAvailableArea, (float)4.0f);
        }
        Rectangle2D.Float templateNameDrawnArea = this.drawTemplateName(templateNameAvailableArea, templ, cp, g);
        Rectangle2D.Float chartDetailsAvailableArea = RectUtils.copyRect((Rectangle2D.Float)templateNameAvailableArea);
        RectUtils.shrinkRectFromTop((Rectangle2D.Float)chartDetailsAvailableArea, (float)(templateNameDrawnArea.height + 2.0f));
        Rectangle2D.Float chartDetailsDrawnArea = this.drawChartDetails(cp, g, chartDetailsAvailableArea, scaleString, templ, wellListName);
        Rectangle2D.Float wellItemsAvailableArea = RectUtils.copyRect((Rectangle2D.Float)chartDetailsAvailableArea);
        RectUtils.shrinkRectFromLeft((Rectangle2D.Float)wellItemsAvailableArea, (float)(chartDetailsDrawnArea.width + 7.5f));
        this.drawWellInfo(g, well, wellItemsAvailableArea, cp, depthIntervalRange, tdStr);
        if (this.border) {
            g.setStroke(0.4f);
            g.drawRect(x, y, width, this.height);
        }
        return y + this.height;
    }

    private float drawLogo(float titleSize, float width, SBGraphics g, float x, float y) {
        BufferedImage image;
        float imgwidth = 0.0f;
        if (this.logo && (image = LogoCache.getLogo()) != null) {
            float availHeight = this.height - 8.0f;
            float maxHeight = titleSize * 2.0f;
            if (availHeight > maxHeight) {
                availHeight = maxHeight;
            }
            float imgheight = image.getHeight();
            imgwidth = image.getWidth();
            if (imgheight > availHeight) {
                imgwidth /= imgheight / availHeight;
                imgheight = availHeight;
            }
            if (width / 4.0f > 4.0f) {
                if (imgwidth > width / 4.0f) {
                    float newImgWidth = width / 4.0f - 4.0f;
                    imgheight *= newImgWidth / imgwidth;
                    imgwidth = newImgWidth;
                }
                g.drawImage(image, x + width - imgwidth - 4.0f, y + 4.0f, imgwidth, imgheight);
            } else {
                image = null;
                imgwidth = 0.0f;
            }
        }
        return imgwidth;
    }

    private Rectangle2D.Float drawTitle(ChartProperties cp, float titleSize, SBGraphics g, String titleText, Rectangle2D.Float headerBounds) {
        Rectangle2D.Float titleDrawnArea;
        TextLayoutPreferences titleLayout = new TextLayoutPreferences().truncateText().setFont(new SBFont(cp.font, 1, titleSize));
        if (this.centreName) {
            titleLayout.setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Middle);
            titleDrawnArea = g.drawStringWithinBox(titleText, headerBounds, titleLayout);
        } else {
            titleLayout.setHorizontalAlignment(HorizontalAlignment.Left).setVerticalAlignment(VerticalAlignment.Top);
            titleDrawnArea = g.drawStringWithinBox(titleText, headerBounds, titleLayout);
        }
        return titleDrawnArea;
    }

    private Rectangle2D.Float drawTemplateName(Rectangle2D.Float availableArea, TemplateDescr templ, ChartProperties cp, SBGraphics g) {
        TextLayoutPreferences templateNameLayout = new TextLayoutPreferences().setFont(new SBFont(cp.font, 1, cp.getFontSizeHeader())).wrapText().truncateText();
        Rectangle2D.Float templateNameDrawnArea = new Rectangle2D.Float(availableArea.x, availableArea.y, 0.0f, 0.0f);
        if (this.templName && templ != null) {
            String templName;
            if (templ instanceof BlockTemplateChild) {
                try {
                    templName = ((BlockTemplateChild)templ).getParentName();
                }
                catch (SQLException e) {
                    templName = e.getMessage();
                    e.printStackTrace();
                }
            } else {
                templName = templ.getName();
            }
            templateNameDrawnArea = g.drawStringWithinBox(templName, availableArea, templateNameLayout);
        }
        return templateNameDrawnArea;
    }

    private Rectangle2D.Float drawChartDetails(ChartProperties cp, SBGraphics g, Rectangle2D.Float availableArea, String scaleString, TemplateDescr templ, String wellListName) {
        TextLayoutPreferences detailsLayout = new TextLayoutPreferences().setFont(new SBFont(cp.font, 0, cp.getFontSizePanel())).hideOnOverflow();
        float lh = g.calculateLineHeight(detailsLayout);
        Rectangle2D.Float nextDetailBox = new Rectangle2D.Float(availableArea.x, availableArea.y, availableArea.width, availableArea.height);
        float maxWidth = 0.0f;
        Rectangle2D.Float chartDetailsDrawnArea = new Rectangle2D.Float(availableArea.x, availableArea.y, 0.0f, 0.0f);
        for (String d : this.getChartDetails(scaleString, templ, wellListName)) {
            Rectangle2D.Float r = g.drawStringWithinBox(d, nextDetailBox, detailsLayout);
            chartDetailsDrawnArea = RectUtils.calculateContainingRectanlge((Rectangle2D.Float)chartDetailsDrawnArea, (Rectangle2D.Float)r);
            if (r.width > maxWidth) {
                maxWidth = r.width;
            }
            RectUtils.shrinkRectFromTop((Rectangle2D.Float)nextDetailBox, (float)r.height);
            if (nextDetailBox.height < lh) {
                nextDetailBox = RectUtils.calculateRectShrunkFromLeft((Rectangle2D.Float)availableArea, (float)(chartDetailsDrawnArea.width + 4.0f));
                maxWidth = 0.0f;
            }
            if (!(nextDetailBox.width <= 0.0f)) continue;
            break;
        }
        detailsLayout.setFont(new SBFont(cp.font, 0, cp.getFontSizePanel()));
        if (this.templDescr && templ != null && templ.getComments() != null && !templ.getComments().isEmpty()) {
            boolean fitsInExistingColumn = false;
            String[] wrappedComments = null;
            if (maxWidth > 0.0f) {
                if (maxWidth < 100.0f) {
                    maxWidth = 100.0f;
                }
                if (g.measureText(wrappedComments = g.wrapHorizontalText(templ.getComments(), maxWidth, detailsLayout), detailsLayout).getHeight() < nextDetailBox.height) {
                    fitsInExistingColumn = true;
                } else {
                    nextDetailBox = RectUtils.calculateRectShrunkFromLeft((Rectangle2D.Float)availableArea, (float)(chartDetailsDrawnArea.width + 4.0f));
                }
            }
            if (!fitsInExistingColumn) {
                wrappedComments = g.wrapHorizontalText(templ.getComments(), 100.0f, detailsLayout);
            }
            TextSettings settings = detailsLayout.buildSettings();
            DimensionF dims = new DimensionF(nextDetailBox.width, nextDetailBox.height);
            Rectangle2D.Float r = !g.getTextMeasurer().calculateTextDimensions(wrappedComments, settings).fitsInside(dims) ? new Rectangle2D.Float(nextDetailBox.x, nextDetailBox.y, 0.0f, 0.0f) : g.renderLinesWithinBox(wrappedComments, nextDetailBox, settings);
            chartDetailsDrawnArea = RectUtils.calculateContainingRectanlge((Rectangle2D.Float)chartDetailsDrawnArea, (Rectangle2D.Float)r);
        }
        return chartDetailsDrawnArea;
    }

    private void drawWellInfo(SBGraphics g, Well well, Rectangle2D.Float wellItemsAvailableArea, ChartProperties cp, String depthIntervalRange, String tdStr) {
        TextLayoutPreferences wellInfoLayout = new TextLayoutPreferences().setFont(new SBFont(cp.font, 0, cp.getFontSizePanel())).hideOnOverflow();
        if (this.style == HeaderStyle.WELL && well != null) {
            Rectangle2D.Float nextItemBox = new Rectangle2D.Float(wellItemsAvailableArea.x, wellItemsAvailableArea.y, wellItemsAvailableArea.width, wellItemsAvailableArea.height);
            Rectangle2D.Float wellItemsDrawnArea = new Rectangle2D.Float(wellItemsAvailableArea.x, wellItemsAvailableArea.y, 0.0f, 0.0f);
            List<TextItem> items = this.buildWellItems(well, cp, depthIntervalRange, tdStr);
            LinkedList<TextItem> column = new LinkedList<TextItem>();
            float lineHeight = g.calculateLineHeight(wellInfoLayout);
            int numItemsInColumn = (int)Math.floor(wellItemsAvailableArea.height / lineHeight);
            while (!items.isEmpty() && numItemsInColumn > 0) {
                for (int i = 0; i < numItemsInColumn; ++i) {
                    column.add(items.remove(0));
                    if (items.isEmpty()) break;
                }
                float maxTitleWidth = 0.0f;
                for (TextItem textItem : column) {
                    float w = g.measureText(textItem.title + WELL_INFO_SEPARATOR, wellInfoLayout).getWidth();
                    if (!(w > maxTitleWidth)) continue;
                    maxTitleWidth = w;
                }
                for (TextItem textItem : column) {
                    float vWidth = g.measureText(textItem.value, wellInfoLayout).getWidth();
                    if (maxTitleWidth + 2.0f + vWidth > nextItemBox.width) continue;
                    Rectangle2D.Float r = g.drawStringWithinBox(textItem.title + WELL_INFO_SEPARATOR, nextItemBox, wellInfoLayout);
                    wellItemsDrawnArea = RectUtils.calculateContainingRectanlge((Rectangle2D.Float)r, (Rectangle2D.Float)wellItemsDrawnArea);
                    RectUtils.shrinkRectFromLeft((Rectangle2D.Float)nextItemBox, (float)(maxTitleWidth + 2.0f));
                    r = g.drawStringWithinBox(textItem.value, nextItemBox, wellInfoLayout);
                    wellItemsDrawnArea = RectUtils.calculateContainingRectanlge((Rectangle2D.Float)r, (Rectangle2D.Float)wellItemsDrawnArea);
                    RectUtils.shrinkRectFromLeft((Rectangle2D.Float)nextItemBox, (float)(-maxTitleWidth - 2.0f));
                    RectUtils.shrinkRectFromTop((Rectangle2D.Float)nextItemBox, (float)lineHeight);
                }
                nextItemBox = RectUtils.calculateRectShrunkFromLeft((Rectangle2D.Float)wellItemsAvailableArea, (float)(wellItemsDrawnArea.width + 4.0f));
                column.clear();
            }
            if (this.comments) {
                Rectangle2D.Float commentBox = RectUtils.calculateRectShrunkFromLeft((Rectangle2D.Float)wellItemsAvailableArea, (float)(wellItemsDrawnArea.width + 4.0f));
                String descrip = well.getHeader().getDescription();
                if (descrip != null && !descrip.isEmpty()) {
                    wellInfoLayout.wrapText();
                    g.drawStringWithinBox(descrip, commentBox, wellInfoLayout);
                }
            }
        }
    }

    private List<TextItem> buildWellItems(Well well, ChartProperties cp, String depthIntervalRange, String tdStr) {
        ArrayList<TextItem> items = new ArrayList<TextItem>();
        if (this.wellNameDisplay == WellNameDisplay.BOTH && StringUtils.isNotBlank((CharSequence)well.getHeader().getWellAltName())) {
            items.add(new TextItem("Alternative Name", well.getHeader().getWellAltName()));
        }
        if (this.wellCode) {
            items.add(new TextItem("Well Code", well.getWellCode()));
        }
        if (this.operator && !well.getHeader().getOperator().isEmpty()) {
            items.add(new TextItem("Operator", well.getHeader().getOperator()));
        }
        if (this.spud && well.getHeader().getSpudDate() != null) {
            items.add(new TextItem("Spudded", well.getHeader().getSpudDate().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM))));
        }
        if (this.spud && well.getHeader().getCompletionDate() != null) {
            items.add(new TextItem("Completed", well.getHeader().getCompletionDate().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM))));
        }
        if (this.location && well.getHeader().getLat_dec() != null && well.getHeader().getLong_dec() != null) {
            Object value = well.getHeader().getLatString(this.decimalLocation);
            value = (String)value + " " + well.getHeader().getLongString(this.decimalLocation);
            Object locString = "Location";
            if (well.getHeader().getGeoDatum() != null && !well.getHeader().getGeoDatum().isEmpty()) {
                locString = (String)locString + " (" + well.getHeader().getGeoDatum() + ")";
            }
            items.add(new TextItem((String)locString, (String)value));
        }
        if (cp.chartGenDate != null) {
            items.add(new TextItem("Chart date", DateFormat.getDateInstance(2).format(cp.chartGenDate)));
        }
        if (this.depthInterval) {
            items.add(new TextItem("Interval", depthIntervalRange));
        }
        if (this.td && StringUtils.isNotBlank((CharSequence)tdStr)) {
            items.add(new TextItem("TD", tdStr));
        }
        String client = well.getHeader().getClient();
        if (this.clientName && !StringUtils.isBlank((CharSequence)client)) {
            items.add(new TextItem("Client", client));
        }
        return items;
    }

    private List<String> getChartDetails(String scaleString, TemplateDescr templ, String wellListString) {
        ArrayList<String> details = new ArrayList<String>();
        if (this.wellListName && wellListString != null && !wellListString.isBlank()) {
            details.add("Project: " + wellListString);
        }
        if (!this.author.isEmpty()) {
            details.add(this.author);
        }
        if (this.templDate) {
            details.add("Chart date: " + chartDateFormat.format(Calendar.getInstance().getTime()));
        }
        if (this.scale && !scaleString.isEmpty()) {
            details.add("Scale: " + scaleString);
        }
        if (!this.enclosure.isEmpty()) {
            details.add(this.enclosure);
        }
        return details;
    }

    public String toString() {
        return "Well Header";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PanelWellHeader other = (PanelWellHeader)obj;
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (this.scale != other.scale) {
            return false;
        }
        if (this.centreName != other.centreName) {
            return false;
        }
        if (this.orientation != other.orientation) {
            return false;
        }
        if (!SB.equal((Object)this.author, (Object)other.author)) {
            return false;
        }
        if (!SB.equal((Object)this.enclosure, (Object)other.enclosure)) {
            return false;
        }
        if (this.templName != other.templName) {
            return false;
        }
        if (this.wellListName != other.wellListName) {
            return false;
        }
        if (this.templDescr != other.templDescr) {
            return false;
        }
        if (this.templDate != other.templDate) {
            return false;
        }
        if (this.style != other.style) {
            return false;
        }
        if (this.style == HeaderStyle.WELL) {
            if (this.wellCode != other.wellCode) {
                return false;
            }
            if (this.operator != other.operator) {
                return false;
            }
            if (this.location != other.location) {
                return false;
            }
            if (this.decimalLocation != other.decimalLocation) {
                return false;
            }
            if (this.spud != other.spud) {
                return false;
            }
            if (this.border != other.border) {
                return false;
            }
            if (this.logo != other.logo) {
                return false;
            }
            if (this.comments != other.comments) {
                return false;
            }
            if (this.depthInterval != other.depthInterval) {
                return false;
            }
            if (this.td != other.td) {
                return false;
            }
            if (this.clientName != other.clientName) {
                return false;
            }
        } else if (this.style == HeaderStyle.FREE && !SB.equal((Object)this.title, (Object)other.title)) {
            return false;
        }
        if (this.wellNameDisplay != other.wellNameDisplay) {
            return false;
        }
        return this.orientation == other.orientation;
    }

    String getProperties() {
        return this.getProperties(null);
    }

    String getProperties(PanelWellHeader defaultForExclusions) {
        String[] props = new String[24];
        props[0] = "" + this.height;
        props[1] = "" + (this.wellCode ? 1 : 0);
        props[2] = "" + (this.operator ? 1 : 0);
        props[3] = "" + (this.location ? 1 : 0);
        props[4] = "" + (this.decimalLocation ? 1 : 0);
        props[5] = "" + (this.spud ? 1 : 0);
        props[6] = "" + (this.border ? 1 : 0);
        props[7] = "" + (this.logo ? 1 : 0);
        props[8] = "" + (this.comments ? 1 : 0);
        props[9] = "" + (this.scale ? 1 : 0);
        props[10] = "" + (this.centreName ? 1 : 0);
        props[11] = this.orientation.name();
        props[12] = defaultForExclusions == null ? (this.title != null ? this.title : "") : defaultForExclusions.title;
        String string = props[13] = this.author != null ? this.author : "";
        props[14] = defaultForExclusions == null ? (this.enclosure != null ? this.enclosure : "") : defaultForExclusions.enclosure;
        props[15] = "" + (this.templName ? 1 : 0);
        props[16] = "" + (this.templDescr ? 1 : 0);
        props[17] = this.style.name();
        props[18] = "" + (this.templDate ? 1 : 0);
        props[19] = "" + (this.depthInterval ? 1 : 0);
        props[20] = "" + (this.clientName ? 1 : 0);
        props[21] = this.wellNameDisplay.name();
        props[22] = "" + (this.td ? 1 : 0);
        props[23] = "" + (this.wellListName ? 1 : 0);
        Object string2 = new String();
        for (String prop : props) {
            string2 = (String)string2 + prop + "|";
        }
        return string2;
    }

    public static enum WellNameDisplay {
        NORMAL,
        ALTERNATIVE,
        BOTH,
        CONCAT;

    }

    public static enum Orientation {
        TOP,
        BOTTOM;

    }

    public static enum HeaderStyle {
        WELL,
        FREE;

    }

    private static class TextItem {
        final String title;
        final String value;

        TextItem(String title, String value) {
            this.title = title;
            this.value = value;
        }
    }
}

