/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.sql.SQLException;
import java.util.List;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateChild;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.Chart;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.SBPanel;
import model3.Audit;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;

public class TemplateFactory {
    private TemplateFactory() {
    }

    public static BlockTemplate newBlockTemplate(ChartManager manager, BlockType type, String descr, String comments, int projID) {
        return new BlockTemplateParent(manager, 0, type, descr, comments, projID, null, 0);
    }

    public static BlockTemplate newBlockTemplateFromResults(ChartManager manager, int ID, BlockType type, String descr, String comments, int projID, Audit audit, int acm) {
        return new BlockTemplateParent(manager, ID, type, descr, comments, projID, audit, acm);
    }

    public static BlockTemplate newBlockTemplateFromResults(ChartManager manager, int ID, BlockType type, String descr, String comments, int projID, Audit audit, int acm, int parentID, int wellID) {
        if (wellID > 0 && parentID > 0) {
            return new BlockTemplateChild(manager, ID, type, descr, comments, projID, audit, acm, parentID, wellID);
        }
        return TemplateFactory.newBlockTemplateFromResults(manager, ID, type, descr, comments, projID, audit, acm);
    }

    static BlockTemplate newBlockTemplateForWorkspace(ChartManager wsCM, BlockTemplate dbTemplateToCopy) {
        return new BlockTemplateParent(wsCM, dbTemplateToCopy.getID(), dbTemplateToCopy.getType(), dbTemplateToCopy.getName(), dbTemplateToCopy.getComments(), 0, dbTemplateToCopy.getAuditCopy(), 0);
    }

    static BlockTemplate newBlockTemplateForDatabase(ChartManager dbCM, ChartManager wsCM, BlockTemplate wsTemplateToCopy, int dbProjID) throws SQLException, SBException {
        Object dbTemplateName = wsTemplateToCopy.getName();
        int i = 1;
        while (!dbCM.checkNewTemplateName((String)dbTemplateName, wsTemplateToCopy.getType(), dbProjID)) {
            dbTemplateName = wsTemplateToCopy.getName() + " (" + i++ + ")";
        }
        return new BlockTemplateParent(dbCM, 0, wsTemplateToCopy.getType(), (String)dbTemplateName, wsTemplateToCopy.getComments(), dbProjID, new Audit(dbCM.sbdb, wsCM.sbdb, wsTemplateToCopy.getAuditCopy()), 0);
    }

    public static ChartTemplateBase createChildTemplate(Chart chart, ChartManager chartManager, int wellID) throws SQLException, SBException, SBPermissionException {
        ChartBlockBase block = chart.getBlockSingle();
        if (!(block instanceof ChartBlock)) {
            throw new IllegalStateException("Cannot create child template for block type " + String.valueOf(block.getClass()));
        }
        return TemplateFactory.createChildTemplate((ChartBlock)block, chartManager, wellID);
    }

    public static ChartTemplateBase createChildTemplate(ChartBlock block, ChartManager chartManager, int wellID) throws SQLException, SBException, SBPermissionException {
        BlockTemplate template = block.getTemplate();
        if (template.getType() != BlockType.WELL) {
            throw new IllegalStateException("Cannot create child template for block type " + template.getTypeString().toLowerCase());
        }
        if (template.getParentID() != null) {
            throw new IllegalStateException("Cannot create child of child template");
        }
        if (block.getPanels().size() != template.getPanels().size()) {
            throw new IllegalStateException("Template: id=" + template.getID() + " has modified panel list");
        }
        BlockTemplateParent parent = (BlockTemplateParent)template;
        if (parent.getChild(wellID) != null) {
            throw new IllegalStateException("Child template already exists for well");
        }
        BlockTemplateChild child = new BlockTemplateChild(chartManager, 0, BlockType.WELL, parent.getName() + "(id:" + wellID + ")", null, parent.getProjID(), null, 0, parent.getID(), wellID);
        for (PanelOcc parentPo : parent.getPanels()) {
            child.addPanel(new PanelOcc(parentPo.panelID, parentPo.getInterpID(), parentPo.getCaption(), parentPo.getSubCaption(), parentPo.getCapOrient(), parentPo.getSchID()));
        }
        List<SBPanel> panels = block.getPanels();
        for (int i = 0; i < panels.size(); ++i) {
            SBPanel panel = panels.get(i);
            PanelTemplate newChildPanelTemplate = null;
            if (!panel.getTemplate().getProperties().equals(panel.getProperties())) {
                String descr = "Local to " + child.getType().getShortDescr() + " block template [" + child.getName() + "]";
                newChildPanelTemplate = chartManager.addPanelTemplate(panel.getPanelType(), descr, null, child.getProjID(), panel.getProperties(), null, false);
            }
            if (newChildPanelTemplate == null && panel.getPanelOcc().equals((Object)child.getPanels().get(i))) continue;
            PanelOcc po = panel.getPanelOcc();
            PanelOcc newChildPanelOcc = new PanelOcc(newChildPanelTemplate != null ? newChildPanelTemplate.getID() : panel.getTemplateID().intValue(), po.getInterpID(), po.getCaption(), po.getSubCaption(), po.getCapOrient(), po.getSchID());
            child.replacePanelAt(i, newChildPanelOcc);
        }
        try {
            child.store(chartManager.sbdb);
        }
        catch (InvalidFieldException ife) {
            throw new IllegalStateException(ife);
        }
        parent.addChild(child);
        chartManager.fireTemplateAdded(child);
        return child;
    }
}

