/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.util.Observable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class TemplateNotifierService {
    private static final String THREAD_NAME = "Chart template notifier thread";
    private static ExecutorService EXECUTOR;

    public static void submitNotify(final Observable notifier, final Object arg) {
        if (!notifier.hasChanged()) {
            return;
        }
        if (EXECUTOR == null) {
            TemplateNotifierService.initExecutorService();
        }
        EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(TemplateNotifierService.THREAD_NAME);
                notifier.notifyObservers(arg);
            }
        });
    }

    private static void initExecutorService() {
        NotifierThreadFactory factory = new NotifierThreadFactory();
        EXECUTOR = Executors.newFixedThreadPool(1, factory);
    }

    private static class NotifierThreadFactory
    implements ThreadFactory {
        private NotifierThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(TemplateNotifierService.THREAD_NAME);
            return t;
        }
    }
}

