/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import com.stratadata.model3.scheme.Boundary;
import java.awt.Color;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.text.HorizontalAlignment;
import util.ColourUtils;
import util.SB;
import util.SBEnumUtils;

public class CorrLineStyle {
    private Color colour = Color.BLACK;
    private float weight = 0.2f;
    private Boundary bnd;
    private boolean label = true;
    private boolean labelAbr = false;
    private LabelPosition position = null;
    private ChartProperties.FontSize fontSize = ChartProperties.FontSize.SMALL;
    private HorizontalAlignment alignment = HorizontalAlignment.Centre;
    private boolean showLabelType = true;

    CorrLineStyle() {
    }

    public CorrLineStyle(Color colour, float weight, Boundary bnd, boolean label, LabelPosition position, boolean abr, ChartProperties.FontSize fontSize, HorizontalAlignment alignment, boolean showLabelType) {
        this.colour = colour;
        this.weight = weight;
        this.bnd = bnd;
        this.label = label;
        this.position = position;
        this.labelAbr = abr;
        this.fontSize = fontSize;
        this.alignment = alignment;
        this.showLabelType = showLabelType;
    }

    public CorrLineStyle(String props) {
        if (props != null) {
            String[] s = props.split("\\|");
            block11: for (int i = 0; i < s.length; ++i) {
                if (i != 2 && s[i].isEmpty()) continue;
                switch (i) {
                    case 0: {
                        this.bnd = Boundary.valueOf((String)s[i]);
                        continue block11;
                    }
                    case 1: {
                        this.weight = Float.parseFloat(s[i]);
                        continue block11;
                    }
                    case 2: {
                        this.colour = s[i].isEmpty() ? null : ColourUtils.getColour((String)s[i]);
                        continue block11;
                    }
                    case 3: {
                        this.label = Integer.parseInt(s[i]) == 1;
                        continue block11;
                    }
                    case 4: {
                        this.position = !s[i].isEmpty() ? LabelPosition.valueOf(s[i]) : null;
                        continue block11;
                    }
                    case 5: {
                        this.labelAbr = Integer.parseInt(s[i]) == 1;
                        continue block11;
                    }
                    case 6: {
                        this.fontSize = ChartProperties.FontSize.valueOf(s[i]);
                        continue block11;
                    }
                    case 7: {
                        this.alignment = (HorizontalAlignment)SBEnumUtils.searchEnum(HorizontalAlignment.class, (String)s[i]);
                        continue block11;
                    }
                    case 8: {
                        this.showLabelType = Integer.parseInt(s[i]) == 1;
                    }
                }
            }
        }
    }

    public Color getColour() {
        return this.colour;
    }

    public Boundary getBnd() {
        return this.bnd;
    }

    public LabelPosition getLabelPosition() {
        return this.position;
    }

    public float getWeight() {
        if (this.weight <= 0.0f) {
            return 0.1f;
        }
        return this.weight;
    }

    public boolean getLabel() {
        return this.label;
    }

    public boolean getLabelAbr() {
        return this.labelAbr;
    }

    public ChartProperties.FontSize getFontSize() {
        return this.fontSize;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public boolean getShowLabelType() {
        return this.showLabelType;
    }

    public String getProperties() {
        String[] props = new String[]{this.bnd != null ? this.bnd.name() : "", "" + this.weight, this.colour != null ? ColourUtils.DBColourString((Color)this.colour, (boolean)true, (boolean)false) : "", "" + (this.label ? 1 : 0), this.position != null ? this.position.name() : "", "" + (this.labelAbr ? 1 : 0), this.fontSize.name(), this.alignment != null ? this.alignment.name().toUpperCase() : "", "" + (this.showLabelType ? 1 : 0)};
        Object string = "";
        for (String s : props) {
            string = (String)string + s + "|";
        }
        return string;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.colour != null ? this.colour.hashCode() : 0);
        hash = 67 * hash + Float.floatToIntBits(this.weight);
        hash = 67 * hash + (this.bnd != null ? this.bnd.hashCode() : 0);
        hash = 67 * hash + (this.label ? 1 : 0);
        hash = 67 * hash + (this.labelAbr ? 1 : 0);
        hash = 67 * hash + (this.position != null ? this.position.hashCode() : 0);
        hash = 67 * hash + this.fontSize.hashCode();
        hash = 67 * hash + (this.alignment != null ? this.alignment.hashCode() : 0);
        hash = 67 * hash + (this.showLabelType ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrLineStyle other = (CorrLineStyle)obj;
        if (!(this.colour == other.colour || this.colour != null && this.colour.equals(other.colour))) {
            return false;
        }
        if (Float.floatToIntBits(this.weight) != Float.floatToIntBits(other.weight)) {
            return false;
        }
        if (this.bnd != other.bnd) {
            return false;
        }
        if (this.label != other.label) {
            return false;
        }
        if (this.labelAbr != other.labelAbr) {
            return false;
        }
        if (this.fontSize != other.fontSize) {
            return false;
        }
        if (this.alignment != other.alignment) {
            return false;
        }
        if (this.showLabelType != other.showLabelType) {
            return false;
        }
        return this.position == other.position;
    }

    public boolean setColour(Color colour) {
        if (colour == null ^ this.colour == null || !colour.equals(this.colour)) {
            this.colour = colour;
            return true;
        }
        return false;
    }

    boolean setWeight(float weight) {
        if ((double)Math.abs(weight - this.weight) > 0.1) {
            this.weight = (float)SB.roundToSignificantFigures((double)weight, (int)2);
            return true;
        }
        return false;
    }

    boolean setBnd(Boundary bnd) {
        if (this.bnd != bnd) {
            this.bnd = bnd;
            return true;
        }
        return false;
    }

    boolean setLabel(boolean label) {
        if (this.label != label) {
            this.label = label;
            return true;
        }
        return false;
    }

    boolean setLabelAbr(boolean labelAbr) {
        if (this.labelAbr != labelAbr) {
            this.labelAbr = labelAbr;
            return true;
        }
        return false;
    }

    boolean setPosition(LabelPosition position) {
        if (this.position != position) {
            this.position = position;
            return true;
        }
        return false;
    }

    public boolean setFontSize(ChartProperties.FontSize fontSize) {
        if (this.fontSize != fontSize) {
            this.fontSize = fontSize;
            return true;
        }
        return false;
    }

    public boolean setAlignment(HorizontalAlignment alignment) {
        if (this.alignment != alignment) {
            this.alignment = alignment;
            return true;
        }
        return false;
    }

    public static Boundary getDefaultBnd(CorrelationType type) {
        switch (type) {
            case SURFACE: 
            case CHRONO: {
                return null;
            }
        }
        return Boundary.CONF;
    }

    public boolean setShowLabelType(boolean b) {
        if (this.showLabelType != b) {
            this.showLabelType = b;
            return true;
        }
        return false;
    }

    public static enum LabelPosition {
        ABOVE("Above"),
        BELOW("Below"),
        THROUGH("Through");

        private final String descr;

        private LabelPosition(String descr) {
            this.descr = descr;
        }

        public String toString() {
            return this.descr;
        }
    }
}

