/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import com.stratadata.model3.scheme.Confidence;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import jsbchart.correlation.CorrelationType;
import model3.SBdb;
import util.SB;

public class CorrTemplateOcc {
    final int corrschID;
    final int interpID;
    final boolean visible;
    final boolean useBlockInterp;
    final String style;
    final String datumString;
    final int maxUnconfidence;
    final boolean correlateRangedIntervals;

    public CorrTemplateOcc(int ID, int interpID, boolean visible, String style, String datumString, int maxUnconfidence, boolean correlateRangedIntervals, boolean useBlockInterp) {
        this.corrschID = ID;
        this.interpID = interpID;
        this.visible = visible;
        this.useBlockInterp = useBlockInterp;
        this.style = style;
        this.datumString = datumString;
        this.maxUnconfidence = maxUnconfidence;
        this.correlateRangedIntervals = correlateRangedIntervals;
    }

    public CorrTemplateOcc copy(Integer corrschID, Integer interpID) {
        return new CorrTemplateOcc(corrschID != null ? corrschID : this.corrschID, interpID != null ? interpID : this.interpID, this.visible, this.style, this.datumString, this.maxUnconfidence, this.correlateRangedIntervals, this.useBlockInterp);
    }

    public CorrTemplateOcc copy() {
        return this.copy(null, null);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.corrschID;
        hash = 79 * hash + this.interpID;
        hash = 79 * hash + (this.visible ? 1 : 0);
        hash = 79 * hash + (this.style != null ? this.style.hashCode() : 0);
        hash = 79 * hash + this.maxUnconfidence;
        hash = 79 * hash + (this.correlateRangedIntervals ? 1 : 0);
        hash = 79 * hash + (this.useBlockInterp ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrTemplateOcc other = (CorrTemplateOcc)obj;
        if (this.corrschID != other.corrschID) {
            return false;
        }
        if (this.interpID != other.interpID) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        if (this.useBlockInterp != other.useBlockInterp) {
            return false;
        }
        if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
            return false;
        }
        if (this.maxUnconfidence != other.maxUnconfidence) {
            return false;
        }
        if (this.correlateRangedIntervals != other.correlateRangedIntervals) {
            return false;
        }
        return !(this.datumString != null ? !this.datumString.equals(other.datumString) : other.datumString != null);
    }

    String getPropString() {
        return (this.visible ? (char)'Y' : 'N') + "|" + this.maxUnconfidence + "|" + String.valueOf(this.correlateRangedIntervals ? Character.valueOf('Y') : "N|" + (this.useBlockInterp ? (char)'Y' : 'N'));
    }

    public int getCorrschID() {
        return this.corrschID;
    }

    public int getInterpID() {
        return this.interpID;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getMaxUnconfidence() {
        return this.maxUnconfidence;
    }

    public String getDatumString() {
        return this.datumString;
    }

    public void writeXML(BufferedWriter out, SBdb ws, int indent, CorrelationType type) throws IOException {
        String ind = SB.getXMLIndent((int)indent);
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<Correlation CorrelationID=\"" + this.corrschID + "\">\n");
        try {
            out.write(ind2 + "<WellInterpretationID ID=\"" + this.interpID + "\" Description=\"" + ws.getInterp(this.interpID).getDescription() + "\"/>\n");
        }
        catch (SQLException sql) {
            throw new RuntimeException("Unexpected SQL error", sql);
        }
        out.write(ind2 + "<Properties>" + this.style + "</Properties>\n");
        out.write(ind2 + "<VisibleOnly>" + this.visible + "</VisibleOnly>\n");
        if (type == CorrelationType.EVENT) {
            out.write(ind2 + "<MinimumConfidence>" + Confidence.getMaxUnconfidence((int)this.maxUnconfidence).name() + "</MinimumConfidence>\n");
        }
        if (this.datumString != null && !this.datumString.isEmpty()) {
            out.write(ind2 + "<Datum>" + this.datumString + "</Datum>\n");
        }
        out.write(ind + "</Correlation>\n");
    }

    public String getDbInsertString(SBdb sbdb, int chartID) {
        return "INSERT INTO " + sbdb.DBTableName("CHTCORROCC") + " (chart_id,corrsch_id,interp_id,prop,style,datum) VALUES (" + chartID + "," + this.getCorrschID() + "," + this.getInterpID() + "," + SB.DBString((String)this.getPropString()) + "," + SB.DBString((String)this.style) + "," + (this.datumString != null ? SB.DBString((String)this.datumString) : "NULL") + ")";
    }
}

