/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.correlation.CorrelationType;
import model3.SBdb;

public class CorrelationTemplates {
    private final HashMap<Integer, CorrelationTemplate> corrTemplates;
    private final EnumMap<CorrelationType, List<CorrelationTemplate>> corrByType;
    private final SBdb sbdb;

    public CorrelationTemplates(SBdb sbdb) {
        this.sbdb = sbdb;
        this.corrTemplates = new HashMap();
        this.corrByType = new EnumMap(CorrelationType.class);
        for (CorrelationType type : CorrelationType.values()) {
            this.corrByType.put(type, null);
        }
    }

    public CorrelationTemplate get(int id) {
        return this.corrTemplates.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCorrTemplate(CorrelationTemplate templ) {
        HashMap<Integer, CorrelationTemplate> hashMap = this.corrTemplates;
        synchronized (hashMap) {
            if (this.corrTemplates.put(templ.getID(), templ) != null) {
                throw new IllegalStateException("Corrupt correlation scheme mapping");
            }
        }
        if (this.corrByType.get(templ.getType()) != null) {
            this.corrByType.get(templ.getType()).add(templ);
            Collections.sort(this.corrByType.get(templ.getType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCorrTemplates(CorrelationType type) throws SQLException {
        List<CorrelationTemplate> list = CorrelationTemplate.load(this.sbdb, type);
        ListIterator<CorrelationTemplate> it = list.listIterator();
        HashMap<Integer, CorrelationTemplate> hashMap = this.corrTemplates;
        synchronized (hashMap) {
            while (it.hasNext()) {
                CorrelationTemplate t = it.next();
                if (this.corrTemplates.get(t.getID()) != null) {
                    it.set(this.corrTemplates.get(t.getID()));
                    continue;
                }
                this.putCorrTemplate(t);
            }
        }
        this.corrByType.put(type, list);
    }
}

