/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import model3.SBdb;
import model3.Surface;
import util.SB;

public class SurfaceLine
extends CorrelationLine {
    private final Surface surface;

    public SurfaceLine(Surface surface, String props) {
        super(props, CorrelationType.SURFACE);
        this.surface = surface;
    }

    public SurfaceLine(Surface surface, CorrLineStyle style, Integer interpID) {
        super(CorrelationType.SURFACE, style, interpID);
        this.surface = surface;
    }

    static SurfaceLine createImplementedCopy(SurfaceLine rhs, CorrLineStyle defaultStyle, int interpID) {
        if (rhs.getStyle() != null) {
            defaultStyle = new CorrLineStyle(rhs.getStyle().getProperties());
        }
        SurfaceLine l = new SurfaceLine(rhs.surface, defaultStyle, (Integer)interpID);
        return l;
    }

    @Override
    void store(int corrID, SBdb sbdb, Statement stmt) throws SQLException {
        String sql = "INSERT INTO " + sbdb.DBTableName("CHTLN_SURFACE") + " (corrsch_id,surface_id,style) VALUES (" + corrID + "," + this.surface.getSurfaceID() + "," + (this.getStyle() != null ? SB.DBString((String)this.getStyle().getProperties()) : "NULL") + ")";
        stmt.executeUpdate(sbdb.modQuery(sql));
    }

    @Override
    String getDatumString() {
        return "" + this.surface.getSurfaceID();
    }

    @Override
    boolean updateObjectType(Object newType) {
        return false;
    }

    @Override
    CorrelationLine copy() {
        return new SurfaceLine(this.surface, this.getStyle() != null ? new CorrLineStyle(this.getStyle().getProperties()) : null, null);
    }

    @Override
    CorrelationLine copyLink() {
        return new SurfaceLine(this.surface.getLink(), this.getStyle() != null ? new CorrLineStyle(this.getStyle().getProperties()) : null, null);
    }

    @Override
    public Object getObject() {
        return this.surface;
    }

    @Override
    CorrLineStyle.LabelPosition getDefaultLabelPosition() {
        return CorrLineStyle.LabelPosition.THROUGH;
    }

    public String toString() {
        Object s = this.surface.toString();
        if (Surface.SurfaceType.parseType((String)s, null) == null) {
            s = (String)s + " " + this.surface.getTypeString();
        }
        return s;
    }

    @Override
    public boolean canEqual(Object o) {
        return o instanceof SurfaceLine;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SurfaceLine)) {
            return false;
        }
        SurfaceLine rhs = (SurfaceLine)o;
        if (!this.canEqual(rhs)) {
            return false;
        }
        if (!this.surface.equals(rhs.surface)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (this.surface != null ? this.surface.hashCode() : 0);
        hash = 73 * hash + super.hashCode();
        return hash;
    }

    @Override
    public int compareTo(CorrelationLine o) {
        if (!(o instanceof SurfaceLine)) {
            return this.getCorrelationType().compareTo(o.getCorrelationType());
        }
        SurfaceLine l = (SurfaceLine)o;
        if (this.surface == l.surface) {
            return 0;
        }
        if (this.surface.getSchID() != l.surface.getSchID()) {
            if (this.surface.getSchID() < l.surface.getSchID()) {
                return -1;
            }
            return 1;
        }
        return this.surface.compareTo(l.surface);
    }

    @Override
    void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<SurfaceCorrelationLine Name=\"" + SB.getXMLstring((String)this.toString()) + "\">\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<SurfaceID>" + this.surface.getSurfaceID() + "</SurfaceID>\n");
        if (this.getStyle() != null) {
            out.write(ind + "<Properties>" + this.getStyle().getProperties() + "</Properties>\n");
        }
        out.write(ind1 + "</SurfaceCorrelationLine>\n");
    }
}

