/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.data;

import com.stratadata.model3.wellinterp.DepthAgeCurve;
import java.util.Optional;
import jsbchart.block.BlockProperties;
import jsbchart.block.IBlockProperties;
import model3.TVDList;
import model3.TVDepth;
import model3.TWTDepth;
import model3.TWTList;

public class ScaleConverter {
    private final TVDList tvdList;
    private final DepthAgeCurve depthAgeCurve;
    private final TWTList twtList;
    private final float scaleMin;
    private final float scaleMax;
    private final BlockProperties.ScaleType scaleTypeOfLimits;
    private Float subScaleMin;
    private Float subScaleMax;
    private Optional<Double> minMeasuredDepthCache;
    private Optional<Double> maxMeasuredDepthCache;

    public ScaleConverter(TVDList tvdList, DepthAgeCurve depthAgeCurve, TWTList twtList, float scaleMin, float scaleMax, BlockProperties.ScaleType scaleTypeOfLimits) {
        this.tvdList = tvdList;
        this.depthAgeCurve = depthAgeCurve;
        this.twtList = twtList;
        this.scaleMin = scaleMin;
        this.scaleMax = scaleMax;
        this.scaleTypeOfLimits = scaleTypeOfLimits;
    }

    public BlockProperties.ScaleType getScaleType() {
        return this.scaleTypeOfLimits;
    }

    public Double convert(double value, BlockProperties.ScaleType valueType) {
        return this.convert(value, valueType, this.scaleTypeOfLimits);
    }

    public Double convertMeasuredDepth(double value) {
        return this.convert(value, BlockProperties.ScaleType.MD, this.scaleTypeOfLimits);
    }

    public double convertAndTrimMeasuredDepth(double value) {
        return this.convertAndTrim(value, BlockProperties.ScaleType.MD);
    }

    public double convertAndTrim(double value, BlockProperties.ScaleType valueType) {
        Double val = this.convertAndTrim(value, valueType, this.scaleTypeOfLimits);
        return val == null ? 0.0 : val;
    }

    public Double convertAndTrim(double value, BlockProperties.ScaleType valueType, BlockProperties.ScaleType destinationType) {
        Double convertedValue;
        double[] valuesAsMD = this.convertValueToMD(value, valueType);
        if (valuesAsMD.length == 0) {
            return null;
        }
        double valueAsMD = valuesAsMD[0];
        if (this.getMinMeasuredDepth() != null && this.getMaxMeasuredDepth() != null) {
            if (valueAsMD < this.getMinMeasuredDepth()) {
                valueAsMD = this.getMinMeasuredDepth();
            } else if (valueAsMD > this.getMaxMeasuredDepth()) {
                valueAsMD = this.getMaxMeasuredDepth();
            }
        }
        if ((convertedValue = this.convertMDtoScaleType(valueAsMD, destinationType)) == null && destinationType == BlockProperties.ScaleType.AGE && this.depthAgeCurve != null) {
            if (valueAsMD <= this.depthAgeCurve.getMinDepth()) {
                return this.depthAgeCurve.getMinAge();
            }
            if (valueAsMD >= this.depthAgeCurve.getMaxDepth()) {
                return this.depthAgeCurve.getMaxAge();
            }
        }
        return convertedValue;
    }

    public Double convert(double value, BlockProperties.ScaleType valueType, BlockProperties.ScaleType destinationType) {
        if (valueType == destinationType) {
            return value;
        }
        double[] valuesAsMD = this.convertValueToMD(value, valueType);
        if (valuesAsMD.length == 0 || !this.isWithinPlottableRange(valuesAsMD[0])) {
            return null;
        }
        return this.convertMDtoScaleType(valuesAsMD[0], destinationType);
    }

    public double[] convertToAll(double value, BlockProperties.ScaleType valueType, BlockProperties.ScaleType destinationType) {
        if (valueType == destinationType) {
            return new double[]{value};
        }
        double[] valueAsMD = this.convertValueToMD(value, valueType);
        double[] convertedValues = new double[valueAsMD.length];
        for (int i = 0; i < valueAsMD.length; ++i) {
            convertedValues[i] = this.convertMDtoScaleType(valueAsMD[i], destinationType);
        }
        return convertedValues;
    }

    private double[] convertValueToMD(double value, BlockProperties.ScaleType valueType) {
        double[] valueAsMD;
        switch (valueType) {
            default: {
                throw new MatchException(null, null);
            }
            case MD: {
                double[] dArray = new double[1];
                double[] dArray2 = dArray;
                dArray[0] = value;
                break;
            }
            case AGE: {
                double[] dArray2 = this.convertAgeToMD(value);
                break;
            }
            case TVD: 
            case SUBSIDENCE: {
                double[] dArray2 = this.convertTVDtoMD(value);
                break;
            }
            case TWT: {
                double[] dArray2 = valueAsMD = this.convertTWTtoMD(value);
            }
        }
        if (valueAsMD == null) {
            valueAsMD = new double[]{};
        }
        return valueAsMD;
    }

    private Double convertMDtoScaleType(double valueAsMD, BlockProperties.ScaleType destinationType) {
        return switch (destinationType) {
            default -> throw new MatchException(null, null);
            case BlockProperties.ScaleType.MD -> valueAsMD;
            case BlockProperties.ScaleType.AGE -> this.convertMDtoAGE(valueAsMD);
            case BlockProperties.ScaleType.TVD, BlockProperties.ScaleType.SUBSIDENCE -> this.convertMDtoTVD(valueAsMD);
            case BlockProperties.ScaleType.TWT -> this.convertMDtoTWT(valueAsMD);
        };
    }

    private double[] convertAgeToMD(double ageValue) {
        double[] values = null;
        if (this.depthAgeCurve != null) {
            values = this.depthAgeCurve.getDepths(ageValue);
        }
        return values;
    }

    private Double convertMDtoAGE(double mdValue) {
        double calcVal;
        Double ageValue = null;
        if (this.depthAgeCurve != null && (calcVal = this.depthAgeCurve.getAge((Number)mdValue, false, true)) >= 0.0) {
            ageValue = calcVal;
        }
        return ageValue;
    }

    private double[] convertTWTtoMD(double twtValue) {
        TWTDepth[] depthValues;
        double[] values = null;
        if (this.twtList != null && (depthValues = this.twtList.getDepthsWithExtrapolation(twtValue)) != null) {
            values = new double[depthValues.length];
            for (int i = 0; i < depthValues.length; ++i) {
                values[i] = depthValues[i].getDepth();
            }
        }
        return values;
    }

    private Double convertMDtoTWT(double mdValue) {
        TWTDepth twt;
        Double twtValue = null;
        if (this.twtList != null && (twt = this.twtList.getTWT(mdValue)) != null) {
            twtValue = twt.getTWT();
        }
        return twtValue;
    }

    private double[] convertTVDtoMD(double tvdValue) {
        TVDepth[] d;
        double[] mdValues = null;
        if (this.tvdList != null && (d = this.tvdList.getDepthsWithExtrapolation(tvdValue)) != null) {
            mdValues = new double[d.length];
            for (int i = 0; i < d.length; ++i) {
                mdValues[i] = d[i].getDDepth();
            }
        }
        if (mdValues == null) {
            mdValues = new double[]{tvdValue};
        }
        return mdValues;
    }

    private double convertMDtoTVD(double mdValue) {
        double tvdValue = mdValue;
        if (this.tvdList != null) {
            TVDepth d = this.tvdList.getTVDwithExtrapolation(mdValue);
            tvdValue = d.getTVDepth();
        }
        return tvdValue;
    }

    private Double getMinMeasuredDepth() {
        if (this.minMeasuredDepthCache == null) {
            this.minMeasuredDepthCache = this.getEffectiveScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN);
        }
        return this.minMeasuredDepthCache.orElse(null);
    }

    private Double getMaxMeasuredDepth() {
        if (this.maxMeasuredDepthCache == null) {
            this.maxMeasuredDepthCache = this.getEffectiveScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX);
        }
        return this.maxMeasuredDepthCache.orElse(null);
    }

    public Optional<Double> getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType limitType) {
        return switch (limitType) {
            default -> throw new MatchException(null, null);
            case IBlockProperties.ScaleLimitType.MIN -> Optional.ofNullable(this.getMinMeasuredDepth());
            case IBlockProperties.ScaleLimitType.MAX -> Optional.ofNullable(this.getMaxMeasuredDepth());
        };
    }

    public boolean isTopDepth(float valueAsMeasuredDepth) {
        Double minMeasuredDepth = this.getMinMeasuredDepth();
        if (minMeasuredDepth == null) {
            return false;
        }
        return Math.abs(minMeasuredDepth - (double)valueAsMeasuredDepth) < 0.01;
    }

    public boolean isWithinPlottableRange(double valueAsMeasuredDepth) {
        if (this.subScaleMin != null && this.subScaleMax != null) {
            return valueAsMeasuredDepth + 0.0029 >= (double)this.subScaleMin.floatValue() && valueAsMeasuredDepth - 0.0029 <= (double)this.subScaleMax.floatValue();
        }
        Double minMeasuredDepth = this.getMinMeasuredDepth();
        Double maxMeasuredDepth = this.getMaxMeasuredDepth();
        if (minMeasuredDepth == null || maxMeasuredDepth == null) {
            return false;
        }
        return valueAsMeasuredDepth + 0.0029 >= minMeasuredDepth && valueAsMeasuredDepth - 0.0029 <= maxMeasuredDepth;
    }

    public boolean isWithinPlottableRange(double value, BlockProperties.ScaleType scaleTypeOfValue) {
        double[] valuesAsMeasuredDepth;
        if (scaleTypeOfValue == this.scaleTypeOfLimits) {
            return value + 0.0029 >= (double)this.scaleMin && value - 0.0029 <= (double)this.scaleMax;
        }
        Double minMeasuredDepth = this.getMinMeasuredDepth();
        Double maxMeasuredDepth = this.getMaxMeasuredDepth();
        if (minMeasuredDepth == null || maxMeasuredDepth == null) {
            return false;
        }
        for (double valueAsMeasuredDepth : valuesAsMeasuredDepth = this.convertValueToMD(value, scaleTypeOfValue)) {
            if (!(valueAsMeasuredDepth + 0.0029 >= minMeasuredDepth) || !(valueAsMeasuredDepth - 0.0029 <= maxMeasuredDepth)) continue;
            return true;
        }
        return false;
    }

    public boolean isWithinPlottableRange(double intervalTopMeasuredDepth, double intervalBaseMeasuredDepth) {
        Double minMeasuredDepth = this.getMinMeasuredDepth();
        Double maxMeasuredDepth = this.getMaxMeasuredDepth();
        if (minMeasuredDepth == null || maxMeasuredDepth == null) {
            return false;
        }
        return intervalBaseMeasuredDepth > minMeasuredDepth && intervalTopMeasuredDepth < maxMeasuredDepth;
    }

    public boolean isWithinPlottableRange(double topValue, double baseValue, BlockProperties.ScaleType scaleTypeOfValues) {
        if (scaleTypeOfValues == BlockProperties.ScaleType.MD) {
            return this.isWithinPlottableRange(topValue, baseValue);
        }
        if (scaleTypeOfValues == this.scaleTypeOfLimits) {
            return baseValue > (double)this.scaleMin && topValue < (double)this.scaleMax;
        }
        Double minMeasuredDepth = this.getMinMeasuredDepth();
        Double maxMeasuredDepth = this.getMaxMeasuredDepth();
        if (minMeasuredDepth == null || maxMeasuredDepth == null) {
            return false;
        }
        double[] topValueAsMeasuredDepth = this.convertValueToMD(topValue, scaleTypeOfValues);
        double[] baseValueAsMeasuredDepth = this.convertValueToMD(baseValue, scaleTypeOfValues);
        if (topValueAsMeasuredDepth.length == 0 || baseValueAsMeasuredDepth.length == 0) {
            return false;
        }
        return baseValueAsMeasuredDepth[0] > minMeasuredDepth && topValueAsMeasuredDepth[0] < maxMeasuredDepth;
    }

    private Optional<Double> getEffectiveScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType limitType) {
        double scaleLimit = switch (limitType) {
            default -> throw new MatchException(null, null);
            case IBlockProperties.ScaleLimitType.MIN -> this.scaleMin;
            case IBlockProperties.ScaleLimitType.MAX -> this.scaleMax;
        };
        scaleLimit = (double)Math.round(scaleLimit * 1000.0) / 1000.0;
        switch (this.scaleTypeOfLimits) {
            case MD: {
                return Optional.of(scaleLimit);
            }
            case TVD: 
            case SUBSIDENCE: {
                TVDepth d;
                if (this.tvdList != null && (d = this.tvdList.getDepthWithExtrapolation(scaleLimit, limitType == IBlockProperties.ScaleLimitType.MIN)) != null) {
                    return Optional.of(d.getDDepth());
                }
                return Optional.of(scaleLimit);
            }
            case AGE: {
                if (this.depthAgeCurve == null) {
                    return Optional.empty();
                }
                if (scaleLimit < this.depthAgeCurve.getMinAge()) {
                    return Optional.of(this.depthAgeCurve.getMinDepth());
                }
                if (scaleLimit > this.depthAgeCurve.getMaxAge()) {
                    return Optional.of(this.depthAgeCurve.getMaxDepth());
                }
                return switch (limitType) {
                    default -> throw new MatchException(null, null);
                    case IBlockProperties.ScaleLimitType.MIN -> Optional.ofNullable(this.depthAgeCurve.getDepthOfAge(scaleLimit, null, null, true));
                    case IBlockProperties.ScaleLimitType.MAX -> Optional.ofNullable(this.depthAgeCurve.getDepthOfAge(scaleLimit, null, null, false));
                };
            }
            case TWT: {
                if (this.twtList == null) {
                    return Optional.empty();
                }
                if (scaleLimit < this.twtList.getTopTWT()) {
                    return Optional.of(this.twtList.getTopDD());
                }
                TWTDepth[] d = this.twtList.getDepthsWithExtrapolation(scaleLimit);
                if (d != null && d.length > 0) {
                    return switch (limitType) {
                        default -> throw new MatchException(null, null);
                        case IBlockProperties.ScaleLimitType.MIN -> Optional.of(d[0].getDepth());
                        case IBlockProperties.ScaleLimitType.MAX -> Optional.of(d[d.length - 1].getDepth());
                    };
                }
                return Optional.empty();
            }
        }
        throw new UnsupportedOperationException(this.scaleTypeOfLimits.name());
    }

    public double getPlottableDurationAsMeasuredDepth() {
        Double min = this.getMinMeasuredDepth();
        Double max = this.getMaxMeasuredDepth();
        if (min != null && max != null) {
            return Math.abs(max - min);
        }
        return 0.0;
    }

    public double getPlottableDuration() {
        Double min = this.getMinMeasuredDepth();
        Double max = this.getMaxMeasuredDepth();
        if (min != null && max != null) {
            Double convertedMin = this.convertMDtoScaleType(min, this.scaleTypeOfLimits);
            Double convertedMax = this.convertMDtoScaleType(max, this.scaleTypeOfLimits);
            if (convertedMin != null && convertedMax != null) {
                return Math.abs(convertedMax - convertedMin);
            }
        }
        return 0.0;
    }

    public double getTotalDuration() {
        return Math.abs(this.scaleMax - this.scaleMin);
    }

    public void setSubScaleProperties(float limitAsMeasuredDepth1, float limitAsMeasuredDepth2) {
        this.subScaleMin = Float.valueOf(Math.min(limitAsMeasuredDepth1, limitAsMeasuredDepth2));
        this.subScaleMax = Float.valueOf(Math.max(limitAsMeasuredDepth1, limitAsMeasuredDepth2));
    }
}

