/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SBGraphicsConverter {
    private final double transformFactor;
    private double zoom = 1.0;

    public SBGraphicsConverter(double transformFactor) {
        this.transformFactor = transformFactor;
    }

    public double getTransformFactor() {
        return this.transformFactor * this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public float convertUnscaledPixelsToFloat(int pixelMeasure) {
        return (float)((double)pixelMeasure / (this.zoom * this.transformFactor * 100.0));
    }

    public float convertScaledPixelsToMM(int pixelMeasure) {
        return (float)pixelMeasure / 100.0f;
    }

    public Point2D.Float convertScaledPixelsToMMPoint(Point pixelPoint) {
        return new Point2D.Float(this.convertScaledPixelsToMM(pixelPoint.x), this.convertScaledPixelsToMM(pixelPoint.y));
    }

    public Point2D.Float convertUnscaledPixelsToMMPoint(Point pixelPoint) {
        return new Point2D.Float(this.convertUnscaledPixelsToFloat(pixelPoint.x), this.convertUnscaledPixelsToFloat(pixelPoint.y));
    }

    public int convertFloatToScaledPixels(float floatMeasure) {
        return (int)(floatMeasure * 100.0f);
    }

    public int convertFloatToUnscaledPixels(float floatMeasure) {
        return (int)((double)(floatMeasure * 100.0f) * this.zoom * this.transformFactor);
    }

    public Rectangle2D.Float makeRectFromPixels(int width, int height) {
        return new Rectangle2D.Float(0.0f, 0.0f, this.convertUnscaledPixelsToFloat(width), this.convertUnscaledPixelsToFloat(height));
    }

    public Point2D.Float getEventPoint(MouseEvent e) {
        return new Point2D.Float(this.convertUnscaledPixelsToFloat(e.getX()), this.convertUnscaledPixelsToFloat(e.getY()));
    }

    public Rectangle convertMMRectToScaledPixels(Rectangle2D.Float mmRect) {
        return new Rectangle(this.convertFloatToScaledPixels(mmRect.x), this.convertFloatToScaledPixels(mmRect.y), this.convertFloatToScaledPixels(mmRect.width), this.convertFloatToScaledPixels(mmRect.height));
    }

    public Rectangle convertMMRectToUnscaledPixels(Rectangle2D.Float mmRect) {
        return new Rectangle(this.convertFloatToUnscaledPixels(mmRect.x), this.convertFloatToUnscaledPixels(mmRect.y), this.convertFloatToUnscaledPixels(mmRect.width), this.convertFloatToUnscaledPixels(mmRect.height));
    }
}

