/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jsbchart.panel.spatial.CategoryFillEntry;
import jsbchart.panel.spatial.CategoryFillList;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.factory.CommonFactoryFinder;

public class MapFillBuilder {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory();
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    public List<Rule> getFillRules(CategoryFillList list) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (CategoryFillEntry entry : list.getList()) {
            Rule rule = this.sf.createRule();
            PropertyIsEqualTo f = this.ff.equal((Expression)this.ff.property(list.getPropertyName()), (Expression)this.ff.literal((Object)entry.getValue()), false);
            rule.setFilter((Filter)f);
            Symbolizer s = this.buildEntrySymbolizer(entry);
            rule.symbolizers().add(s);
            rules.add(rule);
        }
        Rule defaultRule = this.sf.createRule();
        defaultRule.setName("default");
        Stroke st = this.sf.createStroke((Expression)this.ff.literal((Object)Color.black), (Expression)this.ff.literal(0.5f));
        Fill f = this.sf.createFill((Expression)this.ff.literal((Object)list.getDefaultFill()), (Expression)this.ff.literal(1));
        PolygonSymbolizer s = this.sf.createPolygonSymbolizer(st, f, (String)null);
        defaultRule.symbolizers().add(s);
        defaultRule.setElseFilter(true);
        rules.add(defaultRule);
        return rules;
    }

    Symbolizer buildEntrySymbolizer(CategoryFillEntry entry) {
        Stroke stroke = this.sf.createStroke((Expression)this.ff.literal((Object)Color.black), (Expression)this.ff.literal(0.5f));
        Mark mark = this.sf.getCircleMark();
        mark.setFill(this.sf.createFill((Expression)this.ff.literal((Object)entry.getFill()), (Expression)this.ff.literal(1)));
        mark.setStroke(stroke);
        Graphic graphic = this.sf.createDefaultGraphic();
        graphic.graphicalSymbols().clear();
        graphic.graphicalSymbols().add(mark);
        graphic.setSize((Expression)this.ff.literal(10));
        Fill fill = this.sf.createFill((Expression)this.ff.literal((Object)entry.getFill()), (Expression)this.ff.literal(1));
        PolygonSymbolizer symbolizer = this.sf.createPolygonSymbolizer(stroke, fill, (String)null);
        return symbolizer;
    }
}

