/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.VerticalAlignment;

public class ScaleBar {
    private final float width;
    private final float height;
    private final String units;
    private final String endLabel;
    private final int numSections;
    private final float fontSize;
    private final Point2D.Float position;
    private final Color fgColour;
    private final Color bgColour;

    public ScaleBar(float width, float height, String endLabel, int numSections, String units, Point2D.Float position, float fontSize, Color fgColour, Color bgColour) {
        this.width = width;
        this.height = height;
        this.endLabel = endLabel;
        this.units = units;
        this.numSections = Math.max(numSections, 1);
        this.position = position;
        this.fontSize = fontSize;
        this.fgColour = fgColour;
        this.bgColour = bgColour;
    }

    public void draw(SBGraphics sg) {
        TextLayoutPreferences tlp = new TextLayoutPreferences();
        tlp.setFont(SBFont.buildFontFromGraphics(sg, this.fontSize));
        tlp.setTextDirection(TextDirection.Horizontal);
        tlp.setHorizontalAlignment(HorizontalAlignment.Left);
        tlp.setVerticalAlignment(VerticalAlignment.Middle);
        float unitWidth = sg.getTextMeasurer().calculateTextWidth(this.units, tlp.buildSettings());
        float fontHeight = sg.getTextMeasurer().calculateTextHeight(this.units, tlp.buildSettings());
        float totalHeight = Math.max(this.height, fontHeight) + fontHeight;
        float totalWidth = this.width + unitWidth;
        sg.setStroke(0.2f);
        sg.setColor(Color.black);
        float sectionWidth = this.width / (float)this.numSections;
        Rectangle2D.Float scaleBarBox = new Rectangle2D.Float(this.position.x, this.position.y, this.width, Math.max(this.height, fontHeight));
        Rectangle2D.Float unitTextBox = new Rectangle2D.Float(scaleBarBox.x + scaleBarBox.width + 0.5f, this.position.y, unitWidth, scaleBarBox.height);
        TextLayoutPreferences textLayoutPreferencesLabel = new TextLayoutPreferences().setFont(SBFont.buildFontFromGraphics(sg, this.fontSize)).setVerticalAlignment(VerticalAlignment.Top).setHorizontalAlignment(HorizontalAlignment.Left).dontResizeText().dontTruncateText().singleLineOfText();
        ITextMeasurer tm = sg.getTextMeasurer();
        float widthOfZero = tm.calculateTextWidth("0", textLayoutPreferencesLabel.buildSettings());
        float widthOfEndLabel = tm.calculateTextWidth(this.endLabel, textLayoutPreferencesLabel.buildSettings());
        Rectangle2D.Float labelTextBox = new Rectangle2D.Float(scaleBarBox.x - 0.5f * widthOfZero, this.position.y + scaleBarBox.height, this.width + 0.5f * widthOfZero + 0.5f * widthOfEndLabel, fontHeight);
        float padding = 0.0f;
        if (scaleBarBox.height > this.height) {
            padding = scaleBarBox.height - this.height;
        }
        boolean fill = false;
        for (int i = 0; i < this.numSections; ++i) {
            float sectionStart = sectionWidth * (float)i;
            float sectionEnd = sectionWidth * (float)(i + 1);
            if (fill) {
                sg.setColor(this.fgColour);
                sg.fillRect(scaleBarBox.x + sectionStart, scaleBarBox.y + padding * 0.5f, sectionEnd - sectionStart, this.height);
            } else {
                sg.setColor(this.bgColour);
                sg.fillRect(scaleBarBox.x + sectionStart, scaleBarBox.y + padding * 0.5f, sectionEnd - sectionStart, this.height);
            }
            fill = !fill;
        }
        sg.setColor(this.fgColour);
        sg.drawRect(scaleBarBox.x, scaleBarBox.y + padding * 0.5f, scaleBarBox.width, scaleBarBox.height - padding);
        if (padding > 0.0f) {
            sg.drawLine(labelTextBox.x + widthOfZero * 0.5f, labelTextBox.y, labelTextBox.x + widthOfZero * 0.5f, labelTextBox.y - padding * 0.5f);
            sg.drawLine(labelTextBox.x + labelTextBox.width - widthOfEndLabel * 0.5f, labelTextBox.y, labelTextBox.x + labelTextBox.width - widthOfEndLabel * 0.5f, labelTextBox.y - padding * 0.5f);
        }
        sg.drawStringWithinBox("0", labelTextBox, textLayoutPreferencesLabel);
        textLayoutPreferencesLabel.setHorizontalAlignment(HorizontalAlignment.Right);
        sg.drawStringWithinBox(this.endLabel, labelTextBox, textLayoutPreferencesLabel);
        sg.drawStringWithinBox(this.units, unitTextBox, tlp);
    }

    private void drawScaleLabel(SBGraphics sg, TextLayoutPreferences tlp, float x, float y, String label) {
        DimensionF dim = sg.measureText(label, tlp);
        float textX = (float)((double)x - 0.5 * (double)dim.getWidth());
        float textY = y + dim.getHeight();
        sg.drawString(label, textX, textY);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public String getUnits() {
        return this.units;
    }

    public String getEndLabel() {
        return this.endLabel;
    }

    public int getNumSections() {
        return this.numSections;
    }

    public Point2D.Float getPosition() {
        return this.position;
    }

    public float getFontSize() {
        return this.fontSize;
    }
}

