/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.util.Collections;
import java.util.List;
import model3.Well;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;

public class SelectedWellFunction
extends FunctionExpressionImpl {
    private List<Well> selectedWells = Collections.emptyList();
    public static FunctionName NAME = new FunctionNameImpl("SelectedWellFn", Boolean.class, new Parameter[]{FunctionNameImpl.parameter((String)"well_id", Integer.class)});

    public SelectedWellFunction() {
        super(NAME);
    }

    public void setSelectedWells(List<Well> selectedWells) {
        this.selectedWells = selectedWells;
    }

    public List<Well> getSelectedWells() {
        return this.selectedWells;
    }

    public int getArgCount() {
        return 0;
    }

    public Object evaluate(Object feature) {
        SimpleFeature f = (SimpleFeature)feature;
        Integer well_id = (Integer)f.getAttribute("well_id");
        if (well_id == null) {
            return false;
        }
        boolean isSelected = this.selectedWells.stream().anyMatch(r -> r.getWellID() == well_id.intValue());
        return isSelected;
    }
}

