/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import java.util.ArrayList;
import java.util.List;
import jsbchart.graphics.text.IHorizontalTextWrapper;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextSettings;

public class BasicHorizontalTextWrapper
implements IHorizontalTextWrapper {
    private static final String ELLIPSIS = "...";
    private final ITextMeasurer measurer;
    private boolean truncateToWholeToken = false;
    private static final char HYPHEN = '-';
    private String truncationMarker = "...";

    @Override
    public void setTruncationMarker(String value) {
        this.truncationMarker = value;
    }

    @Override
    public String getTruncationMarker() {
        return this.truncationMarker;
    }

    public BasicHorizontalTextWrapper(ITextMeasurer measurer) {
        this.measurer = measurer;
    }

    @Override
    public void setTruncateToWholeToken(boolean value) {
        this.truncateToWholeToken = value;
    }

    public boolean getTruncateToWholeToken() {
        return this.truncateToWholeToken;
    }

    @Override
    public List<String> wrap(String text, float width, float height, TextSettings settings) {
        List<String> lines = new ArrayList<String>();
        if (text == null) {
            lines.add(null);
            return lines;
        }
        int numLines = this.howManyLinesWillFit(height, settings.getFont());
        if (numLines == 0) {
            lines.add(this.truncationMarker);
            return lines;
        }
        String t = text;
        t = t.replaceAll("\n", " \n ");
        String[] tokens = t.split(" ");
        lines = this.fillLinesWithTokens(tokens = this.clearEmptyTokens(tokens), width, numLines, settings);
        if (this.doesLinesListContainLongToken(lines, width, settings)) {
            lines = this.truncateOutputOnLongToken(lines, width, settings);
        }
        if (lines.size() > numLines) {
            this.truncateExtraToLastLine(lines, width, settings);
        }
        if (lines.size() > 1 && lines.get(lines.size() - 1).equals(this.truncationMarker)) {
            this.tryToMoveTruncationMarkerToPenultimateLine(lines, width, settings);
        }
        if (lines.isEmpty()) {
            lines.add("");
        }
        return lines;
    }

    private String[] clearEmptyTokens(String[] tokens) {
        ArrayList<String> l = new ArrayList<String>();
        for (String token : tokens) {
            if (!token.equals("\n") && token.trim().isEmpty()) continue;
            l.add(token);
        }
        return l.toArray(new String[l.size()]);
    }

    private int howManyLinesWillFit(float height, SBFont font) {
        float lineHeight = this.measurer.calculateHorizontalLineHeight(font);
        float num = height / lineHeight;
        return (int)Math.floor(num);
    }

    private float measureTextWidth(String s, TextSettings settings) {
        return this.measurer.calculateTextWidth(s.trim(), settings);
    }

    private void addLine(List<String> lines, String s) {
        lines.add(s.trim());
    }

    private List<String> fillLinesWithTokens(String[] tokens, float width, int numLines, TextSettings settings) {
        ArrayList<String> lines = new ArrayList<String>();
        Object currentLine = "";
        for (String token : tokens) {
            if (lines.size() == numLines) break;
            if ("\n".equals(token)) {
                this.addLine(lines, (String)currentLine);
                currentLine = "";
                continue;
            }
            if (this.measureTextWidth((String)currentLine + token, settings) < width) {
                currentLine = (String)currentLine + token + " ";
                continue;
            }
            if (!((String)currentLine).isEmpty()) {
                this.addLine(lines, (String)currentLine);
            }
            currentLine = token + " ";
        }
        this.addLine(lines, (String)currentLine);
        return lines;
    }

    private void truncateExtraToLastLine(List<String> lines, float width, TextSettings settings) {
        if (lines.size() < 2) {
            return;
        }
        String lastLine = lines.get(lines.size() - 2);
        String extra = lines.get(lines.size() - 1);
        lastLine = this.truncateToWholeToken ? this.removeTokensToFitTruncationMarker(lastLine, width, settings) : (this.measureTextWidth(lastLine + this.truncationMarker, settings) < width ? this.fillLineWithTokenAndEllipsis(extra, lastLine, settings, width) : this.removeCharsToFitTruncationMarker(lastLine, width, settings));
        lines.set(lines.size() - 2, lastLine);
        lines.remove(lines.size() - 1);
    }

    private void truncateLastLineAtLastPossibleCharacter(List<String> lines, float width, TextSettings settings) {
        String lastLine = lines.get(lines.size() - 2);
        String extra = lines.get(lines.size() - 1);
        lastLine = this.measureTextWidth(lastLine + this.truncationMarker, settings) < width ? this.fillLineWithTokenAndEllipsis(extra, lastLine, settings, width) : this.removeCharsToFitTruncationMarker(lastLine, width, settings);
        lines.set(lines.size() - 2, lastLine);
        lines.remove(lines.size() - 1);
    }

    private String fillLineWithTokenAndEllipsis(String tok, String line, TextSettings settings, float width) {
        if (!((String)line).endsWith(" ")) {
            line = (String)line + " ";
        }
        Object subToken = "";
        for (int charIndex = 0; charIndex < tok.length() && this.measureTextWidth((String)line + (String)subToken + tok.charAt(charIndex) + this.truncationMarker, settings) < width; ++charIndex) {
            subToken = (String)subToken + tok.charAt(charIndex);
        }
        line = ((String)subToken).length() > 0 ? (String)line + (String)subToken + this.truncationMarker : ((String)line).trim() + this.truncationMarker;
        return line;
    }

    private String removeCharsToFitTruncationMarker(String line, float width, TextSettings settings) {
        while (this.measureTextWidth(line + this.truncationMarker, settings) >= width) {
            if (line.length() > 0) {
                line = line.substring(0, line.length() - 1);
            }
            if (!line.isEmpty()) continue;
            break;
        }
        return line + this.truncationMarker;
    }

    private String removeTokensToFitTruncationMarker(String line, float width, TextSettings settings) {
        while (this.measureTextWidth(line + this.truncationMarker, settings) >= width && !(line = line.contains(" ") ? line.substring(0, line.lastIndexOf(" ")) : "").isEmpty()) {
        }
        return line + this.truncationMarker;
    }

    private void truncateToWholeToken(List<String> lines, float width, TextSettings settings) {
        if (lines.size() < 2) {
            return;
        }
        lines.remove(lines.size() - 1);
        String lastLine = lines.get(lines.size() - 1).trim();
        while (this.measureTextWidth(lastLine + this.truncationMarker, settings) >= width && !(lastLine = lastLine.contains(" ") ? lastLine.substring(0, lastLine.lastIndexOf(" ")) : "").isEmpty()) {
        }
        lines.set(lines.size() - 1, lastLine + this.truncationMarker);
    }

    private String[] hyphenateAnyLongTokens(String[] tokens, TextSettings settings, float width) {
        ArrayList<Object> newTokens = new ArrayList<Object>();
        for (String token : tokens) {
            if (this.measureTextWidth(token, settings) >= width) {
                Object subToken = "";
                subToken = (String)subToken + token.charAt(0);
                for (int i = 1; i < token.length(); ++i) {
                    if (this.measureTextWidth((String)subToken + token.charAt(i) + "-", settings) >= width) {
                        newTokens.add((String)subToken + "-");
                        subToken = "" + token.charAt(i);
                        continue;
                    }
                    subToken = (String)subToken + token.charAt(i);
                }
                newTokens.add(subToken);
                continue;
            }
            newTokens.add(token);
        }
        return newTokens.toArray(new String[newTokens.size()]);
    }

    private String[] splitAnyLongTokens(String[] tokens, TextSettings settings, float width) {
        ArrayList<Object> newTokens = new ArrayList<Object>();
        for (String token : tokens) {
            if (this.measureTextWidth(token, settings) >= width) {
                Object subToken = "";
                subToken = (String)subToken + token.charAt(0);
                for (int i = 1; i < token.length(); ++i) {
                    if (this.measureTextWidth((String)subToken + token.charAt(i), settings) >= width) {
                        newTokens.add(subToken);
                        subToken = "" + token.charAt(i);
                        continue;
                    }
                    subToken = (String)subToken + token.charAt(i);
                }
                newTokens.add(subToken);
                continue;
            }
            newTokens.add(token);
        }
        return newTokens.toArray(new String[newTokens.size()]);
    }

    private void tryToMoveTruncationMarkerToPenultimateLine(List<String> lines, float width, TextSettings settings) {
        String penultimateLine;
        if (lines.size() > 1 && lines.get(lines.size() - 1).equals(this.truncationMarker) && this.measureTextWidth((penultimateLine = lines.get(lines.size() - 2)) + this.truncationMarker, settings) < width) {
            lines.set(lines.size() - 2, penultimateLine + this.truncationMarker);
            lines.remove(lines.size() - 1);
        }
    }

    private boolean doesLinesListContainLongToken(List<String> lines, float width, TextSettings settings) {
        for (String l : lines) {
            if (!(this.measureTextWidth(l, settings) >= width)) continue;
            return true;
        }
        return false;
    }

    private List<String> truncateOutputOnLongToken(List<String> lines, float width, TextSettings settings) {
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String l = lines.get(i);
            if (this.measureTextWidth(l, settings) >= width) {
                if (this.truncateToWholeToken) {
                    newList.add(this.truncationMarker);
                } else {
                    String lastLine = this.removeCharsToFitTruncationMarker(l, width, settings);
                    newList.add(lastLine);
                }
                return newList;
            }
            newList.add(l);
        }
        return newList;
    }
}

