/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import jsbchart.core.ChartProperties;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.ITruncationHandler;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.TextWrapper;

public class MoveTextToLegendTruncationHandler
implements ITruncationHandler {
    private final ChartProperties chartProperties;
    private final ITextMeasurer textMeasuer;
    private final TextWrapper wrapper;

    public MoveTextToLegendTruncationHandler(ITextMeasurer textMeasurer, ChartProperties chartProperties) {
        this.textMeasuer = textMeasurer;
        this.wrapper = new TextWrapper(textMeasurer);
        this.chartProperties = chartProperties;
    }

    @Override
    public String handleTruncation(String text, DimensionF targetDimensions, TextSettings settings) {
        if (this.chartProperties.getKeyData() != null) {
            int textNo = this.chartProperties.getKeyData().putText(text);
            Object s = this.chartProperties.keyIsVisible() ? "*" + textNo : "*";
            return s;
        }
        return this.wrapper.truncateText(text, targetDimensions, settings);
    }

    @Override
    public String[] handleWrapAndTruncation(String text, DimensionF targetDimensions, TextSettings settings) {
        if (this.chartProperties.getKeyData() != null) {
            int textNo = this.chartProperties.getKeyData().putText(text);
            Object s = this.chartProperties.keyIsVisible() ? "*" + textNo : "*";
            return new String[]{s};
        }
        return this.wrapper.wrapTextAndTruncate(text, targetDimensions, settings);
    }
}

