/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextSettings;

public class SBTextMeasurer
implements ITextMeasurer {
    private final Graphics2D g;
    private final float scale;

    public SBTextMeasurer(Graphics2D g, float scale) {
        this.g = g;
        this.scale = scale;
    }

    @Override
    public DimensionF calculateTextDimensions(String[] lines, TextSettings settings) {
        DimensionF result = new DimensionF(this.calculateTextWidth(lines, settings), this.calculateTextHeight(lines, settings));
        return result;
    }

    @Override
    public DimensionF calculateTextDimensions(String text, TextSettings settings) {
        return this.calculateTextDimensions(new String[]{text}, settings);
    }

    @Override
    public float calculateTextHeight(String[] lines, TextSettings settings) {
        this.g.setFont(settings.getFont().buildGraphicsFont(this.scale));
        float height = settings.getTextDirection() == TextDirection.Horizontal ? this.getLinesHeight(lines.length) : this.getMaxLineWidth(lines);
        return height;
    }

    @Override
    public float calculateTextWidth(String[] lines, TextSettings settings) {
        this.g.setFont(settings.getFont().buildGraphicsFont(this.scale));
        float width = settings.getTextDirection() == TextDirection.Horizontal ? this.getMaxLineWidth(lines) : this.getLinesHeight(lines.length);
        return width;
    }

    @Override
    public float calculateHorizontalLineHeight(SBFont font) {
        Font oldFont = this.g.getFont();
        this.g.setFont(font.buildGraphicsFont(this.scale));
        float height = (float)this.g.getFontMetrics().getHeight() / this.scale;
        this.g.setFont(oldFont);
        return height;
    }

    @Override
    public float calculateTextWidth(String text, TextSettings settings) {
        return this.calculateTextWidth(new String[]{text}, settings);
    }

    @Override
    public float calculateTextHeight(String text, TextSettings settings) {
        return this.calculateTextHeight(new String[]{text}, settings);
    }

    @Override
    public float calculateTextWidth(AttributedString string, TextSettings settings) {
        DimensionF dimension = this.getDimensionsOfString(string, settings);
        if (settings.getTextDirection() == TextDirection.Horizontal) {
            return dimension.getWidth();
        }
        return dimension.getHeight();
    }

    @Override
    public float calculateTextHeight(AttributedString string, TextSettings settings) {
        DimensionF dimension = this.getDimensionsOfString(string, settings);
        if (settings.getTextDirection() == TextDirection.Horizontal) {
            return dimension.getHeight();
        }
        return dimension.getWidth();
    }

    private float getLinesHeight(int numLines) {
        float lineHeight = (float)this.g.getFontMetrics().getHeight() / this.scale;
        return lineHeight * (float)numLines;
    }

    private float getMaxLineWidth(String[] lines) {
        float width = 0.0f;
        for (String line : lines) {
            float w = this.getTextWidth(line);
            if (!(w > width)) continue;
            width = w;
        }
        return width;
    }

    private float getTextWidth(String text) {
        if (text == null) {
            return 0.0f;
        }
        return (float)this.g.getFontMetrics(this.g.getFont()).stringWidth(text) / this.scale;
    }

    private DimensionF getDimensionsOfString(AttributedString string, TextSettings settings) {
        this.g.setFont(settings.getFont().buildGraphicsFont(this.scale));
        FontMetrics fm = this.g.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(string.getIterator(), 0, string.getIterator().getEndIndex(), (Graphics)this.g);
        return new DimensionF((float)bounds.getWidth() / this.scale, (float)bounds.getHeight() / this.scale);
    }
}

