/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBTextMeasurer;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.TextRenderer;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.TextSizer;
import jsbchart.graphics.text.TextWrapper;

public class TextArtist {
    private final ITextMeasurer measurer;
    private final TextWrapper wrapper;
    private final TextSizer resizer;
    private final TextRenderer renderer;

    public TextArtist(Graphics2D g, float scale) {
        this.measurer = new SBTextMeasurer(g, scale);
        this.wrapper = new TextWrapper(this.measurer);
        this.resizer = new TextSizer(this.measurer);
        this.renderer = new TextRenderer(g, this.measurer, scale);
    }

    public Rectangle2D.Float drawText(String text, Rectangle2D.Float box, TextLayoutPreferences preferences) {
        TextSettings settings = new TextSettings(preferences.getHorizontalAllignment(), preferences.getVerticalAllignment(), preferences.getTextDirection(), preferences.getFont());
        DimensionF dims = new DimensionF(box.width, box.height);
        if (!preferences.getWrapText()) {
            text = this.wrapper.removeSyllableSeparationChar(text);
            if (this.resizer.canResize(settings, preferences.getMinFontSize())) {
                settings = this.resizer.resizeTextToFit(text, dims, settings, preferences.getMinFontSize());
            }
            if (!this.measurer.calculateTextDimensions(text, settings).fitsInside(dims) && preferences.shouldTruncate()) {
                text = preferences.hasTruncationHandler() ? preferences.getTruncationHandler().handleTruncation(text, dims, settings) : this.wrapper.truncateText(text, dims, settings);
            }
            if (!this.measurer.calculateTextDimensions(text, settings).fitsInside(dims) && preferences.shouldHideIfOverflow()) {
                return new Rectangle2D.Float(box.x, box.y, 0.0f, 0.0f);
            }
            return this.renderer.drawString(text, box, settings);
        }
        return this.drawTextWrapAndScale(text, box, settings, preferences);
    }

    private Rectangle2D.Float drawTextWrapAndScale(String text, Rectangle2D.Float box, TextSettings originalSettings, TextLayoutPreferences preferences) {
        DimensionF dimensions = new DimensionF(box.width, box.height);
        TextSettings settings = originalSettings;
        String[] lines = this.wrapper.wrapText(text, dimensions, settings);
        if (this.resizer.canResize(originalSettings, preferences.getMinFontSize())) {
            for (int i = 0; i <= 10 && !this.measurer.calculateTextDimensions(lines = this.wrapper.wrapText(text, dimensions, settings = this.resizer.resizeIteration(i, settings, preferences.getMinFontSize())), settings).fitsInside(dimensions); ++i) {
            }
        }
        if (!this.measurer.calculateTextDimensions(lines, settings).fitsInside(dimensions) && preferences.shouldTruncate()) {
            lines = preferences.hasTruncationHandler() ? preferences.getTruncationHandler().handleWrapAndTruncation(text, dimensions, settings) : this.wrapper.wrapTextAndTruncate(text, dimensions, settings);
        }
        if (!this.measurer.calculateTextDimensions(lines, settings).fitsInside(dimensions) && preferences.shouldHideIfOverflow()) {
            return new Rectangle2D.Float(box.x, box.y, 0.0f, 0.0f);
        }
        return this.renderer.drawString(lines, box, settings);
    }
}

