/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.text.BasicHorizontalTextWrapper;
import jsbchart.graphics.text.HorizontalTextWrapper;
import jsbchart.graphics.text.IHorizontalTextWrapper;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextSettings;

public class TextWrapper {
    private final HorizontalTextWrapper hyphenatingWrapper;
    private final BasicHorizontalTextWrapper basicWrapper;
    public static final String ELLIPSIS = "...";
    public static char SYLLABLE_SEPARATION_CHAR = (char)92;
    private boolean hyphenateText = true;

    public TextWrapper(ITextMeasurer measurer) {
        this.hyphenatingWrapper = new HorizontalTextWrapper(measurer);
        this.basicWrapper = new BasicHorizontalTextWrapper(measurer);
    }

    public boolean getHyphenateText() {
        return this.hyphenateText;
    }

    public void setHyphenateText(boolean value) {
        this.hyphenateText = value;
    }

    public String[] wrapText(String text, DimensionF dimensions, TextSettings settings) {
        List<String> lines;
        if (settings.getTextDirection() == TextDirection.Horizontal) {
            lines = this.getWrapper().wrap(text, dimensions.getWidth(), Float.MAX_VALUE, settings);
        } else {
            TextSettings hozSettings = new TextSettings(settings.getHorizontalAlignment(), settings.getVerticalAlignment(), TextDirection.Horizontal, settings.getFont());
            lines = this.getWrapper().wrap(text, dimensions.getHeight(), Float.MAX_VALUE, hozSettings);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public String truncateText(String text, DimensionF dimensions, TextSettings settings) {
        List<String> lines;
        if (settings.getTextDirection() == TextDirection.Horizontal) {
            lines = this.getWrapper().wrap(text, dimensions.getWidth(), 0.0f, settings);
        } else {
            TextSettings hozSettings = new TextSettings(settings.getHorizontalAlignment(), settings.getVerticalAlignment(), TextDirection.Horizontal, settings.getFont());
            lines = this.getWrapper().wrap(text, dimensions.getHeight(), 0.0f, hozSettings);
        }
        if (lines.isEmpty()) {
            Logger.getLogger(TextWrapper.class.getName()).log(Level.WARNING, "truncateText got empty line list for: ", text);
            return "";
        }
        return lines.get(0);
    }

    public String[] wrapTextAndTruncate(String text, DimensionF dimensions, TextSettings settings) {
        List<String> lines;
        if (settings.getTextDirection() == TextDirection.Horizontal) {
            lines = this.getWrapper().wrap(text, dimensions.getWidth(), dimensions.getHeight(), settings);
        } else {
            TextSettings hozSettings = new TextSettings(settings.getHorizontalAlignment(), settings.getVerticalAlignment(), TextDirection.Horizontal, settings.getFont());
            lines = this.getWrapper().wrap(text, dimensions.getHeight(), dimensions.getWidth(), hozSettings);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public String getTruncationMarker() {
        return this.getWrapper().getTruncationMarker();
    }

    private IHorizontalTextWrapper getWrapper() {
        if (this.hyphenateText) {
            return this.hyphenatingWrapper;
        }
        return this.basicWrapper;
    }

    public String getRemainingText(String original, String truncated) {
        if (original == null || truncated == null) {
            return null;
        }
        int remainingStart = truncated.length();
        if (truncated.endsWith(this.getWrapper().getTruncationMarker())) {
            remainingStart -= this.getWrapper().getTruncationMarker().length();
        }
        return original.substring(remainingStart).trim();
    }

    public String getRemainingText(String original, String[] truncated) {
        if (original == null || truncated == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String l : truncated) {
            if (l == null) continue;
            sb.append(l).append(" ");
        }
        String originalFlat = original.replace("\n", " ");
        originalFlat = originalFlat.replace("\r", " ");
        originalFlat = originalFlat.trim().replaceAll(" +", " ");
        String truncatedRebuilt = sb.toString().trim().replaceAll(" +", " ");
        int remainingStart = truncatedRebuilt.length();
        if (truncatedRebuilt.endsWith(this.getWrapper().getTruncationMarker())) {
            remainingStart -= this.getWrapper().getTruncationMarker().length();
        }
        if (remainingStart > originalFlat.length()) {
            return "";
        }
        return originalFlat.substring(remainingStart).trim();
    }

    public String removeSyllableSeparationChar(String text) {
        return this.hyphenatingWrapper.removeSyllableSeparationChar(text);
    }

    public void setTruncateAtWord(boolean b) {
        this.hyphenatingWrapper.setTruncateToWholeToken(b);
        this.basicWrapper.setTruncateToWholeToken(b);
    }

    public void setTruncationMarker(String value) {
        this.hyphenatingWrapper.setTruncationMarker(value);
        this.basicWrapper.setTruncationMarker(value);
    }
}

