/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.listener;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartNodeListener;
import jsbchart.listener.ChartUpdate;
import util.SBException;
import util.listener.AbstractPublisher;

public abstract class ChartNode
extends AbstractPublisher<ChartNode, ChartNodeListener>
implements ChartNodeListener {
    private boolean enabled = true;
    private ChartEvent event;
    private boolean expectingUrgentChange;

    public ChartNode() {
        super(null);
    }

    public ChartNode(boolean enabled) {
        this();
        this.enabled = enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        if (!this.enabled) {
            // empty if block
        }
        if (this.event == null) {
            return;
        }
        ChartEvent chartEvent = this.event;
        synchronized (chartEvent) {
            for (ChartNodeListener l : this.getListeners()) {
                l.onChartEvent(this.event);
            }
            this.event = null;
        }
        this.expectingUrgentChange = false;
    }

    protected void setPropertyChanged() {
        if (!this.enabled) {
            return;
        }
        this.setEvent(ChartEvent.createPropertyChangeChartEvent(this));
    }

    protected void setPropertyChanged(Object arg) {
        if (!this.enabled) {
            return;
        }
        this.setEvent(ChartEvent.createPropertyChangeChartEvent(this, arg));
    }

    protected void setPropertyChanged(ChartNode child) {
        if (!this.enabled) {
            return;
        }
        ChartEvent e = ChartEvent.createPropertyChangeChartEvent(child);
        e.addNodeToPath(this);
        this.setEvent(e);
    }

    protected void setDataChanged(Object arg) {
        if (!this.enabled) {
            return;
        }
        this.setEvent(ChartEvent.createDataChangeChartEvent(this, arg));
    }

    protected void setDataChanged() {
        this.setDataChanged(null);
    }

    protected void setSoftChanged() {
        if (!this.enabled) {
            return;
        }
        if (this.event == null) {
            this.setEvent(ChartEvent.createSoftChangeChartEvent(this));
        }
    }

    private void setEvent(ChartEvent event) {
        this.event = event;
        if (this.expectingUrgentChange) {
            event.setUrgent(true);
            this.expectingUrgentChange = false;
        }
    }

    @Override
    public void onChartEvent(ChartEvent e) {
        e.addNodeToPath(this);
        this.event = e;
        this.notifyListeners();
    }

    public void setExpectingUrgentChange() {
        this.expectingUrgentChange = true;
    }

    public void setDontExpectingUrgentChange() {
        this.expectingUrgentChange = false;
    }

    public abstract void prepareData(ChartUpdate var1);

    public abstract void setData(ChartEvent var1, ChartUpdate var2) throws SBException, SQLException, IOException;

    public void registerListener(ChartNodeListener chartNodeListener) {
        if (!this.getListeners().isEmpty()) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Adding ChartNodeListener where listeners already exist for " + this.getClass().getName());
        }
        super.registerListener((Object)chartNodeListener);
    }
}

