/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;

public abstract class BasicPanelProperties
extends PanelProperties {
    protected List<PanelPropertyItem> items = new ArrayList<PanelPropertyItem>();

    protected BasicPanelProperties(PanelType panelType) {
        super(panelType);
    }

    protected final void setValuesFromPropertiesString(String props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        String[] split = props.split("\\|");
        Iterator<PanelPropertyItem> itemIt = this.items.iterator();
        for (int i = 0; i < split.length && itemIt.hasNext(); ++i) {
            PanelPropertyItem item = itemIt.next();
            while (item.propertyType == PanelPropertyItem.PropertyType.TRACKED) {
                item = itemIt.next();
            }
            try {
                item.setValueFromObject(split[i]);
                continue;
            }
            catch (Exception e) {
                Logger.getLogger(BasicPanelProperties.class.getName()).log(Level.WARNING, "Error setting property " + this.items.get(i).getName() + " on " + this.getClass().getName() + " from the string \"" + split[i] + "\", not changing value.", e);
            }
        }
    }

    @Override
    public String getPropertiesString() {
        StringBuilder sb = new StringBuilder();
        this.items.stream().filter(i -> i.propertyType == PanelPropertyItem.PropertyType.SIMPLE).forEachOrdered(i -> {
            sb.append(i.getStringValue());
            sb.append("|");
        });
        return sb.toString();
    }

    @Override
    public String getPrefs() {
        return this.getPropertiesString();
    }

    @Override
    public String getPropertyName(int nProp) {
        return this.items.get(nProp).getName();
    }

    @Override
    public Object getProperty(int nProp) {
        return this.items.get(nProp).getValue();
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        return this.items.get(nProp).setValueFromObject(prop);
    }

    @Override
    public int getnProps() {
        return this.items.size();
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        return this.items.get(nProp).getPropertyClass();
    }

    @Override
    public boolean allowNull(int nProp) {
        return this.items.get(nProp).isNullable();
    }

    @Override
    public String getNullText(int nProp) {
        return this.items.get(nProp).getNullText();
    }
}

