/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.util.Objects;
import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;

public class PanelAccumulationRateProperties
extends BasicPanelProperties {
    public static final String WIDTH_PROPERTY_NAME = "Width";
    public static final String FILL_COLOUR_PROPERTY_NAME = "Fill colour";
    public static final String PLOT_STYLE_PROPERTY_NAME = "Plot style";
    public static final String AUTO_ACCUM_RATE_MAX_PROPERTY_NAME = "Use automatic rate max";
    public static final String ACCUM_RATE_MAX_PROPERTY_NAME = "Accumulation rate max";
    public static final String ACCUM_RATE_UNITS_PROPERTY_NAME = "Accumulation rate units";
    public static final String SHOW_TEXT_PROPERTY_NAME = "Show text";
    private final PanelPropertyItem<Integer> width = new PanelPropertyItem<Integer>(Integer.class, "Width", 50);
    private final PanelPropertyItem<Color> fillColour = new PanelPropertyItem<Color>(Color.class, "Fill colour", Color.RED);
    private final PanelPropertyItem<PlotStyle> plotStyle = new PanelPropertyItem<PlotStyle>(PlotStyle.class, "Plot style", PlotStyle.BARS_CENTRE);
    private final PanelPropertyItem<Boolean> autoAccumRate = new PanelPropertyItem<Boolean>(Boolean.class, "Use automatic rate max", true);
    private final PanelPropertyItem<Float> accumRateMax = new PanelPropertyItem<Float>(Float.class, "Accumulation rate max", Float.valueOf(5.0f));
    private final PanelPropertyItem<AccumRateUnits> accumRateUnits = new PanelPropertyItem<AccumRateUnits>(AccumRateUnits.class, "Accumulation rate units", AccumRateUnits.METERS);
    private final PanelPropertyItem<Boolean> showText = new PanelPropertyItem<Boolean>(Boolean.class, "Show text", false);

    PanelAccumulationRateProperties(String props) {
        super(PanelType.ACCUMRATE);
        this.items.add(this.width);
        this.items.add(this.fillColour);
        this.items.add(this.plotStyle);
        this.items.add(this.autoAccumRate);
        this.items.add(this.accumRateMax);
        this.items.add(this.accumRateUnits);
        this.items.add(this.showText);
        this.setValuesFromPropertiesString(props);
    }

    public int getWidth() {
        return this.width.getValue();
    }

    public Color getFillColour() {
        return this.fillColour.getValue();
    }

    public PlotStyle getPlotStyle() {
        return this.plotStyle.getValue();
    }

    public boolean useAutoAccumulationRate() {
        return this.autoAccumRate.getValue();
    }

    public float getAccumRateMax() {
        return this.accumRateMax.getValue().floatValue();
    }

    public AccumRateUnits getAccumRateUnits() {
        return this.accumRateUnits.getValue();
    }

    public boolean showText() {
        return this.showText.getValue();
    }

    @Override
    public boolean showRow(int row) {
        if (row < 0 || row >= this.items.size()) {
            return true;
        }
        PanelPropertyItem item = (PanelPropertyItem)this.items.get(row);
        if (item.equals(this.accumRateMax) || item.equals(this.accumRateUnits)) {
            return !this.useAutoAccumulationRate();
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int row) {
        PanelPropertyItem item = (PanelPropertyItem)this.items.get(row);
        return item.equals(this.autoAccumRate);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        PanelPropertyItem item = (PanelPropertyItem)this.items.get(nProp);
        Boolean propertyChanged = item.equals(this.width) ? Boolean.valueOf(this.setPanelWidth(Integer.parseInt(prop.toString()))) : Boolean.valueOf(item.setValueFromObject(prop));
        return propertyChanged;
    }

    private boolean setPanelWidth(int panelWidth) {
        if (panelWidth >= 1 && Math.abs(this.getWidth() - panelWidth) >= 1) {
            this.width.setValue(panelWidth);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelAccumulationRateProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelAccumulationRateProperties rhs = (PanelAccumulationRateProperties)comp;
        for (int i = 0; i < this.getnProps(); ++i) {
            PanelPropertyItem item = (PanelPropertyItem)this.items.get(i);
            if (item.equals(this.width) && Math.abs(this.getWidth() - rhs.getWidth()) > 3) {
                return false;
            }
            if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public PanelProperties copy() {
        PanelAccumulationRateProperties p = new PanelAccumulationRateProperties(null);
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelAccumulationRateProperties)) {
            throw new IllegalArgumentException("PanelAccumulationRateProperties cannot copy " + String.valueOf(pp));
        }
        PanelAccumulationRateProperties rhs = (PanelAccumulationRateProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this.getWidth());
        hash = 83 * hash + Objects.hashCode(this.getFillColour());
        hash = 83 * hash + Objects.hashCode(Float.valueOf(this.getAccumRateMax()));
        hash = 83 * hash + Objects.hashCode(this.showText());
        hash = 83 * hash + Objects.hashCode(this.useAutoAccumulationRate());
        hash = 83 * hash + Objects.hashCode((Object)this.getAccumRateUnits());
        hash = 83 * hash + Objects.hashCode((Object)this.getPlotStyle());
        return hash;
    }

    public static enum PlotStyle {
        SHADING("Use shading"),
        BARS_CENTRE("Bar chart (centre justified)"),
        BARS_LEFT("Bar chart (left justified)");

        private final String desc;

        private PlotStyle(String desc) {
            this.desc = desc;
        }

        public String toString() {
            return this.desc;
        }
    }

    public static enum AccumRateUnits {
        FEET("ft/Ma"),
        METERS("m/Ma");

        private final String desc;

        private AccumRateUnits(String desc) {
            this.desc = desc;
        }

        public String toString() {
            return this.desc;
        }
    }
}

