/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.geom.GeneralPath;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.SchemeBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelAgeCurveProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.SBPanel;
import model3.AgeCurve;

class PanelAgeCurve
extends SBPanel {
    private double hScale;
    private final SchemeBlock block;
    private PanelAgeCurveProperties p;
    private double scaleMin;
    private double scaleMax;

    public PanelAgeCurve(PanelTemplate template, SchemeBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelAgeCurveProperties)template.getProperties();
        this.initObservers();
    }

    public int getAgeCurveID() {
        return this.p.curve.getCurveID();
    }

    private void initObservers() {
        if (this.p.curve != null) {
            this.p.curve.addWeakObserver((Observer)this);
        }
    }

    @Override
    public void setProperties(PanelProperties pp) {
        if (!(pp instanceof PanelAgeCurveProperties)) {
            throw new IllegalArgumentException("PanelAgeCurve cannot set properties to: " + String.valueOf(pp));
        }
        this.p = (PanelAgeCurveProperties)pp;
        this.initObservers();
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (!g.isVisible(x, y + this.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight() + y + this.getPanelHeaderHeight(cp, mode))) {
            return x + this.getWidth(bp);
        }
        this.calcHScale(bp);
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                if (this.p.curve == null) break;
                this.drawCurve(g, x, y, cp, bp, mode);
            }
        }
        switch (mode) {
            case NORMAL: 
            case HEADER_ONLY: {
                g.setColor(cp.foreground);
                g.setFont(cp.font, 0, cp.getFontSizePanel());
                if (this.p.curve != null) {
                    g.drawString("(" + this.p.curve.getUnits() + ")", x, y + this.getPanelHeaderHeight(cp, mode) - cp.getFontSizePanel() * 2.0f, this.p.panelWidth, 0, true);
                } else {
                    System.out.println("p.curve null in PanelAgeCurve.draw");
                }
                float tinyFont = cp.getFontSizeSmall();
                g.setFont(cp.font, 0, tinyFont);
                String leftScale = this.trimDigits("" + (this.p.rightToLeft ? this.scaleMax : this.scaleMin));
                String rightScale = this.trimDigits("" + (this.p.rightToLeft ? this.scaleMin : this.scaleMax));
                g.drawString(leftScale, x + 0.5f, y + this.getPanelHeaderHeight(cp, mode) - tinyFont);
                g.drawString(rightScale, x + this.p.panelWidth - 0.5f - g.stringWidth(rightScale), y + this.getPanelHeaderHeight(cp, mode) - tinyFont);
                double scaleInc = 5.0 / this.hScale;
                int rounding = (int)Math.log10(this.scaleMax - this.scaleMin);
                if (rounding < 0) {
                    --rounding;
                }
                if ((scaleInc = (double)Math.round(scaleInc / Math.pow(10.0, rounding - 1)) * Math.pow(10.0, rounding - 1)) > 0.0) {
                    g.setStroke(0.2f);
                    for (double d = this.scaleMin + scaleInc; d < this.scaleMax; d += scaleInc) {
                        g.drawLine(x + this.scaleValue(d), y + this.getPanelHeaderHeight(cp, mode), x + this.scaleValue(d), y + this.getPanelHeaderHeight(cp, mode) - tinyFont * 0.7f);
                    }
                    break;
                }
                System.out.println("Age scale increment is zero!");
            }
        }
        return x + this.p.panelWidth;
    }

    private String trimDigits(String s) {
        while (s.contains(".") && (s.length() > 6 || s.endsWith("0"))) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Override
    protected String getCaption() {
        if (this.p.curve != null) {
            return this.p.curve.toString();
        }
        return "";
    }

    private void drawCurve(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        g.setColor(this.p.curve.getColour());
        g.setStroke(this.p.curve.getLineWidth());
        if (bp.getScaleType() == BlockProperties.ScaleType.AGE) {
            this.drawCurveAge(g, x, y + this.getPanelHeaderHeight(p, mode), bp);
        } else {
            this.drawCurveDepth(g, x, y + this.getPanelHeaderHeight(p, mode), bp);
        }
    }

    private void drawCurveAge(SBGraphics g, float x, float yTop, BlockProperties bp) {
        int size = this.p.curve.getTrace().size() + 10;
        boolean first = true;
        int i = 0;
        float[] xPoints = new float[size];
        float[] yPoints = new float[size];
        Iterator it = this.p.curve.getTrace().iterator();
        g.setClip(x, yTop, this.getProperties().panelWidth, bp.getHeight());
        while (it.hasNext()) {
            AgeCurve.AgeCurveValue value = (AgeCurve.AgeCurveValue)it.next();
            if (value.getAge() < (double)bp.getMin()) continue;
            if (value.getAge() > (double)bp.getMax()) break;
            float x1 = x + this.scaleValue(value.getValue());
            float y1 = this.block.getProp().scaleAge((float)value.getAge()) + yTop;
            if (first) {
                first = false;
                xPoints[i] = x + (this.p.rightToLeft ? this.getWidth(bp) : 0.0f);
                yPoints[i] = this.block.getProp().scaleAge((float)value.getAge()) + yTop;
                ++i;
            }
            xPoints[i] = x1;
            yPoints[i] = y1;
            ++i;
        }
        if (i > 0) {
            xPoints[i] = x + (this.p.rightToLeft ? this.getWidth(bp) : 0.0f);
            yPoints[i] = yPoints[i - 1];
            xPoints[++i] = xPoints[0];
            yPoints[i] = yPoints[0];
            GeneralPath gp = SBGraphics.createGeneralPath(xPoints[0], yPoints[0]);
            for (int j = 0; j < i - 2; ++j) {
                PanelAgeCurveProperties.Smoothing cfr_ignored_0 = this.p.smoothing;
                if (this.p.smoothing != PanelAgeCurveProperties.Smoothing.NONE) {
                    this.appendCurve(gp, xPoints[j], yPoints[j], xPoints[j + 1], yPoints[j + 1], xPoints[j + 2], yPoints[j + 2]);
                    continue;
                }
                SBGraphics.appendLine(gp, xPoints[j], yPoints[j]);
            }
            SBGraphics.appendLine(gp, xPoints[i - 1], yPoints[i - 1]);
            SBGraphics.appendLine(gp, xPoints[i], yPoints[i]);
            if (this.p.fill) {
                g.fillShape(gp, this.p.fillColour);
            }
            g.drawShape(gp);
        }
        g.clearClip();
    }

    private void appendCurve(GeneralPath gp, float x1, float y1, float x2, float y2, float x3, float y3) {
        float endX1 = x2 - (x2 - x1) / 2.0f * this.p.smoothing.level;
        float endY1 = y2 - (y2 - y1) / 2.0f * this.p.smoothing.level;
        float endX2 = x2 - (x2 - x3) / 2.0f * this.p.smoothing.level;
        float endY2 = y2 - (y2 - y3) / 2.0f * this.p.smoothing.level;
        SBGraphics.appendCurve(gp, endX1, endY1, x2, y2, endX2, endY2);
    }

    private void drawCurveDepth(SBGraphics g, float x, float yTop, BlockProperties bp) {
        if (this.block.getInterp() == null || this.block.getInterp().getLOC() == null) {
            return;
        }
        if (this.p.fill) assert (false);
        int n = this.p.curve.getTrace().size();
        double minDepth = Math.max(this.block.getInterp().getLOC().getMinDepth(), (double)bp.getMin());
        double increment = (Math.min((double)bp.getMax(), this.block.getInterp().getLOC().getMaxDepth()) - minDepth) / (double)n;
        double[] depths = new double[n];
        for (int i = 0; i < n; ++i) {
            depths[i] = minDepth + (double)i * increment;
        }
        Float lastX = null;
        Float lastY = null;
        g.setClip(x, yTop, this.getProperties().panelWidth, bp.getHeight());
        for (double depth : depths) {
            double age = this.block.getInterp().getLOC().getAge(depth, true);
            double value = this.p.curve.getValue(age);
            float x1 = x + this.scaleValue(value);
            float y1 = this.block.scale((float)depth, BlockProperties.ScaleType.MD) + yTop;
            if (lastX != null && lastY != null) {
                g.drawLine(x1, y1, lastX.floatValue(), lastY.floatValue());
            }
            lastX = Float.valueOf(x1);
            lastY = Float.valueOf(y1);
        }
        g.clearClip();
    }

    private void calcHScale(BlockProperties bp) {
        if (this.p.curve == null) {
            return;
        }
        if (this.p.autoHorizScale || this.p.min == this.p.max) {
            Double minRange = null;
            Double maxRange = null;
            if (bp != null) {
                minRange = bp.getMin();
                maxRange = bp.getMax();
            }
            Double min = this.p.curve.getMin(minRange, maxRange);
            Double max = this.p.curve.getMax(minRange, maxRange);
            if (min == null || max == null) {
                min = 0.0;
                max = 1.0;
            }
            double scaleInc = 5.0 / ((double)this.p.panelWidth / (max - min));
            int rounding = (int)Math.log10(max - min);
            if (rounding <= 0) {
                --rounding;
            }
            scaleInc = (double)Math.round(scaleInc / Math.pow(10.0, rounding - 1)) * Math.pow(10.0, rounding - 1);
            this.scaleMin = (double)Math.round((min - scaleInc) / Math.pow(10.0, rounding - 1)) * Math.pow(10.0, rounding - 1);
            this.scaleMax = (double)Math.round((max + scaleInc) / Math.pow(10.0, rounding - 1)) * Math.pow(10.0, rounding - 1);
        } else {
            this.scaleMin = this.p.min;
            this.scaleMax = this.p.max;
        }
        this.hScale = (double)this.p.panelWidth / (this.scaleMax - this.scaleMin);
    }

    private float scaleValue(double value) {
        double retval = value * this.hScale;
        retval = this.p.rightToLeft ? this.scaleMax * this.hScale - retval : (retval -= this.scaleMin * this.hScale);
        return (float)retval;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.panelWidth;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Age Curve";
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Age Curve";
    }

    public String toString() {
        if (this.p.curve != null) {
            return "Age Curve - " + this.p.curve.getTitle();
        }
        return "Age Curve - (no curve)";
    }

    @Override
    public float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        g.setColor(this.p.curve.getColour());
        g.setStroke(this.p.curve.getLineWidth());
        Iterator it = this.p.curve.getTrace().iterator();
        Float lastX = null;
        Float lastY = null;
        float headerHeight = 12.0f;
        g.setClip(x + headerHeight, y, PanelAgeCurve.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp) - headerHeight, this.p.panelWidth);
        while (it.hasNext()) {
            AgeCurve.AgeCurveValue value = (AgeCurve.AgeCurveValue)it.next();
            if (value.getAge() < (double)bp.getMin()) continue;
            if (value.getAge() > (double)bp.getMax()) break;
            float y1 = y + this.scaleValue(value.getValue());
            float x1 = x + PanelAgeCurve.getXPos((float)value.getAge(), bp);
            if (lastX != null && lastY != null) {
                g.drawLine(x1, y1, lastX.floatValue(), lastY.floatValue());
            }
            lastX = Float.valueOf(x1);
            lastY = Float.valueOf(y1);
        }
        g.setClip(null);
        g.setColor(cp.foreground);
        g.setStroke(0.2f);
        g.drawRect(x, y, PanelAgeCurve.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp), this.p.panelWidth);
        g.drawLine(x + headerHeight, y, x + headerHeight, y + this.p.panelWidth);
        g.setFont(cp.font, 1, cp.getFontSizePanel());
        g.drawStringVertical(this.p.curve.getTitle(), x + cp.getFontSizePanel(), y + this.p.panelWidth, this.p.panelWidth, false, true, true);
        g.setFont(cp.font, 0, cp.getFontSize());
        g.drawStringVertical("" + this.scaleMin, x + headerHeight - 2.0f, y + this.p.panelWidth - 0.5f, this.p.panelWidth, false, false, true);
        String max = "" + this.scaleMax;
        g.drawStringVertical(max, x + headerHeight - 2.0f, y + g.stringWidth(max) + 0.5f, this.p.panelWidth, false, false, true);
        g.setStroke(0.1f);
        for (double d = this.scaleMin + 50.0; d < this.scaleMax; d += 50.0) {
            g.drawLine(x + headerHeight, y + this.scaleValue(d), x + headerHeight - 1.0f, y + this.scaleValue(d));
        }
        return this.p.panelWidth;
    }

    @Override
    public PanelAgeCurveProperties getProperties() {
        return this.p;
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof AgeCurve) {
            if (obs == this.p.curve) {
                this.calcHScale(null);
            } else {
                ((AgeCurve)obs).deleteWeakObserver((Observer)this);
            }
            return;
        }
        super.update(obs, arg);
    }
}

