/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.sql.SQLException;
import java.util.List;
import jsbchart.block.WellBlock;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelZones;
import jsbchart.panel.SBPanel;
import model3.IGDColMap;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.WellInterp;
import util.SBException;

public class PanelBiozones
extends PanelZones {
    public PanelBiozones(PanelTemplate template, PanelOcc occ, WellBlock block) throws SQLException, SBException {
        super(template, occ, block);
    }

    @Override
    public String toString() {
        Object string = IGDInterval.getIGDName((int)this.getIGDType());
        String interpString = this.getInterpString();
        string = (String)string + (String)(interpString != null ? " : " + interpString : "");
        try {
            IGDScheme scheme;
            int schID = this.getSchID();
            String schemeString = schID > 0 ? ((scheme = this.getDb().getIGDScheme(schID)) != null ? this.getDb().getIGDScheme(schID).getName() : "Hidden Scheme") : this.getProperties().getDisc().getAbr(true);
            string = (String)string + " : " + schemeString;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return string;
    }

    @Override
    List<IGDIntervalZone> getIGDList() throws SBException, SQLException {
        WellInterp wellInterp = this.getBlock().getWell().getInterp(this.getInterpID(this.getBlock()));
        if (wellInterp == null) {
            throw new SBException("Well interp null in PanelBiozones");
        }
        return wellInterp.getBiozones(this.getSchID(), this.getProperties().getDisc());
    }

    @Override
    List<IGDIntervalZone> getIGDList(int column) throws SBException, SQLException {
        IGDColMap colmap;
        WellInterp wellInterp = this.getBlock().getWell().getInterp(this.getInterpID(this.getBlock()));
        if (wellInterp == null) {
            throw new SBException("Well interp null in PanelZones");
        }
        SBPanel underplotPanel = this.getUnderplotPanel();
        if (underplotPanel != null && PanelType.isBiozonePanel(underplotPanel.getPanelType())) {
            WellInterp underplotWellInterp = this.getBlock().getWell().getInterp(underplotPanel.getInterpID(this.getBlock()));
            colmap = underplotWellInterp.getColMap(this.getBlock().getWellID(), this.getIGDType());
        } else {
            colmap = wellInterp.getColMap(this.getBlock().getWell().getWellID(), this.getIGDType());
        }
        if (colmap != null) {
            return wellInterp.getBiozones(this.getSchID(), this.getProperties().getDisc(), colmap.getMinhier(column), colmap.getMaxhier(column));
        }
        throw new SBException("Colmap is null in PanelBiozones");
    }

    @Override
    IGDColMap getColMap() throws SBException, SQLException {
        SBPanel underplotPanel = this.getUnderplotPanel();
        if (underplotPanel != null && PanelType.isBiozonePanel(underplotPanel.getPanelType())) {
            WellInterp underplotWellInterp = this.getBlock().getWell().getInterp(underplotPanel.getInterpID(this.getBlock()));
            return underplotWellInterp.getColMap(this.getBlock().getWellID(), this.getIGDType());
        }
        return this.getBlock().getWell().getInterp(this.getInterpID(this.getBlock())).getColMap(this.getBlock().getWell().getWellID(), this.getIGDType());
    }

    @Override
    protected String getDefaultPanelCaption() throws SQLException {
        return this.getPanelTitle();
    }

    String getPanelTitle() throws SQLException {
        IGDScheme scheme;
        String schemeString = this.getSchID() > 0 ? ((scheme = this.getDb().getIGDScheme(this.getSchID())) != null ? this.getDb().getIGDScheme(this.getSchID()).getName() : "Hidden Scheme") : this.getProperties().getDisc().getAbr(true);
        return "Biozones: " + schemeString;
    }

    @Override
    public int getSchID() {
        return this.getPanelOcc().getSchID();
    }
}

