/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;

class PanelBlankProperties
extends PanelProperties {
    private static final int PROP_WIDTH = 0;
    private static final int PROP_BORDER = 1;
    private static final String[] PROP_NAMES = new String[]{"Width", "Border"};
    float width = 10.0f;
    boolean border = false;

    PanelBlankProperties(String props) {
        super(PanelType.BLANK);
        if (props == null || props.isEmpty()) {
            return;
        }
        String[] split = props.split("\\|");
        block4: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    this.width = Float.parseFloat(split[i]);
                    continue block4;
                }
                case 1: {
                    this.border = Integer.parseInt(split[i]) == 1;
                }
            }
        }
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[PROP_NAMES.length];
        props[0] = "" + this.width;
        props[1] = "" + (this.border ? 1 : 0);
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.width;
            }
            case 1: {
                return this.border;
            }
        }
        return null;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (prop != this.getProperty(nProp)) {
            switch (nProp) {
                case 0: {
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 1: {
                    this.border = (Boolean)prop;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth >= 1.0f && Math.abs((int)this.width - (int)panelWidth) >= 1) {
            this.width = panelWidth;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
        }
        return Boolean.class;
    }

    private static PanelBlankProperties createCopy(PanelBlankProperties rhs) {
        PanelBlankProperties p = new PanelBlankProperties(null);
        p.copy(rhs);
        return p;
    }

    @Override
    public PanelProperties copy() {
        return PanelBlankProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelBlankProperties)) {
            throw new IllegalArgumentException("PanelBlankProperties cannot copy " + String.valueOf(pp));
        }
        PanelBlankProperties rhs = (PanelBlankProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Float.floatToIntBits(this.width);
        hash = 53 * hash + (this.border ? 1 : 0);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelBlankProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelBlankProperties rhs = (PanelBlankProperties)comp;
        block3: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.width - rhs.width) > 3.0f)) continue block3;
                    return false;
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block3;
                    return false;
                }
            }
        }
        return true;
    }
}

