/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.image.ImageRecord;
import java.awt.Image;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelCoreImagesProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import jsbchart.util.ChartImage;
import jsbchart.util.ImageFit;
import model3.CoreImage;
import model3.SBdb;
import model3.Well;
import model3.WsWell;
import util.DepthUtils;
import util.ImageUtils;
import util.SB;
import util.SBException;

class PanelCoreImages
extends SBPanel
implements Observer {
    private PanelCoreImagesProperties p;
    private final WellBlock block;
    private LinkedList<ChartImage> images;
    private static Logger log = Logger.getLogger(PanelCoreImages.class.getName());

    public PanelCoreImages(PanelTemplate template, WellBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.COREIMAGES);
        this.block = block;
        this.p = (PanelCoreImagesProperties)template.getProperties();
        this.init();
    }

    private void init() {
        if (this.block.getWell() != null) {
            this.block.getWell().addWeakObserver((Observer)this);
        }
    }

    @Override
    protected String getCaption() {
        return "Core Images";
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    @Override
    public PanelCoreImagesProperties getProperties() {
        return this.p;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelCoreImagesProperties)) {
            throw new IllegalArgumentException("Attempt to set panel core images properties to " + String.valueOf(prop));
        }
        this.p = (PanelCoreImagesProperties)prop;
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (!g.isVisible(x, y, this.getWidth(bp), y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(bp.getMax()))) {
            return x + this.getWidth(bp);
        }
        g.setColor(this.p.backColour);
        try {
            float baseDepth;
            float topDepth;
            float internalPanelTop = y + this.getPanelHeaderHeight(cp, mode);
            if (bp == this.block.getProp()) {
                topDepth = this.block.getTopDepth();
                baseDepth = this.block.getBaseDepth();
            } else {
                topDepth = bp.getMin();
                baseDepth = bp.getMax();
            }
            for (ChartImage pi : this.images) {
                if (pi.getDepth() < (double)topDepth && pi.getDepth() > (double)baseDepth) continue;
                float top = y + this.getPanelHeaderHeight(cp, mode) + pi.getOrigTop();
                double coreBase = ((CoreImage)pi.getObject()).getBaseDepth();
                float imageBaseDepth = this.block.scaleDepth((float)(cp.correctDepths ? this.block.getWell().getCorrectedDepth(coreBase) : coreBase));
                float base = y + this.getPanelHeaderHeight(cp, mode) + Math.min(this.block.getHeight(), imageBaseDepth);
                g.fillRect(x, top, this.p.width, base - top);
                float xpos = x;
                float ypos = top;
                boolean clipSet = false;
                switch (this.p.fit) {
                    case WIDTH: {
                        if (!(pi.getHeight() > base - top) || !this.p.crop) break;
                        g.setClip(x, top, this.p.width, base - top);
                        clipSet = true;
                        break;
                    }
                    case HEIGHT: {
                        if (!(pi.getWidth() > this.p.width)) break;
                        g.setClip(x, top, this.p.width, pi.getHeight());
                        clipSet = true;
                        xpos -= (pi.getWidth() - this.p.width) / 2.0f;
                        break;
                    }
                }
                g.drawImage(pi.getImage(), xpos, ypos, pi.getWidth(), pi.getHeight());
                if (!clipSet) continue;
                g.setClip(null);
            }
        }
        catch (Exception ex) {
            this.handleException(g, x, y, cp, bp, ex);
            ex.printStackTrace();
        }
        return x + this.getWidth(bp);
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException, IOException {
        this.images = new LinkedList();
        if (this.block.getWell() == null) {
            return;
        }
        float blockTopDepth = this.block.getTopDepth();
        float blockBaseDepth = this.block.getBaseDepth();
        ChartImage pi = null;
        for (CoreImage img : this.block.getWell().getCoreImages()) {
            double topDepth = img.getTopDepth();
            double baseDepth = img.getBaseDepth();
            if (cp != null && cp.correctDepths) {
                topDepth = this.block.getWell().getCorrectedDepth(topDepth);
                baseDepth = this.block.getWell().getCorrectedDepth(baseDepth);
            }
            float imgTopDepth = (float)topDepth;
            float imgBaseDepth = (float)baseDepth;
            if (imgBaseDepth < blockTopDepth || imgTopDepth > blockBaseDepth) continue;
            switch (this.p.fit) {
                case WIDTH: {
                    pi = this.buildWidthChartImage(cp, img, blockTopDepth, blockBaseDepth);
                    break;
                }
                case HEIGHT: {
                    pi = this.buildHeightChartImage(cp, img, blockTopDepth, blockBaseDepth);
                    break;
                }
                default: {
                    pi = this.buildSpaceChartImage(cp, img, blockTopDepth, blockBaseDepth);
                }
            }
            if (pi == null) continue;
            pi.setDepth(imgTopDepth);
            pi.setObject(img);
            this.images.add(pi);
        }
    }

    private ChartImage buildWidthChartImage(ChartProperties cp, CoreImage img, float blockTopDepth, float blockBaseDepth) throws SQLException, SBException, IOException {
        double t = img.getTopDepth();
        double b = img.getBaseDepth();
        if (cp.correctDepths) {
            t = this.block.getWell().getCorrectedDepth(t);
            b = this.block.getWell().getCorrectedDepth(b);
        }
        float imgTopDepth = (float)t;
        float imgBaseDepth = (float)b;
        ImageRecord imageRecord = this.block.getDb().getImageRecordService().getImageRecord(img.getImageID());
        ImageIcon icon = new ImageIcon(this.block.getDb().getImageLoader().getImage(imageRecord));
        if (icon == null) {
            log.log(Level.WARNING, "Core image icon not found, pic path = {0}", imageRecord.picPath());
            return null;
        }
        float imgHeight = icon.getIconHeight();
        float imgWidth = icon.getIconWidth();
        if (imgTopDepth < blockTopDepth) {
            imgTopDepth = blockTopDepth;
        }
        float top = this.block.scaleDepth(imgTopDepth);
        float base = this.block.scaleDepth(imgBaseDepth);
        if (imgWidth > this.p.width) {
            imgHeight /= imgWidth / this.p.width;
            imgWidth = this.p.width;
            if (imgHeight > base - top && !this.p.crop) {
                imgHeight /= imgWidth / (imgWidth - 5.0f);
                imgWidth -= 5.0f;
            }
        }
        if (top + imgHeight > this.block.getHeight()) {
            int overlap = Math.round(top + imgHeight - this.block.getHeight());
            float proportion = (float)overlap / imgHeight;
            Image i = icon.getImage();
            i = ImageUtils.cropImage((Image)i, (int)0, (int)0, (int)i.getWidth(null), (int)Math.round((float)i.getHeight(null) * proportion));
            icon = new ImageIcon(i);
            imgHeight = this.block.getHeight() - top;
        }
        return new ChartImage(icon, top, imgWidth, imgHeight);
    }

    private ChartImage buildHeightChartImage(ChartProperties cp, CoreImage img, float blockTopDepth, float blockBaseDepth) throws SQLException, SBException, IOException {
        float portion;
        double t = img.getTopDepth();
        double b = img.getBaseDepth();
        if (cp != null && cp.correctDepths) {
            t = this.block.getWell().getCorrectedDepth(t);
            b = this.block.getWell().getCorrectedDepth(b);
        }
        float imgTopDepth = (float)t;
        float imgBaseDepth = (float)b;
        ImageRecord imageRecord = this.block.getDb().getImageRecordService().getImageRecord(img.getImageID());
        ImageIcon icon = new ImageIcon(this.block.getDb().getImageLoader().getImage(imageRecord));
        float imgHeight = icon.getIconHeight();
        float imgWidth = icon.getIconWidth();
        float top = this.block.scaleDepth(imgTopDepth);
        float base = this.block.scaleDepth(imgBaseDepth);
        float scale = (base - top) / imgHeight;
        imgWidth = scale * imgWidth;
        int imageHeightPx = icon.getImage().getHeight(null);
        float imageHeightOnChart = base - top;
        int removePxTop = 0;
        int removePxBase = 0;
        if (top < 0.0f) {
            portion = Math.abs(top) / imageHeightOnChart;
            removePxTop = Math.round(portion * (float)imageHeightPx);
            top = 0.0f;
        }
        if (base > this.block.getHeight()) {
            portion = (base - this.block.getHeight()) / imageHeightOnChart;
            removePxBase = Math.round(portion * (float)imageHeightPx);
            base = this.block.getHeight();
        }
        if (removePxTop > 0 || removePxBase > 0) {
            Image i = icon.getImage();
            i = ImageUtils.cropImage((Image)i, (int)0, (int)removePxTop, (int)i.getWidth(null), (int)(imageHeightPx - removePxTop - removePxBase));
            icon = new ImageIcon(i);
        }
        imgHeight = base - top;
        return new ChartImage(icon, top, imgWidth, imgHeight);
    }

    private ChartImage buildSpaceChartImage(ChartProperties cp, CoreImage img, float blockTopDepth, float blockBaseDepth) throws SQLException, SBException, IOException {
        double t = img.getTopDepth();
        double b = img.getBaseDepth();
        if (cp.correctDepths) {
            t = this.block.getWell().getCorrectedDepth(t);
            b = this.block.getWell().getCorrectedDepth(b);
        }
        float imgTopDepth = (float)t;
        float imgBaseDepth = (float)b;
        ImageRecord imageRecord = this.block.getDb().getImageRecordService().getImageRecord(img.getImageID());
        ImageIcon icon = new ImageIcon(this.block.getDb().getImageLoader().getImage(imageRecord));
        float imgHeight = icon.getIconHeight();
        float imgWidth = icon.getIconWidth();
        if (imgTopDepth < blockTopDepth) {
            imgTopDepth = blockTopDepth;
        }
        float top = this.block.scaleDepth(imgTopDepth);
        float base = this.block.scaleDepth(imgBaseDepth);
        if (imgHeight > base - top) {
            imgWidth /= imgHeight / (base - top);
            imgHeight = base - top;
        }
        if (imgWidth > this.p.width) {
            imgHeight /= imgWidth / this.p.width;
            imgWidth = this.p.width;
        }
        return new ChartImage(icon, top, imgWidth, imgHeight);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y);
        ListIterator<ChartImage> it = this.images.listIterator(this.images.size());
        block3: while (it.hasPrevious()) {
            ChartImage pi = it.previous();
            CoreImage ci = (CoreImage)pi.getObject();
            switch (this.p.fit) {
                case WIDTH: {
                    if (!(this.p.crop ? (double)depth >= ci.getTopDepth() && (double)depth < ci.getBaseDepth() : y >= pi.getOrigTop() && y < pi.getOrigTop() + pi.getHeight())) continue block3;
                    return pi;
                }
            }
            if (!((double)depth >= ci.getTopDepth()) || !((double)depth < ci.getBaseDepth())) continue;
            return pi;
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null && this.block.getWell() != null) {
            ChartImage pi = (ChartImage)o;
            CoreImage ci = (CoreImage)pi.getObject();
            float depth = this.block.getDepth(y);
            String s = SB.floatString((double)DepthUtils.convFromM((double)ci.getTopDepth(), (char)this.block.getProp().getUnits()), (int)2) + " - " + SB.floatString((double)DepthUtils.convFromM((double)ci.getBaseDepth(), (char)this.block.getProp().getUnits()), (int)2);
            if (this.p.fit == ImageFit.WIDTH) {
                depth = this.block.getDepth(pi.getOrigTop() + (this.block.scaleDepth((float)ci.getBaseDepth()) - pi.getOrigTop()) * ((y - pi.getOrigTop()) / pi.getHeight()));
            }
            if (!this.block.getWell().getCoreNumber((double)depth).isEmpty()) {
                s = s + " (" + this.block.getWell().getCoreNumber((double)depth) + ")";
            }
            String depthString = SB.getDepthString((double)depth, (char)this.block.getProp().getUnits(), (int)2);
            return depthString + "  Core Image: " + s;
        }
        return null;
    }

    public String toString() {
        return "Core Images";
    }

    public PanelCoreImagesProperties getProps() {
        return this.p;
    }

    public void setProperties(PanelCoreImagesProperties p) {
        this.p = p;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well) {
            if (o == this.block.getWell()) {
                if (arg instanceof CoreImage || arg == CoreImage.class) {
                    this.setDataChanged();
                    this.notifyListeners();
                    return;
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        if (this.images == null || this.images.isEmpty()) {
            return;
        }
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        ArrayList<CoreImage> toFill = new ArrayList<CoreImage>();
        for (ChartImage image : this.images) {
            toFill.add((CoreImage)image.getObject());
        }
        wsWell.fillCores(null, toFill, false);
        dataTypes.add(19);
    }
}

