/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.CoreShift;
import com.stratadata.model3.well.CoreShiftDepth;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelCoresProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import model3.Audit;
import model3.CoredInterval;
import model3.Cores;
import model3.SBdb;
import model3.Well;
import model3.WsWell;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;

class PanelCores
extends SBPanel {
    private final WellBlock block;
    private PanelCoresProperties p;

    PanelCores(PanelTemplate template, WellBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.CORES);
        this.block = block;
        this.p = (PanelCoresProperties)template.getProperties();
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.getProp() || (double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, (firstOrOnly ? 0.0f : this.block.scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax())) + y, this.getWidth(bp), bp.getHeight() + this.getPanelHeaderHeight(cp, mode))) {
            return x + this.getWidth(bp);
        }
        try {
            float baseDepth;
            float topDepth;
            this.drawSeaBed(g, cp, bp, this.block, this.block.getScaleConverter(), x, y + this.getPanelHeaderHeight(cp, mode));
            Cores cores = this.block.getWell() != null ? this.block.getWell().getCores() : PanelCores.getTemplateCores(this.block);
            g.setColor(cp.foreground);
            g.setStroke(0.1f);
            g.setFont(cp.font, 0, cp.getFontSize());
            float internalPanelTop = y + (firstOrOnly ? this.getPanelHeaderHeight(cp, mode) : 0.0f);
            if (bp == this.block.getProp()) {
                topDepth = this.block.getTopDepth();
                baseDepth = this.block.getBaseDepth();
            } else {
                topDepth = bp.getMin();
                baseDepth = bp.getMax();
            }
            for (CoredInterval core : cores.getList()) {
                double topUnshifted = core.getTopDepth();
                double baseUnshifted = core.getBaseDepth();
                double topShifted = topUnshifted;
                double baseShifted = baseUnshifted;
                if (cp.correctDepths || this.p.alwaysShowShifts) {
                    if (this.block.getWell() != null) {
                        topShifted = this.block.getWell().getCorrectedDepth(topUnshifted);
                        baseShifted = this.block.getWell().getCorrectedDepth(baseUnshifted);
                    } else {
                        topShifted = topUnshifted + 2.0;
                        baseShifted = baseUnshifted + 2.0;
                    }
                }
                if (topShifted < (double)topDepth && topUnshifted < (double)topDepth && baseShifted < (double)topDepth && baseUnshifted < (double)topDepth || topShifted > (double)baseDepth && topUnshifted > (double)baseDepth && baseShifted > (double)baseDepth && baseUnshifted > (double)baseDepth) continue;
                if (topShifted < (double)topDepth) {
                    topShifted = topDepth;
                    if (topUnshifted < (double)topDepth) {
                        topUnshifted = topDepth;
                    }
                }
                if (baseShifted > (double)baseDepth) {
                    baseShifted = baseDepth;
                    if (baseUnshifted > (double)baseDepth) {
                        baseUnshifted = baseDepth;
                    }
                }
                float yTop = this.block.scaleDepth((float)topShifted) + internalPanelTop;
                float yBase = this.block.scaleDepth((float)baseShifted) + internalPanelTop;
                if (core.getRecovered()) {
                    g.drawRect(x, yTop, this.p.width, yBase - yTop);
                    g.fillRect(x, yTop, this.p.width / 3.0f, yBase - yTop, cp.foreground);
                    g.fillRect(x + this.p.width - this.p.width / 3.0f, yTop, this.p.width / 3.0f, yBase - yTop, cp.foreground);
                } else {
                    g.fillRect(x, yTop, this.p.width, yBase - yTop, Color.LIGHT_GRAY);
                }
                if (!core.getCorenum().isEmpty()) {
                    g.drawString(core.getCorenum(), x + this.p.width / 3.0f, yTop + (yBase - yTop) / 2.0f + g.stringHeightSB() / 2.0f, this.p.width / 3.0f, 0, true);
                }
                if (this.p.depths) {
                    g.setFont(cp.font, 0, cp.getFontSizeSmall());
                    if (this.p.coreShiftColumn.show()) {
                        float tick = this.p.coreShiftColumn.width() / 20.0f;
                        g.drawLine(x + this.p.width, yTop, x + this.p.width + tick, yTop);
                        g.drawString(this.getBoundaryLabel(this.block.getProp(), topUnshifted, 3, true), x + this.p.width + tick * 3.0f / 2.0f, yBase - yTop > 2.0f * g.stringHeightSB() ? yTop + g.stringHeightSB() : (yTop + yBase) / 2.0f - 0.2f, this.p.coreShiftColumn.width() - tick * 3.0f / 2.0f, 1, true);
                        g.drawLine(x + this.p.width, yBase, x + this.p.width + tick, yBase);
                        g.drawString(this.getBoundaryLabel(this.block.getProp(), baseUnshifted, 3, true), x + this.p.width + tick * 3.0f / 2.0f, yBase - yTop > 2.0f * g.stringHeightSB() ? yBase : (yBase + yTop) / 2.0f + g.stringHeightSB() + 0.2f, this.p.coreShiftColumn.width() - tick * 3.0f / 2.0f, 1, true);
                    } else {
                        float margin = this.p.width / 25.0f;
                        if (yTop - g.stringHeightSB() > internalPanelTop) {
                            g.drawString(this.getBoundaryLabel(this.block.getProp(), topUnshifted, 3, true), x + margin, yTop - margin / 3.0f, this.p.width, 1, true);
                        }
                        if (yBase + g.stringHeightSB() < internalPanelTop + this.block.scaleDepth(baseDepth)) {
                            g.drawString(this.getBoundaryLabel(this.block.getProp(), baseUnshifted, 3, true), x + this.p.width - margin, yBase + g.stringHeightSB() + margin / 3.0f, this.p.width, 2, true);
                        }
                    }
                    g.setFont(cp.font, 0, cp.getFontSize());
                }
                if (!(Math.abs(topShifted - topUnshifted) > 0.1) && !(Math.abs(baseShifted - baseUnshifted) > 0.1)) continue;
                yTop = this.block.scaleDepth((float)topUnshifted) + internalPanelTop;
                yBase = this.block.scaleDepth((float)baseUnshifted) + internalPanelTop;
                g.setColor(cp.background);
                g.drawRect(x, yTop, this.p.width / 3.0f, yBase - yTop);
                g.drawRect(x + this.p.width - this.p.width / 3.0f, yTop, this.p.width / 3.0f, yBase - yTop);
                g.setColor(cp.foreground);
                g.setDashStroke(0.2f);
                g.drawRect(x, yTop, this.p.width / 3.0f, yBase - yTop);
                g.drawRect(x + this.p.width - this.p.width / 3.0f, yTop, this.p.width / 3.0f, yBase - yTop);
                g.setStroke(0.1f);
            }
            switch (mode) {
                case NORMAL: 
                case HEADER_ONLY: {
                    if (bp != this.block.getProp()) break;
                    this.drawSubHeader(g, x, x + this.p.width, y, cp, bp, "Cored Intervals");
                    break;
                }
            }
            if (this.p.coreShiftColumn.show()) {
                g.setStroke(0.2f);
                g.drawLine(x + this.p.width, y + cp.panelCaptionHeight, x + this.p.width, internalPanelTop + bp.getHeight());
                this.drawShiftCol(g, x + this.p.width, y, cp, bp, mode, topDepth, baseDepth);
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sqle) {
            StackError.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        return x + this.getWidth(bp);
    }

    private void drawShiftCol(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, float topDepth, float baseDepth) throws SQLException, SBException {
        CoreShift coreShift = this.block.getWell() != null ? this.block.getWell().getCoreShiftObj() : PanelCores.getTemplateCoreShift();
        double min = Math.floor(coreShift.getMinShift());
        if (Math.abs(min - (double)coreShift.getMinShift()) < 1.0) {
            min -= 1.0;
        }
        double max = Math.floor(coreShift.getMaxShift()) + 1.0;
        assert (max > min);
        double scale = (double)this.p.coreShiftColumn.width() / (max - min);
        Point2D.Float[] points = new Point2D.Float[coreShift.size()];
        for (int i = 0; i < coreShift.size(); ++i) {
            CoreShiftDepth csd = coreShift.get(i);
            float yPos = this.block.scaleDepth((float)csd.getDepth());
            float shift = csd.getShift();
            if (csd.getDepth() < (double)topDepth) {
                shift = (float)coreShift.getShift((double)topDepth);
                yPos = this.block.scaleDepth(topDepth);
            } else if (csd.getDepth() > (double)baseDepth) {
                yPos = this.block.scaleDepth(baseDepth);
                shift = (float)coreShift.getShift((double)baseDepth);
            }
            float xPos = x + (float)((double)shift * scale + (0.0 - min) * scale);
            points[i] = new Point2D.Float(xPos, yPos);
            if (!(csd.getDepth() > (double)baseDepth)) continue;
            points = Arrays.copyOf(points, i + 1);
            break;
        }
        if (min < 0.0 && max > 0.0) {
            g.setColor(Color.LIGHT_GRAY);
            g.setDotStroke(0.3f);
            float xPos = x + (float)(-min * scale);
            g.drawLine(xPos, y + cp.getPanelHeaderHeight(), xPos, y + cp.getPanelHeaderHeight() + this.getBlock().getHeight());
        }
        if (points.length > 0) {
            try {
                GeneralPath gp = SBGraphics.createGeneralPath(points[0].x, this.block.scaleDepth(topDepth) + y + this.getPanelHeaderHeight(cp, mode));
                int lastPoint = -1;
                for (Point2D.Float point : points) {
                    if (point == null) continue;
                    SBGraphics.appendLine(gp, point.x, point.y + y + this.getPanelHeaderHeight(cp, mode));
                    ++lastPoint;
                }
                if (lastPoint > -1 && points[lastPoint] != null) {
                    SBGraphics.appendLine(gp, points[points.length - 1].x, this.block.scaleDepth(baseDepth) + y + this.getPanelHeaderHeight(cp, mode));
                }
                g.setStroke(0.3f);
                g.setColor(Color.LIGHT_GRAY);
                g.drawShape(gp);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
        if (mode != Chart.Mode.NO_HEADER && (bp == this.block.getProp() || (double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01)) {
            float hdrYpos = y + cp.getPanelHeaderHeight() - 10.0f;
            g.drawLine(x, hdrYpos, x + this.p.coreShiftColumn.width(), hdrYpos);
            g.setFont(cp.font, 1, cp.getFontSize());
            g.setColor(cp.foreground);
            float fontTiny = cp.getFontSizeSmall();
            g.drawString("Core Shift", x, hdrYpos - fontTiny * 1.75f, this.p.coreShiftColumn.width(), 0, true);
            g.setFont(cp.font, 0, fontTiny);
            char units = this.block.getWell() != null ? (char)this.block.getWell().getWellUnits() : (char)'M';
            g.drawString(units == 'M' ? "(m)" : "(ft)", x, hdrYpos - fontTiny / 2.0f, this.p.coreShiftColumn.width(), 0, true);
            g.drawString(SB.floatString((double)DepthUtils.convFromM((double)min, (char)units), (int)0).trim(), x + 0.8f, hdrYpos - fontTiny / 2.0f);
            String maxstrg = SB.floatString((double)DepthUtils.convFromM((double)max, (char)units), (int)0);
            g.drawString(maxstrg, x + this.p.coreShiftColumn.width() - g.stringWidth(maxstrg) - 0.8f, hdrYpos - fontTiny / 2.0f);
        }
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.width + (this.p.coreShiftColumn.show() ? this.p.coreShiftColumn.width() : 0.0f);
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y, bp);
        try {
            if (this.block.getWell() != null) {
                Cores cores = this.block.getWell().getCores();
                for (CoredInterval core : cores.getList()) {
                    double topShifted = this.block.getWell().getCorrectedDepth(core.getTopDepth());
                    double baseShifted = this.block.getWell().getCorrectedDepth(core.getBaseDepth());
                    if (!((double)depth >= topShifted) || !((double)depth <= baseShifted)) continue;
                    return core;
                }
            }
        }
        catch (SQLException sqle) {
            StackError.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o;
        if (this.p.coreShiftColumn.show()) {
            try {
                float depth = this.block.getDepth(y, bp);
                String strg = "Coreshift at " + SB.round((double)DepthUtils.convFromM((float)depth, (char)this.block.getProp().getUnits()), (int)2) + (this.block.getProp().getUnits() == 'M' ? "m" : "ft") + ": ";
                CoreShift coreShift = this.block.getWell() != null ? this.block.getWell().getCoreShiftObj() : PanelCores.getTemplateCoreShift();
                if (coreShift.size() == 0) {
                    return "";
                }
                double shift = coreShift.getShift((double)depth);
                return strg + (shift > 0.0 ? "+" : "") + SB.roundToSignificantFigures((double)DepthUtils.convFromM((double)shift, (char)this.block.getProp().getUnits()), (int)4);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((o = this.getObject(x, y, cp, bp, zoom)) != null) {
            if (o instanceof CoredInterval) {
                CoredInterval core = (CoredInterval)o;
                return core.toString() + " (" + SB.getDepthString((double)core.getTopDepth(), (char)this.block.getProp().getUnits(), (int)2) + " - " + SB.getDepthString((double)core.getBaseDepth(), (char)this.block.getProp().getUnits(), (int)2) + ")";
            }
            return o.toString();
        }
        return "Cored Intervals" + (this.p.coreShiftColumn.show() ? " and shifts" : "");
    }

    public String toString() {
        return "Cores";
    }

    @Override
    protected String getCaption() {
        return "Cores";
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    @Override
    public PanelCoresProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelCoresProperties)) {
            throw new IllegalArgumentException("Attempt to set panel cores properties to " + String.valueOf(prop));
        }
        this.p = (PanelCoresProperties)prop;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well) {
            if (o == this.block.getWell()) {
                if (arg instanceof Cores || arg == Cores.class || arg instanceof CoredInterval || arg == CoredInterval.class) {
                    this.setDataChanged();
                    this.notifyListeners();
                    return;
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.block.getWell() != null) {
            try {
                for (CoredInterval c : this.block.getWell().getCores().getList()) {
                    if (!(c.getBaseDepth() >= (double)this.block.getTopDepth()) || !(c.getTopDepth() <= (double)this.block.getBaseDepth())) continue;
                    return true;
                }
                return false;
            }
            catch (SQLException | SBException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.block.getWell() != null) {
            try {
                List list = this.block.getWell().getCores().getList();
                if (list.isEmpty()) {
                    return null;
                }
                return Float.valueOf((float)this.block.getWell().getCorrectedDepth(upper ? ((CoredInterval)list.get(0)).getTopDepth() : ((CoredInterval)list.get(list.size() - 1)).getBaseDepth()));
            }
            catch (SQLException | SBException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static Cores getTemplateCores(WellBlock block) throws SBException {
        Cores cores = new Cores(null);
        cores.add(new CoredInterval(30.0, 40.0, "1", true, new Audit()));
        cores.add(new CoredInterval(50.0, 60.0, "2", true, new Audit()));
        cores.add(new CoredInterval(62.0, 68.0, "3", false, new Audit()));
        return cores;
    }

    private static CoreShift getTemplateCoreShift() throws SBException, SQLException {
        CoreShift coreshift = new CoreShift();
        coreshift.add(new CoreShiftDepth(30.0, 2.1f));
        coreshift.add(new CoreShiftDepth(35.0, 1.9f));
        coreshift.add(new CoreShiftDepth(40.0, 2.3f));
        coreshift.add(new CoreShiftDepth(50.0, 1.7f));
        coreshift.add(new CoreShiftDepth(50.0, 1.0f));
        return coreshift;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        ArrayList<CoredInterval> toFill = new ArrayList<CoredInterval>();
        float topDepth = this.block.getTopDepth();
        float baseDepth = this.block.getBaseDepth();
        for (CoredInterval core : this.block.getWell().getCores().getList()) {
            double topUnshifted = core.getTopDepth();
            double baseUnshifted = core.getBaseDepth();
            double topShifted = this.block.getWell().getCorrectedDepth(topUnshifted);
            double baseShifted = this.block.getWell().getCorrectedDepth(baseUnshifted);
            if (topShifted < (double)topDepth && topUnshifted < (double)topDepth && baseShifted < (double)topDepth && baseUnshifted < (double)topDepth || topShifted > (double)baseDepth && topUnshifted > (double)baseDepth && baseShifted > (double)baseDepth && baseUnshifted > (double)baseDepth) continue;
            toFill.add(core);
        }
        if (!toFill.isEmpty()) {
            wsWell.fillCores(toFill, null, this.p.coreShiftColumn.show());
            dataTypes.add(19);
        }
    }
}

