/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.EnvScheme;
import util.ColourUtils;

public class PanelEnvProperties
extends PanelProperties {
    float columnWidth = 8.0f;
    boolean drawIntervals = true;
    boolean drawAllClasses = true;
    boolean drawIPSBathy = false;
    boolean drawAnalyses = false;
    float analyWidth = 1.5f;
    Color analyColour = Color.BLUE;
    private List<String> analysts = null;
    boolean stackColumns = false;
    boolean drawQualifiers = true;
    PanelProperties.ColumnWidth commentsCol = new PanelProperties.ColumnWidth(DEFAULT_COMMENT_WIDTH, false);
    EnvScheme scheme;
    private static float DEFAULT_COMMENT_WIDTH = 30.0f;
    private static final int PROP_SCH = 0;
    private static final int PROP_COLWIDTH = 1;
    private static final int PROP_INTERVALS = 2;
    private static final int PROP_ALLCLASSES = 3;
    private static final int PROP_ANALYSES = 4;
    private static final int PROP_ANALYWEIGHT = 5;
    private static final int PROP_ANALYCOLOUR = 6;
    private static final int PROP_ANALYSTS = 7;
    private static final int PROP_IPS = 8;
    private static final int PROP_STACK = 9;
    private static final int PROP_QUAL = 10;
    private static final int PROP_COMMENTS = 11;
    private static final String[] PROP_NAMES = new String[]{"Scheme", "Column width", "Intervals", "All classes", "Analyses", "Analysis weight", "Analysis colour", "Analyses by", "Palaeobathymetry from IPS", "Single column only", "Draw qualifiers", "Comments"};

    PanelEnvProperties(String prefs, EnvScheme scheme, Collection<String> analysts) {
        super(PanelType.ENV);
        this.scheme = scheme;
        if (analysts != null) {
            this.analysts = new LinkedList<String>(analysts);
        }
        if (prefs == null) {
            return;
        }
        String[] s = prefs.split("\\|");
        block12: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.columnWidth = Float.parseFloat(s[i]);
                    continue block12;
                }
                case 1: {
                    this.drawIntervals = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 2: {
                    this.drawAllClasses = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 3: {
                    this.drawAnalyses = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 4: {
                    this.analyWidth = Float.parseFloat(s[i]);
                    continue block12;
                }
                case 5: {
                    if (!s[i].contains(",")) continue block12;
                    this.analyColour = ColourUtils.getColour((String)s[i]);
                    continue block12;
                }
                case 6: {
                    this.drawIPSBathy = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 7: {
                    this.stackColumns = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 8: {
                    this.drawQualifiers = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 9: {
                    this.commentsCol = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), DEFAULT_COMMENT_WIDTH, true);
                }
            }
        }
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + this.analyWidth, "" + (this.drawAllClasses ? 1 : 0), "" + (this.drawAnalyses ? 1 : 0), "" + (this.drawIntervals ? 1 : 0), ColourUtils.DBColourString((Color)this.analyColour, (boolean)true, (boolean)false), "" + (this.drawIPSBathy ? 1 : 0), "" + (this.stackColumns ? 1 : 0), "" + (this.drawQualifiers ? 1 : 0)};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.scheme;
            }
            case 1: {
                return (int)this.columnWidth;
            }
            case 2: {
                return this.drawIntervals;
            }
            case 3: {
                return this.drawAllClasses;
            }
            case 4: {
                return this.drawAnalyses;
            }
            case 5: {
                return Float.valueOf(this.analyWidth);
            }
            case 6: {
                return this.analyColour;
            }
            case 7: {
                return this.analysts;
            }
            case 8: {
                return this.drawIPSBathy;
            }
            case 9: {
                return this.stackColumns;
            }
            case 10: {
                return this.drawQualifiers;
            }
            case 11: {
                return this.commentsCol;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    this.scheme = (EnvScheme)prop;
                    break;
                }
                case 1: {
                    return this.setColumnWidth(prop);
                }
                case 2: {
                    this.drawIntervals = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.drawAllClasses = (Boolean)prop;
                    if (!this.drawIPSBathy) break;
                    this.drawAllClasses = true;
                    break;
                }
                case 4: {
                    this.drawAnalyses = (Boolean)prop;
                    break;
                }
                case 5: {
                    return this.setAnalyWidth(prop);
                }
                case 6: {
                    this.analyColour = (Color)prop;
                    break;
                }
                case 7: {
                    if (prop instanceof Collection) {
                        this.analysts = new LinkedList<String>((Collection)prop);
                        Collections.sort(this.analysts);
                        if (!this.analysts.isEmpty()) break;
                        this.analysts = null;
                        break;
                    }
                    this.analysts = null;
                    break;
                }
                case 8: {
                    this.drawIPSBathy = (Boolean)prop;
                    if (!this.drawIPSBathy) break;
                    this.drawAllClasses = true;
                    break;
                }
                case 9: {
                    this.stackColumns = (Boolean)prop;
                    if (!this.stackColumns) break;
                    this.drawIPSBathy = false;
                    this.drawIntervals = true;
                    this.drawAllClasses = true;
                    this.drawAnalyses = false;
                    this.drawQualifiers = false;
                    break;
                }
                case 10: {
                    this.drawQualifiers = (Boolean)prop;
                    break;
                }
                case 11: {
                    if (prop == null) {
                        this.commentsCol.showColumn(false);
                        break;
                    }
                    this.commentsCol = (PanelProperties.ColumnWidth)prop;
                }
            }
            return true;
        }
        return false;
    }

    private boolean setColumnWidth(Object o) {
        float width = o instanceof Float ? ((Float)o).floatValue() : Float.parseFloat(o.toString());
        if (width >= 3.0f && (double)Math.abs(this.columnWidth - width) >= 0.1) {
            this.columnWidth = width;
            return true;
        }
        return false;
    }

    private boolean setAnalyWidth(Object o) {
        float width = o instanceof Float ? ((Float)o).floatValue() : Float.parseFloat(o.toString());
        if ((double)width >= 0.1 && (double)Math.abs(this.analyWidth - width) >= 0.1) {
            this.analyWidth = width;
            return true;
        }
        return false;
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 5: 
            case 6: 
            case 7: {
                return this.drawAnalyses;
            }
            case 10: {
                return !this.stackColumns;
            }
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int row) {
        switch (row) {
            case 4: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    PanelEnvProperties() {
        super(PanelType.ENV);
    }

    public static PanelEnvProperties createCopy(PanelEnvProperties rhs) {
        PanelEnvProperties p = new PanelEnvProperties();
        p.copy(rhs);
        return p;
    }

    @Override
    public PanelProperties copy() {
        return PanelEnvProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        Object string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + (this.drawIntervals ? 1 : 0), "" + (this.drawAllClasses ? 1 : 0), "" + (this.drawAnalyses ? 1 : 0), "" + this.analyWidth, ColourUtils.DBColourString((Color)this.analyColour, (boolean)true, (boolean)false), "" + (this.drawIPSBathy ? 1 : 0), "" + (this.stackColumns ? 1 : 0), "" + (this.drawQualifiers ? 1 : 0), "" + this.commentsCol.width()};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public int getEnvSchID() {
        if (this.scheme != null) {
            return this.scheme.getID();
        }
        return super.getEnvSchID();
    }

    @Override
    public List<String> getAnalystList() {
        if (this.analysts != null && this.analysts.isEmpty() || !this.drawAnalyses) {
            this.analysts = null;
        }
        return this.analysts;
    }

    boolean useAnalyst(String analyst) {
        if (this.analysts == null) {
            return true;
        }
        return this.analysts.contains(analyst);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelEnvProperties)) {
            throw new IllegalArgumentException("PanelEnvProperties cannot copy " + String.valueOf(pp));
        }
        PanelEnvProperties rhs = (PanelEnvProperties)pp;
        block3: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 7: {
                    this.analysts = rhs.analysts != null ? new LinkedList<String>(rhs.analysts) : null;
                    continue block3;
                }
                default: {
                    this.setProperty(i, rhs.getProperty(i));
                }
            }
        }
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return EnvScheme.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                return Boolean.class;
            }
            case 5: {
                return Float.class;
            }
            case 6: {
                return Color.class;
            }
            case 7: {
                return Userdef[].class;
            }
            case 11: {
                return PanelProperties.ColumnWidth.class;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean allowNull(int nProp) {
        if (nProp == 0) {
            return true;
        }
        return super.allowNull(nProp);
    }

    @Override
    public boolean equalsLegacyPanelProperties(PanelProperties legacyProperties) {
        if (!(legacyProperties instanceof PanelEnvProperties)) {
            return false;
        }
        PanelEnvProperties rhs = (PanelEnvProperties)legacyProperties;
        for (int i = 0; i < this.getnProps(); ++i) {
            Object iProp2;
            Object iProp1;
            if (i == 6 || Objects.equals(iProp1 = this.getProperty(i), iProp2 = ((PanelProperties)rhs).getProperty(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Float.floatToIntBits(this.columnWidth);
        hash = 73 * hash + (this.drawIntervals ? 1 : 0);
        hash = 73 * hash + (this.drawAllClasses ? 1 : 0);
        hash = 73 * hash + (this.drawAnalyses ? 1 : 0);
        hash = 73 * hash + Float.floatToIntBits(this.analyWidth);
        hash = 73 * hash + Objects.hashCode(this.analyColour);
        hash = 73 * hash + Objects.hashCode(this.analysts);
        hash = 73 * hash + Objects.hashCode(this.scheme);
        hash = 73 * hash + (this.drawIPSBathy ? 1 : 0);
        hash = 73 * hash + (this.stackColumns ? 1 : 0);
        hash = 73 * hash + (this.drawQualifiers ? 1 : 0);
        hash = 73 * hash + Objects.hashCode(this.commentsCol);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelEnvProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelEnvProperties rhs = (PanelEnvProperties)comp;
        block6: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 1: {
                    if (!(Math.abs(this.columnWidth - rhs.columnWidth) > 3.0f)) continue block6;
                    return false;
                }
                case 5: {
                    if (!(Math.abs(this.analyWidth - rhs.analyWidth) > 1.0f)) continue block6;
                    return false;
                }
                case 6: {
                    continue block6;
                }
                case 11: {
                    if (this.commentsCol.isSimilarTo(rhs.commentsCol)) continue block6;
                    return false;
                }
                default: {
                    Object iProp1 = this.getProperty(i);
                    Object iProp2 = rhs.getProperty(i);
                    if (Objects.equals(iProp1, iProp2)) continue block6;
                    return false;
                }
            }
        }
        return true;
    }
}

