/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelEventsBase;
import jsbchart.panel.PanelEventsProperties;
import jsbchart.util.ChartObject;
import jsbchart.util.ChartObjectCompareDepth;
import model3.CompositeStandardEvent;
import model3.InterpHdr;
import model3.SBdb;
import model3.Sample;
import model3.SbugsSampleObject;
import model3.WellEvent;
import model3.WellInterp;
import model3.WsWell;
import util.DepthUtils;
import util.SBException;

public class PanelEvents
extends PanelEventsBase
implements Observer {
    final WellBlock block;

    PanelEvents(PanelTemplate template, PanelOcc panelOcc, WellBlock block) throws SQLException, SBException {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelEventsProperties)template.getProperties();
        this.init();
    }

    private void init() throws SBException, SQLException {
        if (this.block.getWell() != null) {
            this.block.getWell().loadInterps();
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            this.block.getWell().loadInterp(interp);
            interp.addWeakObserver((Observer)this);
        }
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Iterator it;
        if (this.movedPositions == null) {
            return null;
        }
        float BRACKET = 2.5f / zoom;
        boolean list2 = this.separate && x > this.getWidth(bp) / 2.0f;
        int i = 0;
        Iterator iterator = it = list2 ? this.chartObjects2.iterator() : this.chartObjects.iterator();
        while (it.hasNext()) {
            float symbolSize;
            ChartObject chartObject = (ChartObject)it.next();
            float yPos = list2 ? this.movedPositions2[i] : this.movedPositions[i];
            float f = symbolSize = list2 ? this.symbolSizes2[i] : this.symbolSizes[i];
            if (y > yPos - BRACKET && y < yPos + symbolSize) {
                List list;
                if (bp != this.block.getProp()) {
                    try {
                        if (chartObject.getDepth() < (double)bp.getMin() || chartObject.getDepth() > (double)bp.getMax()) {
                            continue;
                        }
                    }
                    catch (SBException sbe) {
                        sbe.printStackTrace();
                        return null;
                    }
                }
                if ((list = (List)chartObject.getO()).size() == 1) {
                    return list.get(0);
                }
                if (y > yPos - BRACKET && y <= yPos) {
                    return list.get(0);
                }
                float rowHeight = symbolSize / (float)list.size();
                for (int j = 0; j < list.size(); ++j) {
                    if (!(y > yPos + (float)j * rowHeight) || !(y < yPos + (float)(j + 1) * rowHeight)) continue;
                    return list.get(j);
                }
                return list.get(list.size() - 1);
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        Object name = "Events";
        try {
            if (this.block != null && this.getInterpID(this.block) >= 0 && this.block.getWell() != null) {
                name = (String)name + " : " + String.valueOf(this.block.getWell().getInterp(this.getInterpID(this.block)));
            }
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return name;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null && o instanceof EventPair) {
            return ((EventPair)o).e1.toString(false, true, true, bp.getUnits(), true, false, false) + " (combined)";
        }
        if (o != null && o instanceof WellEvent) {
            return ((WellEvent)o).toString(true, true, true, bp.getUnits(), true, false, false);
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp) {
            if (((WellInterp)o).getHeader().getInterpID() == this.getInterpID(this.block)) {
                if (arg != null && (arg instanceof WellEvent || arg.getClass() == Integer.class && (Integer)arg == 20)) {
                    this.setDataChanged();
                    this.notifyListeners();
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    @Override
    public int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        int nSamples = 0;
        LinkedList<List> lists = new LinkedList<List>();
        lists.add(this.chartObjects);
        if (this.chartObjects2 != null) {
            lists.add(this.chartObjects2);
        }
        for (List list : lists) {
            for (ChartObject pe : list) {
                try {
                    ++nSamples;
                    Sample.insert(samples, (Sample)pe.getSample(), (char)this.block.getProp().getUnits());
                }
                catch (SBException sBException) {}
            }
        }
        return nSamples;
    }

    @Override
    public String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        Sample sample = samples.get(index);
        int targetSampID = sample.getSampID();
        Object row = "";
        for (ChartObject chartObject : this.chartObjects) {
            for (Object o : (List)chartObject.getO()) {
                if (((SbugsSampleObject)o).getSample().getSampID() != targetSampID) continue;
                ArrayList<WellEvent> eventsAtSample = new ArrayList<WellEvent>();
                if (o instanceof EventPair) {
                    EventPair ep = (EventPair)o;
                    eventsAtSample.add(ep.e1);
                    eventsAtSample.add(ep.e2);
                } else {
                    eventsAtSample.add((WellEvent)o);
                }
                for (WellEvent event : eventsAtSample) {
                    if (!((String)row).isEmpty()) {
                        row = (String)row + "<br>";
                    }
                    if (this.p.useColours()) {
                        row = (String)row + PanelEvents.getHTMLFontColour(this.p.getColor(event.getDiscipline()));
                    }
                    row = (String)row + event.toString(true, true, false);
                    if (!this.p.useColours()) continue;
                    row = (String)row + "</font>";
                }
            }
        }
        if (!((String)row).isEmpty() && this.p.showDepths()) {
            row = sample.toString(this.block.getProp().getUnits(), false, false) + "<br>" + (String)row;
        }
        return "<td>" + (String)row + "</td>";
    }

    @Override
    protected String getDepthString(Object o, ChartProperties cp) throws SBException {
        Object depth = "";
        if (o instanceof EventPair) {
            o = ((EventPair)o).e1;
        }
        if (o instanceof WellEvent) {
            WellEvent event = (WellEvent)o;
            try {
                double corrSampleDepth = this.block.getWell().getDepth(event.getSample(), cp.correctDepths, cp.correctCuttings);
                if (this.block.getProp().getWorkingLabelScaleType() == BlockProperties.ScaleType.TVD) {
                    corrSampleDepth = this.getBlock().getWell().getTVDlist(false).getTVD(corrSampleDepth).getTVDepth();
                }
                depth = Sample.roundSampleDepth((double)DepthUtils.convFromM((double)corrSampleDepth, (char)this.block.getProp().getUnits()), (SampleType)event.getSample().getType());
            }
            catch (SQLException e) {
                throw new SBException(e.getMessage());
            }
        } else if (o instanceof PanelEventsBase.TemplateEvent) {
            PanelEventsBase.TemplateEvent event = (PanelEventsBase.TemplateEvent)o;
            depth = Sample.roundSampleDepth((double)DepthUtils.convFromM((double)event.sample.getDepth(), (char)this.block.getProp().getUnits()), (SampleType)event.sample.getType());
        }
        if (this.block.getWell() != null && this.block.getWell().getHeader().getSectionType() == SectionType.OUTCROP) {
            if (((String)(depth = ((String)depth).trim())).charAt(0) == '-') {
                depth = ((String)depth).substring(1);
            } else if (!(((String)depth).equals("0.0") || ((String)depth).equals("0") || ((String)depth).equals("0.00"))) {
                depth = "-" + (String)depth;
            }
        }
        return depth;
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        ScaleConverter sc = this.block.getScaleConverter();
        if (!g.isVisible(x, (bp == this.block.getProp() ? 0.0f : this.block.scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), sc)) + y + this.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight()) && !cp.keyIsVisible()) {
            return x + this.getWidth(bp);
        }
        this.drawSeaBed(g, cp, bp, this.block, sc, x, y + this.getPanelHeaderHeight(cp, mode));
        if (this.getInterpID(this.block) < 0 || this.chartObjects == null || this.chartObjects.isEmpty() && (this.chartObjects2 == null || this.chartObjects2.isEmpty())) {
            return x + this.getWidth(bp);
        }
        g.setFont(cp.font, 0, cp.getFontSize(this.p.fontSize));
        g.setStroke(0.1f);
        if (this.p.showCommentsColumn) {
            g.setColor(cp.foreground);
            g.drawLine(x + this.p.columnWidth, y + this.getPanelHeaderHeight(cp, mode), x + this.p.columnWidth, y + this.getPanelHeaderHeight(cp, mode) + bp.getHeight());
        }
        try {
            LinkedList compositeList = new LinkedList();
            compositeList.addAll(this.chartObjects);
            if (this.chartObjects2 != null) {
                compositeList.addAll(this.chartObjects2);
            }
            Iterator it = compositeList.iterator();
            int i1 = 0;
            int i2 = 0;
            while (it.hasNext()) {
                ChartObject chartObject = (ChartObject)it.next();
                List events = (List)chartObject.getO();
                EventType type = PanelEvents.getEventType(events.get(0));
                if (bp != this.block.getProp()) {
                    if (chartObject.getDepth() + (double)0.0029f < (double)bp.getMin()) {
                        if (this.separate && type == EventType.BASE) {
                            ++i2;
                            continue;
                        }
                        ++i1;
                        continue;
                    }
                    if (chartObject.getDepth() - (double)0.0029f > (double)bp.getMax()) break;
                }
                this.drawEvents(g, cp, mode, x, y, this.separate && type == EventType.BASE ? i2 : i1, chartObject, this.block.getProp().getUnits(), cLines.get(CorrelationType.EVENT));
                if (this.separate && type == EventType.BASE) {
                    ++i2;
                    continue;
                }
                ++i1;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in Event plotting: " + e.getMessage());
            e.printStackTrace();
        }
        g.setColor(Color.BLACK);
        return x + this.p.panelWidth();
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        this.setData(cp, this.block.getProp(), sections, null);
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return "Events";
    }

    @Override
    protected String getSubCaption() {
        InterpHdr hdr = this.block.getVersion(this.getInterpID(this.block));
        Object subCap = "";
        if (hdr != null && hdr.getInterpID() > 0) {
            subCap = hdr.toString();
        }
        if (this.p.getCmpStd() != null) {
            subCap = (String)subCap + " (" + this.p.getCmpStd().getName() + ")";
        }
        return ((String)(subCap = ((String)subCap).trim())).isEmpty() ? null : subCap;
    }

    @Override
    List<ChartObject> getChartObjects(ChartProperties cp) throws SBException, SQLException {
        if (this.block.getWell() == null) {
            return this.getTemplateEvents(cp);
        }
        if (this.p.getCmpStd() != null) {
            this.p.getCmpStd().loadEvents();
        }
        ScaleConverter sc = this.block.getScaleConverter();
        LinkedList<ChartObject> compositeList = new LinkedList<ChartObject>();
        for (WellEvent event : this.block.getWell().getInterp(this.getInterpID(this.block)).getEventsByDepth()) {
            double correctedDepth;
            if (!this.p.plotEventDisc(event.getDiscIDTaxon()) || !this.p.plotEventCategory(event.getEvent().getCatMnem()) || !this.p.plotEventType(event.getCharType()) || event.getConfidence().getDBint() > this.p.maxUnconfidence || event.getConfidence().getDBint() < this.p.minUnconfidence) continue;
            if (this.p.cmpStdExclude() != PanelEventsProperties.EventFilter.INCLUDE_ALL && this.p.getCmpStd() != null) {
                boolean hasEvent = this.p.getCmpStd().hasEvent(new CompositeStandardEvent.Builder().event(event.getEvent()).type(event.getTypeObj()), null, true);
                if (this.p.cmpStdExclude() == PanelEventsProperties.EventFilter.EXCLUDE_CMPSTDEV && hasEvent || this.p.cmpStdExclude() == PanelEventsProperties.EventFilter.INCLUDE_ONLY_CMPSTDEV && !hasEvent) continue;
            }
            if (!sc.isWithinPlottableRange(correctedDepth = this.block.getWell().getDepth(event.getSample(), cp.correctDepths, cp.correctCuttings))) continue;
            float yPos = this.block.scaleMeasuredDepth(correctedDepth, sc);
            ChartObject<WellEvent> cObj = new ChartObject<WellEvent>(event, yPos);
            if (Math.abs(correctedDepth - event.getSample().getDepth()) > (double)0.0029f) {
                cObj.setCorrDepth(correctedDepth);
            }
            compositeList.add(cObj);
        }
        Collections.sort(compositeList, new ChartObjectCompareDepth());
        return compositeList;
    }

    @Override
    void addEvents(ChartProperties cp, List<ChartObject> compositeList) throws SBException, SQLException {
        class ChartObjectCompounder {
            ChartObjectCompounder(PanelEvents this$0) {
                Objects.requireNonNull(this$0);
            }

            ChartObject createChartObject(LinkedList<ChartObject> list) {
                LinkedList events = new LinkedList();
                for (ChartObject co : list) {
                    events.add(co.getO());
                }
                ChartObject listObject = new ChartObject(events, list.getLast().getyPos());
                listObject.setCorrDepth(list.getLast().getCorrDepth());
                return listObject;
            }
        }
        ChartObjectCompounder compounder = new ChartObjectCompounder(this);
        LinkedList<ChartObject> compositeList2 = new LinkedList<ChartObject>();
        LinkedList<ChartObject> listWithCombined = new LinkedList<ChartObject>();
        block0: for (ChartObject chartObject : compositeList) {
            ListIterator<ChartObject<EventPair>> littleIt = listWithCombined.listIterator();
            while (littleIt.hasNext()) {
                ChartObject co = (ChartObject)littleIt.next();
                if (chartObject == co || co.getO() instanceof EventPair || !(co.getO() instanceof WellEvent) || !(chartObject.getO() instanceof WellEvent) || PanelEvents.getEventSample(chartObject.getO()) != PanelEvents.getEventSample(co.getO()) || PanelEvents.getEventID(co.getO()) != PanelEvents.getEventID(chartObject.getO()) || PanelEvents.getEventType(co.getO()) == PanelEvents.getEventType(chartObject.getO())) continue;
                littleIt.remove();
                ChartObject<EventPair> combinedObj = new ChartObject<EventPair>(new EventPair((WellEvent)co.getO(), (WellEvent)chartObject.getO()), chartObject.getyPos());
                combinedObj.setCorrDepth(chartObject.getCorrDepth());
                littleIt.add(combinedObj);
                continue block0;
            }
            listWithCombined.add(chartObject);
        }
        LinkedList<ChartObject<Object>> list = null;
        for (ChartObject chartObject : listWithCombined) {
            if (list == null) {
                list = new LinkedList<ChartObject>();
                list.add(chartObject);
                continue;
            }
            Object lastObject = ((ChartObject)list.getLast()).getO();
            if (PanelEvents.getEventSample(chartObject.getO()) == PanelEvents.getEventSample(lastObject) && PanelEvents.getEventType(chartObject.getO()) == PanelEvents.getEventType(lastObject)) {
                list.add(chartObject);
                continue;
            }
            compositeList2.add(compounder.createChartObject(list));
            list = new LinkedList();
            list.add(chartObject);
        }
        if (list != null && !list.isEmpty()) {
            compositeList2.add(compounder.createChartObject((LinkedList<ChartObject>)list));
        }
        for (ChartObject co : compositeList2) {
            if (this.separate) {
                EventType type = PanelEvents.getEventType(co.getO());
                if (type == EventType.BASE) {
                    this.chartObjects2.add(co);
                    continue;
                }
                this.chartObjects.add(co);
                continue;
            }
            this.chartObjects.add(co);
        }
    }

    private List<ChartObject> getTemplateEvents(ChartProperties cp) {
        LinkedList<Sample> templateSamples = this.block.getTemplateSamples();
        LinkedList<ChartObject> list = new LinkedList<ChartObject>();
        ScaleConverter sc = this.block.getScaleConverter(null);
        block7: for (int i = 0; i < templateSamples.size(); ++i) {
            Sample s = templateSamples.get(i);
            float ypos = this.block.scaleMeasuredDepth(s.getDepth(), sc);
            switch (i) {
                case 0: {
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.TOP, "species A", s, Discipline.MICRO), ypos));
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.TOP, "species B", s, Discipline.MICRO), ypos));
                    continue block7;
                }
                case 1: {
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.BASE, "Rosalia spp [C]", s, Discipline.MICRO), ypos));
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.TOP, "Event 2", s, Discipline.NANNO), ypos));
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.TOP, "Abundance peak of Y", s, Discipline.PALY), ypos));
                    continue block7;
                }
                case 2: {
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.TOP, "Acme Genus spp.", s, Discipline.NANNO), ypos));
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.BASE, "species B", s, Discipline.MICRO), ypos));
                    continue block7;
                }
                case 3: {
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.BASE, "species A", s, Discipline.MICRO), ypos));
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.BASE, "Abundance peak of Y", s, Discipline.PALY), ypos));
                    continue block7;
                }
                case 4: {
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.SINGLE, "Band X", s, Discipline.PALY), ypos));
                    continue block7;
                }
                default: {
                    list.add(new ChartObject<PanelEventsBase.TemplateEvent>(new PanelEventsBase.TemplateEvent(EventType.TOP, "Event", s, Discipline.PALY), ypos));
                }
            }
        }
        return list;
    }

    @Override
    float gethPosition(ChartProperties cp, BlockProperties bp) {
        return this.block.scaleLimitOfPlottableRange(this.block.getScaleConverter(), IBlockProperties.ScaleLimitType.MIN) + cp.getFontSize(this.p.fontSize) / 2.0f;
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    private static Sample getEventSample(Object o) {
        if (o instanceof EventPair) {
            o = ((EventPair)o).e1;
        }
        if (o instanceof WellEvent) {
            return ((WellEvent)o).getSample();
        }
        if (o instanceof PanelEventsBase.TemplateEvent) {
            return ((PanelEventsBase.TemplateEvent)o).sample;
        }
        throw new IllegalArgumentException("Unexpected object: " + String.valueOf(o));
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.chartObjects == null && this.chartObjects2 == null) {
            return null;
        }
        LinkedList objs = new LinkedList();
        objs.addAll(this.chartObjects);
        if (this.chartObjects2 != null) {
            objs.addAll(this.chartObjects2);
        }
        if (objs.isEmpty()) {
            return null;
        }
        Collections.sort(objs);
        try {
            return Float.valueOf(upper ? (float)((ChartObject)objs.get(0)).getDepth() : (float)((ChartObject)objs.get(objs.size() - 1)).getDepth());
        }
        catch (SBException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        ArrayList<WellEvent> dbEvents = new ArrayList<WellEvent>();
        if (this.chartObjects != null) {
            List chartObjectsList = this.chartObjects;
            for (ChartObject o : chartObjectsList) {
                for (Object e : (List)o.getO()) {
                    if (e instanceof EventPair) {
                        EventPair p = (EventPair)e;
                        dbEvents.add(p.e1);
                        dbEvents.add(p.e2);
                        continue;
                    }
                    dbEvents.add((WellEvent)e);
                }
            }
        }
        if (this.chartObjects2 != null) {
            List chartObjectsList2 = this.chartObjects2;
            for (ChartObject o : chartObjectsList2) {
                for (Object e : (List)o.getO()) {
                    dbEvents.add((WellEvent)e);
                }
            }
        }
        if (!dbEvents.isEmpty()) {
            WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
            wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillEvents(wsWell, true, dbEvents.toArray(new WellEvent[dbEvents.size()]));
            dataTypes.add(16);
        }
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        return this.chartObjects != null && !this.chartObjects.isEmpty() || this.chartObjects2 != null && !this.chartObjects2.isEmpty();
    }

    static class EventPair
    implements SbugsSampleObject {
        final WellEvent e1;
        final WellEvent e2;

        EventPair(WellEvent e1, WellEvent e2) {
            if (e1.getSampID() != e2.getSampID()) {
                throw new IllegalStateException("Incorrect use of EventPair");
            }
            if (e1.getEvent().getEvID() != e2.getEvent().getEvID()) {
                throw new IllegalStateException("Incorrect use of EventPair");
            }
            this.e1 = e1;
            this.e2 = e2;
        }

        public Sample getSample() {
            return this.e1.getSample();
        }
    }
}

